/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.kylin.cube.CubeCapabilityChecker;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.LookupDesc;
import org.apache.kylin.metadata.realization.IRealization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinChecker {
    private static final Logger logger = LoggerFactory.getLogger(CubeCapabilityChecker.class);

    public static boolean isJoinMatch(Collection<JoinDesc> joins, IRealization realization) {
        ArrayList realizationsJoins = Lists.newArrayList();
        for (LookupDesc lookupDesc : realization.getDataModelDesc().getLookups()) {
            realizationsJoins.add(lookupDesc.getJoin());
        }
        for (JoinDesc j : joins) {
            String fTable;
            String pTable = j.getPrimaryKeyColumns()[0].getTable();
            String factTable = realization.getFactTable();
            if (factTable.equals(pTable)) {
                j.swapPKFK();
            }
            if (!factTable.equals(fTable = j.getForeignKeyColumns()[0].getTable())) {
                logger.info("Fact Table" + factTable + " not matched in join: " + j + " on cube " + realization.getName());
                return false;
            }
            if (realizationsJoins.contains(j)) continue;
            logger.info("Query joins don't macth on cube " + realization.getName());
            return false;
        }
        return true;
    }
}

