/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeValidator {
    private static final Logger logger = LoggerFactory.getLogger(CubeValidator.class);

    public static void validate(Collection<CubeSegment> segments) {
        if (segments == null || segments.isEmpty()) {
            return;
        }
        ArrayList all = Lists.newArrayList(segments);
        Collections.sort(all);
        boolean isOffsetsOn = ((CubeSegment)all.get(0)).isSourceOffsetsOn();
        for (CubeSegment seg : all) {
            seg.validate();
            if (seg.isSourceOffsetsOn() == isOffsetsOn) continue;
            throw new IllegalStateException("Inconsistent isOffsetsOn for segment " + seg);
        }
        ArrayList ready = Lists.newArrayListWithCapacity((int)all.size());
        ArrayList news = Lists.newArrayListWithCapacity((int)all.size());
        for (CubeSegment seg : all) {
            if (seg.getStatus() == SegmentStatusEnum.READY) {
                ready.add(seg);
                continue;
            }
            news.add(seg);
        }
        CubeSegment pre = null;
        for (CubeSegment seg : ready) {
            if (pre != null) {
                if (pre.sourceOffsetOverlaps(seg)) {
                    throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
                }
                if (pre.getSourceOffsetEnd() < seg.getSourceOffsetStart()) {
                    logger.warn("Hole between adjacent READY segments " + pre + " and " + seg);
                }
            }
            pre = seg;
        }
        pre = null;
        for (CubeSegment seg : news) {
            if (pre != null && pre.sourceOffsetOverlaps(seg)) {
                throw new IllegalStateException("Segments overlap: " + pre + " and " + seg);
            }
            pre = seg;
            for (CubeSegment aReady : ready) {
                if (!seg.sourceOffsetOverlaps(aReady) || seg.sourceOffsetContains(aReady)) continue;
                throw new IllegalStateException("Segments overlap: " + aReady + " and " + seg);
            }
        }
        for (CubeSegment seg : news) {
            Pair<Boolean, Boolean> pair = CubeValidator.fitInSegments(all, seg);
            boolean startFit = pair.getFirst();
            boolean endFit = pair.getSecond();
            if (!startFit) {
                logger.warn("NEW segment start does not fit/connect with other segments: " + seg);
            }
            if (endFit) continue;
            logger.warn("NEW segment end does not fit/connect with other segments: " + seg);
        }
    }

    public static Pair<Boolean, Boolean> fitInSegments(List<CubeSegment> segments, CubeSegment newOne) {
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        CubeSegment first = segments.get(0);
        CubeSegment last = segments.get(segments.size() - 1);
        long start = newOne.getSourceOffsetStart();
        long end = newOne.getSourceOffsetEnd();
        boolean startFit = false;
        boolean endFit = false;
        for (CubeSegment sss : segments) {
            if (sss == newOne) continue;
            startFit = startFit || start == sss.getSourceOffsetStart() || start == sss.getSourceOffsetEnd();
            endFit = endFit || end == sss.getSourceOffsetStart() || end == sss.getSourceOffsetEnd();
        }
        if (!startFit && endFit && newOne == first) {
            startFit = true;
        }
        if (!endFit && startFit && newOne == last) {
            endFit = true;
        }
        return Pair.newPair(startFit, endFit);
    }
}

