/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Dictionary;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.ISegment;
import org.apache.kylin.cube.kv.CubeDimEncMap;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.IRealization;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class CubeSegment
implements Comparable<CubeSegment>,
IBuildable,
ISegment {
    @JsonBackReference
    private CubeInstance cubeInstance;
    @JsonProperty(value="uuid")
    private String uuid;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="storage_location_identifier")
    private String storageLocationIdentifier;
    @JsonProperty(value="date_range_start")
    private long dateRangeStart;
    @JsonProperty(value="date_range_end")
    private long dateRangeEnd;
    @JsonProperty(value="source_offset_start")
    private long sourceOffsetStart;
    @JsonProperty(value="source_offset_end")
    private long sourceOffsetEnd;
    @JsonProperty(value="status")
    private SegmentStatusEnum status;
    @JsonProperty(value="size_kb")
    private long sizeKB;
    @JsonProperty(value="input_records")
    private long inputRecords;
    @JsonProperty(value="input_records_size")
    private long inputRecordsSize;
    @JsonProperty(value="last_build_time")
    private long lastBuildTime;
    @JsonProperty(value="last_build_job_id")
    private String lastBuildJobID;
    @JsonProperty(value="create_time_utc")
    private long createTimeUTC;
    @JsonProperty(value="cuboid_shard_nums")
    private Map<Long, Short> cuboidShardNums = Maps.newHashMap();
    @JsonProperty(value="total_shards")
    private int totalShards = 0;
    @JsonProperty(value="blackout_cuboids")
    private List<Long> blackoutCuboids = Lists.newArrayList();
    @JsonProperty(value="binary_signature")
    private String binarySignature;
    @JsonProperty(value="dictionaries")
    private ConcurrentHashMap<String, String> dictionaries;
    @JsonProperty(value="snapshots")
    private ConcurrentHashMap<String, String> snapshots;
    @JsonProperty(value="index_path")
    private String indexPath;
    @JsonProperty(value="rowkey_stats")
    private List<Object[]> rowkeyStats = Lists.newArrayList();
    @JsonProperty(value="additionalInfo")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private HashMap<String, String> additionalInfo = new LinkedHashMap<String, String>();
    private volatile Map<Long, Short> cuboidBaseShards = Maps.newHashMap();

    public CubeDesc getCubeDesc() {
        return this.getCubeInstance().getDescriptor();
    }

    public static String makeSegmentName(long startDate, long endDate, long startOffset, long endOffset) {
        if (startOffset != 0L || endOffset != 0L) {
            if (startOffset == 0L && (endOffset == 0L || endOffset == Long.MAX_VALUE)) {
                return "FULL_BUILD";
            }
            return startOffset + "_" + endOffset;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return dateFormat.format(startDate) + "_" + dateFormat.format(endDate);
    }

    public KylinConfig getConfig() {
        return this.cubeInstance.getConfig();
    }

    public String getUuid() {
        return this.uuid;
    }

    public void setUuid(String id) {
        this.uuid = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getDateRangeStart() {
        return this.dateRangeStart;
    }

    public void setDateRangeStart(long dateRangeStart) {
        this.dateRangeStart = dateRangeStart;
    }

    @Override
    public long getDateRangeEnd() {
        return this.dateRangeEnd;
    }

    public void setDateRangeEnd(long dateRangeEnd) {
        this.dateRangeEnd = dateRangeEnd;
    }

    @Override
    public SegmentStatusEnum getStatus() {
        return this.status;
    }

    @Override
    public DataModelDesc getModel() {
        return this.getCubeDesc().getModel();
    }

    public void setStatus(SegmentStatusEnum status) {
        this.status = status;
    }

    public long getSizeKB() {
        return this.sizeKB;
    }

    public void setSizeKB(long sizeKB) {
        this.sizeKB = sizeKB;
    }

    public long getInputRecords() {
        return this.inputRecords;
    }

    public void setInputRecords(long inputRecords) {
        this.inputRecords = inputRecords;
    }

    public long getInputRecordsSize() {
        return this.inputRecordsSize;
    }

    public void setInputRecordsSize(long inputRecordsSize) {
        this.inputRecordsSize = inputRecordsSize;
    }

    public long getLastBuildTime() {
        return this.lastBuildTime;
    }

    public void setLastBuildTime(long lastBuildTime) {
        this.lastBuildTime = lastBuildTime;
    }

    public String getLastBuildJobID() {
        return this.lastBuildJobID;
    }

    public void setLastBuildJobID(String lastBuildJobID) {
        this.lastBuildJobID = lastBuildJobID;
    }

    public long getCreateTimeUTC() {
        return this.createTimeUTC;
    }

    public void setCreateTimeUTC(long createTimeUTC) {
        this.createTimeUTC = createTimeUTC;
    }

    public String getBinarySignature() {
        return this.binarySignature;
    }

    public void setBinarySignature(String binarySignature) {
        this.binarySignature = binarySignature;
    }

    public CubeInstance getCubeInstance() {
        return this.cubeInstance;
    }

    public void setCubeInstance(CubeInstance cubeInstance) {
        this.cubeInstance = cubeInstance;
    }

    public String getStorageLocationIdentifier() {
        return this.storageLocationIdentifier;
    }

    public List<Object[]> getRowkeyStats() {
        return this.rowkeyStats;
    }

    public Map<String, String> getDictionaries() {
        if (this.dictionaries == null) {
            this.dictionaries = new ConcurrentHashMap();
        }
        return this.dictionaries;
    }

    public Map<String, String> getSnapshots() {
        if (this.snapshots == null) {
            this.snapshots = new ConcurrentHashMap();
        }
        return this.snapshots;
    }

    public String getSnapshotResPath(String table) {
        return this.getSnapshots().get(table);
    }

    public void putSnapshotResPath(String table, String snapshotResPath) {
        this.getSnapshots().put(table, snapshotResPath);
    }

    public Collection<String> getDictionaryPaths() {
        return this.getDictionaries().values();
    }

    public Collection<String> getSnapshotPaths() {
        return this.getSnapshots().values();
    }

    public String getDictResPath(TblColRef col) {
        return this.getDictionaries().get(this.dictKey(col));
    }

    public void putDictResPath(TblColRef col, String dictResPath) {
        this.getDictionaries().put(this.dictKey(col), dictResPath);
    }

    private String dictKey(TblColRef col) {
        return col.getTable() + "/" + col.getName();
    }

    public void setStorageLocationIdentifier(String storageLocationIdentifier) {
        this.storageLocationIdentifier = storageLocationIdentifier;
    }

    public Map<TblColRef, Dictionary<String>> buildDictionaryMap() {
        HashMap result = Maps.newHashMap();
        for (TblColRef col : this.getCubeDesc().getAllColumnsHaveDictionary()) {
            result.put(col, this.getDictionary(col));
        }
        return result;
    }

    public Dictionary<String> getDictionary(TblColRef col) {
        TblColRef reuseCol = this.getCubeDesc().getDictionaryReuseColumn(col);
        CubeManager cubeMgr = CubeManager.getInstance(this.getCubeInstance().getConfig());
        return cubeMgr.getDictionary(this, reuseCol);
    }

    public CubeDimEncMap getDimensionEncodingMap() {
        return new CubeDimEncMap(this);
    }

    public boolean isSourceOffsetsOn() {
        return this.sourceOffsetStart != 0L || this.sourceOffsetEnd != 0L;
    }

    @Override
    public long getSourceOffsetStart() {
        return this.isSourceOffsetsOn() ? this.sourceOffsetStart : this.dateRangeStart;
    }

    public void setSourceOffsetStart(long sourceOffsetStart) {
        this.sourceOffsetStart = sourceOffsetStart;
    }

    @Override
    public long getSourceOffsetEnd() {
        return this.isSourceOffsetsOn() ? this.sourceOffsetEnd : this.dateRangeEnd;
    }

    public void setSourceOffsetEnd(long sourceOffsetEnd) {
        this.sourceOffsetEnd = sourceOffsetEnd;
    }

    public boolean dateRangeOverlaps(CubeSegment seg) {
        return this.dateRangeStart < seg.dateRangeEnd && seg.dateRangeStart < this.dateRangeEnd;
    }

    public boolean dateRangeContains(CubeSegment seg) {
        return this.dateRangeStart <= seg.dateRangeStart && seg.dateRangeEnd <= this.dateRangeEnd;
    }

    public boolean sourceOffsetOverlaps(CubeSegment seg) {
        if (this.isSourceOffsetsOn()) {
            return this.sourceOffsetStart < seg.sourceOffsetEnd && seg.sourceOffsetStart < this.sourceOffsetEnd;
        }
        return this.dateRangeOverlaps(seg);
    }

    public boolean sourceOffsetContains(CubeSegment seg) {
        if (this.isSourceOffsetsOn()) {
            return this.sourceOffsetStart <= seg.sourceOffsetStart && seg.sourceOffsetEnd <= this.sourceOffsetEnd;
        }
        return this.dateRangeContains(seg);
    }

    public void validate() {
        if (this.cubeInstance.getDescriptor().getModel().getPartitionDesc().isPartitioned()) {
            if (!this.isSourceOffsetsOn() && this.dateRangeStart >= this.dateRangeEnd) {
                throw new IllegalStateException("Invalid segment, dateRangeStart(" + this.dateRangeStart + ") must be smaller than dateRangeEnd(" + this.dateRangeEnd + ") in segment " + this);
            }
            if (this.isSourceOffsetsOn() && this.sourceOffsetStart >= this.sourceOffsetEnd) {
                throw new IllegalStateException("Invalid segment, sourceOffsetStart(" + this.sourceOffsetStart + ") must be smaller than sourceOffsetEnd(" + this.sourceOffsetEnd + ") in segment " + this);
            }
        }
    }

    @Override
    public int compareTo(CubeSegment other) {
        long comp = this.getSourceOffsetStart() - other.getSourceOffsetStart();
        if (comp != 0L) {
            return comp < 0L ? -1 : 1;
        }
        comp = this.getSourceOffsetEnd() - other.getSourceOffsetEnd();
        if (comp != 0L) {
            return comp < 0L ? -1 : 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cubeInstance == null ? 0 : this.cubeInstance.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CubeSegment other = (CubeSegment)obj;
        if (this.cubeInstance == null ? other.cubeInstance != null : !this.cubeInstance.equals(other.cubeInstance)) {
            return false;
        }
        if (this.uuid == null ? other.uuid != null : !this.uuid.equals(other.uuid)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.status == other.status;
    }

    public String toString() {
        return this.cubeInstance.getName() + "[" + this.name + "]";
    }

    public void setDictionaries(ConcurrentHashMap<String, String> dictionaries) {
        this.dictionaries = dictionaries;
    }

    public void setSnapshots(ConcurrentHashMap<String, String> snapshots) {
        this.snapshots = snapshots;
    }

    public String getStatisticsResourcePath() {
        return CubeSegment.getStatisticsResourcePath(this.getCubeInstance().getName(), this.getUuid());
    }

    public static String getStatisticsResourcePath(String cubeName, String cubeSegmentId) {
        return "/cube_statistics/" + cubeName + "/" + cubeSegmentId + ".seq";
    }

    @Override
    public int getSourceType() {
        return this.cubeInstance.getSourceType();
    }

    @Override
    public int getEngineType() {
        return this.cubeInstance.getEngineType();
    }

    @Override
    public int getStorageType() {
        return this.cubeInstance.getStorageType();
    }

    public boolean isEnableSharding() {
        return this.getCubeDesc().isEnableSharding();
    }

    public Set<TblColRef> getShardByColumns() {
        return this.getCubeDesc().getShardByColumns();
    }

    public int getRowKeyPreambleSize() {
        return this.isEnableSharding() ? 10 : 8;
    }

    public Short getCuboidShardNum(Long cuboidId) {
        Short ret = this.cuboidShardNums.get(cuboidId);
        if (ret == null) {
            return (short)1;
        }
        return ret;
    }

    public void setCuboidShardNums(Map<Long, Short> newCuboidShards) {
        this.cuboidShardNums = newCuboidShards;
    }

    public int getTotalShards(long cuboidId) {
        if (this.totalShards > 0) {
            return this.totalShards;
        }
        short ret = this.getCuboidShardNum(cuboidId);
        return ret;
    }

    public void setTotalShards(int totalShards) {
        this.totalShards = totalShards;
    }

    public short getCuboidBaseShard(Long cuboidId) {
        if (this.totalShards > 0) {
            Short ret = this.cuboidBaseShards.get(cuboidId);
            if (ret == null) {
                ret = ShardingHash.getShard(cuboidId, this.totalShards);
                this.cuboidBaseShards.put(cuboidId, ret);
            }
            return ret;
        }
        return 0;
    }

    public List<Long> getBlackoutCuboids() {
        return this.blackoutCuboids;
    }

    public IRealization getRealization() {
        return this.cubeInstance;
    }

    public String getIndexPath() {
        return this.indexPath;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public HashMap<String, String> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(HashMap<String, String> additionalInfo) {
        this.additionalInfo = additionalInfo;
    }
}

