/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.restclient.Broadcaster;
import org.apache.kylin.common.restclient.CaseInsensitiveStringCache;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.validation.CubeMetadataValidator;
import org.apache.kylin.cube.model.validation.ValidateContext;
import org.apache.kylin.metadata.MetadataManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeDescManager {
    private static final Logger logger = LoggerFactory.getLogger(CubeDescManager.class);
    public static final Serializer<CubeDesc> CUBE_DESC_SERIALIZER = new JsonSerializer<CubeDesc>(CubeDesc.class);
    private static final ConcurrentHashMap<KylinConfig, CubeDescManager> CACHE = new ConcurrentHashMap();
    private KylinConfig config;
    private CaseInsensitiveStringCache<CubeDesc> cubeDescMap;

    public static CubeDescManager getInstance(KylinConfig config) {
        CubeDescManager r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<CubeDescManager> clazz = CubeDescManager.class;
        synchronized (CubeDescManager.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            try {
                r = new CubeDescManager(config);
                CACHE.put(config, r);
                if (CACHE.size() > 1) {
                    logger.warn("More than one singleton exist");
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to init CubeDescManager from " + config, e);
            }
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private CubeDescManager(KylinConfig config) throws IOException {
        logger.info("Initializing CubeDescManager with config " + config);
        this.config = config;
        this.cubeDescMap = new CaseInsensitiveStringCache(config, Broadcaster.TYPE.CUBE_DESC);
        this.reloadAllCubeDesc();
    }

    public CubeDesc getCubeDesc(String name) {
        return (CubeDesc)this.cubeDescMap.get(name);
    }

    public List<CubeDesc> listAllDesc() {
        return new ArrayList<CubeDesc>(this.cubeDescMap.values());
    }

    public CubeDesc reloadCubeDescLocal(String name) throws IOException {
        String path = CubeDesc.concatResourcePath(name);
        CubeDesc ndesc = this.loadCubeDesc(path);
        this.cubeDescMap.putLocal(ndesc.getName(), ndesc);
        Cuboid.reloadCache(name);
        return ndesc;
    }

    private CubeDesc loadCubeDesc(String path) throws IOException {
        ResourceStore store = this.getStore();
        CubeDesc ndesc = store.getResource(path, CubeDesc.class, CUBE_DESC_SERIALIZER);
        if (StringUtils.isBlank(ndesc.getName())) {
            throw new IllegalStateException("CubeDesc name must not be blank");
        }
        ndesc.init(this.config, this.getMetadataManager().getAllTablesMap());
        if (!ndesc.getError().isEmpty()) {
            throw new IllegalStateException("Cube desc at " + path + " has issues: " + ndesc.getError());
        }
        return ndesc;
    }

    public CubeDesc createCubeDesc(CubeDesc cubeDesc) throws IOException {
        if (cubeDesc.getUuid() == null || cubeDesc.getName() == null) {
            throw new IllegalArgumentException();
        }
        if (this.cubeDescMap.containsKey(cubeDesc.getName())) {
            throw new IllegalArgumentException("CubeDesc '" + cubeDesc.getName() + "' already exists");
        }
        try {
            cubeDesc.init(this.config, this.getMetadataManager().getAllTablesMap());
        }
        catch (IllegalStateException e) {
            cubeDesc.addError(e.getMessage(), true);
        }
        if (!cubeDesc.getError().isEmpty()) {
            return cubeDesc;
        }
        CubeMetadataValidator validator = new CubeMetadataValidator();
        ValidateContext context = validator.validate(cubeDesc, true);
        if (!context.ifPass()) {
            return cubeDesc;
        }
        cubeDesc.setSignature(cubeDesc.calculateSignature());
        String path = cubeDesc.getResourcePath();
        this.getStore().putResource(path, cubeDesc, CUBE_DESC_SERIALIZER);
        this.cubeDescMap.put(cubeDesc.getName(), cubeDesc);
        return cubeDesc;
    }

    public void removeCubeDesc(CubeDesc cubeDesc) throws IOException {
        String path = cubeDesc.getResourcePath();
        this.getStore().deleteResource(path);
        this.cubeDescMap.remove(cubeDesc.getName());
        Cuboid.reloadCache(cubeDesc.getName());
    }

    public void removeLocalCubeDesc(String name) throws IOException {
        this.cubeDescMap.removeLocal(name);
        Cuboid.reloadCache(name);
    }

    private void reloadAllCubeDesc() throws IOException {
        ResourceStore store = this.getStore();
        logger.info("Reloading Cube Metadata from folder " + store.getReadableResourcePath("/cube_desc"));
        this.cubeDescMap.clear();
        List<String> paths = store.collectResourceRecursively("/cube_desc", ".json");
        for (String path : paths) {
            CubeDesc desc;
            try {
                desc = this.loadCubeDesc(path);
            }
            catch (Exception e) {
                logger.error("Error loading cube desc " + path, (Throwable)e);
                continue;
            }
            if (!path.equals(desc.getResourcePath())) {
                logger.error("Skip suspicious desc at " + path + ", " + desc + " should be at " + desc.getResourcePath());
                continue;
            }
            if (this.cubeDescMap.containsKey(desc.getName())) {
                logger.error("Dup CubeDesc name '" + desc.getName() + "' on path " + path);
                continue;
            }
            this.cubeDescMap.putLocal(desc.getName(), desc);
        }
        logger.debug("Loaded " + this.cubeDescMap.size() + " Cube(s)");
    }

    public CubeDesc updateCubeDesc(CubeDesc desc) throws IOException {
        if (desc.getUuid() == null || desc.getName() == null) {
            throw new IllegalArgumentException();
        }
        String name = desc.getName();
        if (!this.cubeDescMap.containsKey(name)) {
            throw new IllegalArgumentException("CubeDesc '" + name + "' does not exist.");
        }
        try {
            desc.init(this.config, this.getMetadataManager().getAllTablesMap());
        }
        catch (IllegalStateException e) {
            desc.addError(e.getMessage(), true);
            return desc;
        }
        catch (IllegalArgumentException e) {
            desc.addError(e.getMessage(), true);
            return desc;
        }
        CubeMetadataValidator validator = new CubeMetadataValidator();
        ValidateContext context = validator.validate(desc, true);
        if (!context.ifPass()) {
            return desc;
        }
        desc.setSignature(desc.calculateSignature());
        String path = desc.getResourcePath();
        this.getStore().putResource(path, desc, CUBE_DESC_SERIALIZER);
        CubeDesc ndesc = this.loadCubeDesc(path);
        this.cubeDescMap.put(ndesc.getName(), desc);
        return ndesc;
    }

    private MetadataManager getMetadataManager() {
        return MetadataManager.getInstance(this.config);
    }

    private ResourceStore getStore() {
        return ResourceStore.getStore(this.config);
    }
}

