/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;

public class StringUtil {
    public static String[] filterSystemArgs(String[] args) {
        ArrayList<String> whatsLeft = new ArrayList<String>();
        for (String a : args) {
            if (a.startsWith("-D")) {
                String value;
                String key;
                int cut = a.indexOf(61);
                if (cut < 0) {
                    key = a.substring(2);
                    value = "";
                } else {
                    key = a.substring(2, cut);
                    value = a.substring(cut + 1);
                }
                System.setProperty(key, value);
                continue;
            }
            whatsLeft.add(a);
        }
        return whatsLeft.toArray(new String[whatsLeft.size()]);
    }

    public static String join(Iterable<String> parts, String separator) {
        StringBuilder buf = new StringBuilder();
        for (String p : parts) {
            if (buf.length() > 0) {
                buf.append(separator);
            }
            buf.append(p);
        }
        return buf.toString();
    }

    public static void toUpperCaseArray(String[] source, String[] target) {
        if (source != null) {
            for (int i = 0; i < source.length; ++i) {
                if (source[i] == null) continue;
                target[i] = source[i].toUpperCase();
            }
        }
    }

    public static String noBlank(String str, String dft) {
        return StringUtils.isBlank((String)str) ? dft : str;
    }

    public static String dropSuffix(String str, String suffix) {
        if (str.endsWith(suffix)) {
            return str.substring(0, str.length() - suffix.length());
        }
        return str;
    }

    public static String min(Collection<String> strs) {
        String min = null;
        for (String s : strs) {
            if (min != null && min.compareTo(s) <= 0) continue;
            min = s;
        }
        return min;
    }

    public static String max(Collection<String> strs) {
        String max = null;
        for (String s : strs) {
            if (max != null && max.compareTo(s) >= 0) continue;
            max = s;
        }
        return max;
    }

    public static String min(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.compareTo(s2) < 0 ? s1 : s2;
    }

    public static String max(String s1, String s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        return s1.compareTo(s2) > 0 ? s1 : s2;
    }

    public static String[] subArray(String[] array, int start, int endExclusive) {
        if (start < 0 || start > endExclusive || endExclusive > array.length) {
            throw new IllegalArgumentException();
        }
        String[] result = new String[endExclusive - start];
        System.arraycopy(array, start, result, 0, endExclusive - start);
        return result;
    }
}

