/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.kylin.common.util.JsonUtil;

public class RestClient {
    protected String host;
    protected int port;
    protected String baseUrl;
    protected String userName;
    protected String password;
    protected CloseableHttpClient client;
    protected static Pattern fullRestPattern = Pattern.compile("(?:([^:]+)[:]([^@]+)[@])?([^:]+)(?:[:](\\d+))?");

    public static boolean matchFullRestPattern(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        return m.matches();
    }

    public RestClient(String uri) {
        Matcher m = fullRestPattern.matcher(uri);
        if (!m.matches()) {
            throw new IllegalArgumentException("URI: " + uri + " -- does not match pattern " + fullRestPattern);
        }
        String user = m.group(1);
        String pwd = m.group(2);
        String host = m.group(3);
        String portStr = m.group(4);
        int port = Integer.parseInt(portStr == null ? "7070" : portStr);
        this.init(host, port, user, pwd);
    }

    private void init(String host, int port, String userName, String password) {
        this.host = host;
        this.port = port;
        this.userName = userName;
        this.password = password;
        this.baseUrl = "http://" + host + ":" + port + "/kylin/api";
        this.client = HttpClients.createDefault();
        if (userName != null && password != null) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(userName, password);
            provider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)provider).build();
        }
    }

    public void wipeCache(String type, String action, String name) throws IOException {
        String url = this.baseUrl + "/cache/" + type + "/" + name + "/" + action;
        HttpPut request = new HttpPut(url);
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
            response.close();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        finally {
            request.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getKylinProperties() throws IOException {
        String url = this.baseUrl + "/admin/config";
        HttpGet request = new HttpGet(url);
        try {
            CloseableHttpResponse response = this.client.execute((HttpUriRequest)request);
            String msg = EntityUtils.toString((HttpEntity)response.getEntity());
            Map<String, String> map = JsonUtil.readValueAsMap(msg);
            msg = map.get("config");
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with cache wipe url " + url + "\n" + msg);
            }
            response.close();
            String string = msg;
            return string;
        }
        finally {
            request.releaseConnection();
        }
    }
}

