/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.restclient;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.restclient.RestClient;
import org.apache.kylin.common.util.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Broadcaster {
    private static final Logger logger = LoggerFactory.getLogger(Broadcaster.class);
    private static final ConcurrentHashMap<KylinConfig, Broadcaster> CACHE = new ConcurrentHashMap();
    private BlockingDeque<BroadcastEvent> broadcastEvents = new LinkedBlockingDeque<BroadcastEvent>();
    private AtomicLong counter = new AtomicLong();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Broadcaster getInstance(KylinConfig config) {
        Broadcaster r = CACHE.get(config);
        if (r != null) {
            return r;
        }
        Class<Broadcaster> clazz = Broadcaster.class;
        synchronized (Broadcaster.class) {
            r = CACHE.get(config);
            if (r != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return r;
            }
            r = new Broadcaster(config);
            CACHE.put(config, r);
            if (CACHE.size() > 1) {
                logger.warn("More than one singleton exist");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return r;
        }
    }

    public static void clearCache() {
        CACHE.clear();
    }

    private Broadcaster(KylinConfig config) {
        Object[] nodes = config.getRestServers();
        if (nodes == null || nodes.length < 1) {
            logger.warn("There is no available rest server; check the 'kylin.rest.servers' config");
            this.broadcastEvents = null;
            return;
        }
        logger.debug(nodes.length + " nodes in the cluster: " + Arrays.toString(nodes));
        Executors.newSingleThreadExecutor(new DaemonThreadFactory()).execute(new Runnable((String[])nodes){
            final /* synthetic */ String[] val$nodes;
            {
                this.val$nodes = stringArray;
            }

            @Override
            public void run() {
                ArrayList restClients = Lists.newArrayList();
                for (String node : this.val$nodes) {
                    restClients.add(new RestClient(node));
                }
                ExecutorService wipingCachePool = Executors.newFixedThreadPool(restClients.size());
                while (true) {
                    try {
                        block4: while (true) {
                            final BroadcastEvent broadcastEvent = (BroadcastEvent)Broadcaster.this.broadcastEvents.takeFirst();
                            logger.info("new broadcast event:" + broadcastEvent);
                            Iterator i$ = restClients.iterator();
                            while (true) {
                                if (!i$.hasNext()) continue block4;
                                final RestClient restClient = (RestClient)i$.next();
                                wipingCachePool.execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        try {
                                            restClient.wipeCache(broadcastEvent.getType(), broadcastEvent.getAction(), broadcastEvent.getName());
                                        }
                                        catch (IOException e) {
                                            logger.warn("Thread failed during wipe cache at " + broadcastEvent);
                                        }
                                    }
                                });
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error("error running wiping", (Throwable)e);
                        continue;
                    }
                    break;
                }
            }
        });
    }

    public void queue(String type, String action, String key) {
        if (this.broadcastEvents == null) {
            return;
        }
        try {
            this.counter.incrementAndGet();
            this.broadcastEvents.putFirst(new BroadcastEvent(type, action, key));
        }
        catch (Exception e) {
            this.counter.decrementAndGet();
            logger.error("error putting BroadcastEvent", (Throwable)e);
        }
    }

    public long getCounterAndClear() {
        return this.counter.getAndSet(0L);
    }

    public static class BroadcastEvent {
        private String type;
        private String action;
        private String name;

        public BroadcastEvent(String type, String action, String name) {
            this.type = type;
            this.action = action;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getAction() {
            return this.action;
        }

        public String getName() {
            return this.name;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this == obj) {
                return true;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BroadcastEvent other = (BroadcastEvent)obj;
            if (!StringUtils.equals((String)this.action, (String)other.action)) {
                return false;
            }
            if (!StringUtils.equals((String)this.name, (String)other.name)) {
                return false;
            }
            return StringUtils.equals((String)this.type, (String)other.type);
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("type", (Object)this.type).add("name", (Object)this.name).add("action", (Object)this.action).toString();
        }
    }

    public static enum TYPE {
        ALL("all"),
        PROJECT("project"),
        CUBE("cube"),
        CUBE_DESC("cube_desc"),
        STREAMING("streaming"),
        KAFKA("kafka"),
        INVERTED_INDEX("inverted_index"),
        INVERTED_INDEX_DESC("ii_desc"),
        TABLE("table"),
        DATA_MODEL("data_model"),
        EXTERNAL_FILTER("external_filter"),
        HYBRID("hybrid");

        private String text;

        private TYPE(String text) {
            this.text = text;
        }

        public String getType() {
            return this.text;
        }

        public static TYPE getType(String type) {
            for (TYPE one : TYPE.values()) {
                if (!one.getType().equalsIgnoreCase(type)) continue;
                return one;
            }
            return null;
        }
    }

    public static enum EVENT {
        CREATE("create"),
        UPDATE("update"),
        DROP("drop");

        private String text;

        private EVENT(String text) {
            this.text = text;
        }

        public String getType() {
            return this.text;
        }

        public static EVENT getEvent(String event) {
            for (EVENT one : EVENT.values()) {
                if (!one.getType().equalsIgnoreCase(event)) continue;
                return one;
            }
            return null;
        }
    }
}

