/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KylinConfigBase
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(KylinConfigBase.class);
    private volatile Properties properties = new Properties();
    private static final Pattern COPROCESSOR_JAR_NAME_PATTERN = Pattern.compile("kylin-coprocessor-(.+)\\.jar");
    private static final Pattern JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-job-(.+)\\.jar");
    private static final Pattern SPARK_JOB_JAR_NAME_PATTERN = Pattern.compile("kylin-engine-spark-(.+)\\.jar");

    public static String getKylinHome() {
        String kylinHome = System.getenv("KYLIN_HOME");
        if (StringUtils.isEmpty((String)kylinHome)) {
            logger.warn("KYLIN_HOME was not set");
        }
        return kylinHome;
    }

    public KylinConfigBase() {
        this(new Properties());
    }

    public KylinConfigBase(Properties props) {
        this.properties = props;
    }

    protected final String getOptional(String prop) {
        return this.getOptional(prop, null);
    }

    protected String getOptional(String prop, String dft) {
        String property = System.getProperty(prop);
        return property != null ? property : this.properties.getProperty(prop, dft);
    }

    protected Properties getAllProperties() {
        return this.properties;
    }

    protected final Map<String, String> getPropertiesByPrefix(String prefix) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<Object, Object> entry : this.getAllProperties().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(prefix)) continue;
            result.put(key.substring(prefix.length()), (String)entry.getValue());
        }
        return result;
    }

    protected final String[] getOptionalStringArray(String prop, String[] dft) {
        String property = this.getOptional(prop);
        if (!StringUtils.isBlank((String)property)) {
            return property.split("\\s*,\\s*");
        }
        return dft;
    }

    protected final int[] getOptionalIntArray(String prop, String[] dft) {
        String[] strArray = this.getOptionalStringArray(prop, dft);
        int[] intArray = new int[strArray.length];
        for (int i = 0; i < strArray.length; ++i) {
            intArray[i] = Integer.parseInt(strArray[i]);
        }
        return intArray;
    }

    public final String getRequired(String prop) {
        String r = this.getOptional(prop);
        if (StringUtils.isEmpty((String)r)) {
            throw new IllegalArgumentException("missing '" + prop + "' in conf/kylin.properties");
        }
        return r;
    }

    public final void setProperty(String key, String value) {
        logger.info("Kylin Config was updated with " + key + " : " + value);
        this.properties.setProperty(key, value);
    }

    protected final void reloadKylinConfig(Properties properties) {
        this.properties = properties;
    }

    public boolean isDevEnv() {
        return "DEV".equals(this.getOptional("deploy.env", "DEV"));
    }

    public String getMetadataUrl() {
        return this.getOptional("kylin.metadata.url");
    }

    public void setMetadataUrl(String metadataUrl) {
        this.setProperty("kylin.metadata.url", metadataUrl);
    }

    public String getMetadataUrlPrefix() {
        String hbaseMetadataUrl = this.getMetadataUrl();
        String defaultPrefix = "kylin_metadata";
        if (org.apache.commons.lang3.StringUtils.containsIgnoreCase(hbaseMetadataUrl, "@hbase")) {
            int cut = hbaseMetadataUrl.indexOf(64);
            String tmp = cut < 0 ? defaultPrefix : hbaseMetadataUrl.substring(0, cut);
            return tmp;
        }
        return defaultPrefix;
    }

    public String getServerMode() {
        return this.getOptional("kylin.server.mode", "all");
    }

    public String getStorageUrl() {
        return this.getOptional("kylin.storage.url");
    }

    public void setStorageUrl(String storageUrl) {
        this.setProperty("kylin.storage.url", storageUrl);
    }

    @Deprecated
    public String getHiveUrl() {
        return this.getOptional("hive.url", "");
    }

    @Deprecated
    public String getHiveUser() {
        return this.getOptional("hive.user", "");
    }

    @Deprecated
    public String getHivePassword() {
        return this.getOptional("hive.password", "");
    }

    public String getHdfsWorkingDirectory() {
        String root = this.getRequired("kylin.hdfs.working.dir");
        if (!root.endsWith("/")) {
            root = root + "/";
        }
        return new StringBuffer(root).append(StringUtils.replaceChars((String)this.getMetadataUrlPrefix(), (char)':', (char)'-')).append("/").toString();
    }

    public String[] getRealizationProviders() {
        return this.getOptionalStringArray("kylin.realization.providers", new String[]{"org.apache.kylin.cube.CubeManager", "org.apache.kylin.storage.hybrid.HybridManager"});
    }

    public CliCommandExecutor getCliCommandExecutor() throws IOException {
        CliCommandExecutor exec = new CliCommandExecutor();
        if (this.getRunAsRemoteCommand()) {
            exec.setRunAtRemote(this.getRemoteHadoopCliHostname(), this.getRemoteHadoopCliPort(), this.getRemoteHadoopCliUsername(), this.getRemoteHadoopCliPassword());
        }
        return exec;
    }

    public String getHBaseClusterFs() {
        return this.getOptional("kylin.hbase.cluster.fs", "");
    }

    public String getHBaseClusterHDFSConfigFile() {
        return this.getOptional("kylin.hbase.cluster.hdfs.config.file", "");
    }

    public String getKylinJobLogDir() {
        return this.getOptional("kylin.job.log.dir", "/tmp/kylin/logs");
    }

    public String getKylinJobJarPath() {
        String jobJar = this.getOptional("kylin.job.jar");
        if (StringUtils.isNotEmpty((String)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", JOB_JAR_NAME_PATTERN);
    }

    public void overrideMRJobJarPath(String path) {
        logger.info("override kylin.job.jar to " + path);
        System.setProperty("kylin.job.jar", path);
    }

    public String getKylinJobMRLibDir() {
        return this.getOptional("kylin.job.mr.lib.dir", "");
    }

    public Map<String, String> getMRConfigOverride() {
        return this.getPropertiesByPrefix("kylin.job.mr.config.override.");
    }

    public String getKylinSparkJobJarPath() {
        String jobJar = this.getOptional("kylin.job.jar.spark");
        if (StringUtils.isNotEmpty((String)jobJar)) {
            return jobJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            return "";
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", SPARK_JOB_JAR_NAME_PATTERN);
    }

    public void overrideSparkJobJarPath(String path) {
        logger.info("override kylin.job.jar.spark to " + path);
        System.setProperty("kylin.job.jar.spark", path);
    }

    public String getCoprocessorLocalJar() {
        String coprocessorJar = this.getOptional("kylin.coprocessor.local.jar");
        if (StringUtils.isNotEmpty((String)coprocessorJar)) {
            return coprocessorJar;
        }
        String kylinHome = KylinConfigBase.getKylinHome();
        if (StringUtils.isEmpty((String)kylinHome)) {
            throw new RuntimeException("getCoprocessorLocalJar needs KYLIN_HOME");
        }
        return KylinConfigBase.getFileName(kylinHome + File.separator + "lib", COPROCESSOR_JAR_NAME_PATTERN);
    }

    public void overrideCoprocessorLocalJar(String path) {
        logger.info("override kylin.coprocessor.local.jar to " + path);
        System.setProperty("kylin.coprocessor.local.jar", path);
    }

    private static String getFileName(String homePath, Pattern pattern) {
        File home = new File(homePath);
        TreeSet files = Sets.newTreeSet();
        if (home.exists() && home.isDirectory()) {
            for (File file : home.listFiles()) {
                Matcher matcher = pattern.matcher(file.getName());
                if (!matcher.matches()) continue;
                files.add(file.getAbsolutePath());
            }
        }
        if (files.isEmpty()) {
            throw new RuntimeException("cannot find " + pattern.toString() + " in " + homePath);
        }
        return (String)files.last();
    }

    public double getDefaultHadoopJobReducerInputMB() {
        return Double.parseDouble(this.getOptional("kylin.job.mapreduce.default.reduce.input.mb", "500"));
    }

    public double getDefaultHadoopJobReducerCountRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.mapreduce.default.reduce.count.ratio", "1.0"));
    }

    public int getHadoopJobMinReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.job.mapreduce.min.reducer.number", "1"));
    }

    public int getHadoopJobMaxReducerNumber() {
        return Integer.parseInt(this.getOptional("kylin.job.mapreduce.max.reducer.number", "500"));
    }

    public int getHadoopJobMapperInputRows() {
        return Integer.parseInt(this.getOptional("kylin.job.mapreduce.mapper.input.rows", "1000000"));
    }

    public boolean getRunAsRemoteCommand() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.run.as.remote.cmd"));
    }

    public void setRunAsRemoteCommand(String v) {
        this.setProperty("kylin.job.run.as.remote.cmd", v);
    }

    public int getRemoteHadoopCliPort() {
        return Integer.parseInt(this.getOptional("kylin.job.remote.cli.port", "22"));
    }

    public String getRemoteHadoopCliHostname() {
        return this.getOptional("kylin.job.remote.cli.hostname");
    }

    public void setRemoteHadoopCliHostname(String v) {
        this.setProperty("kylin.job.remote.cli.hostname", v);
    }

    public String getRemoteHadoopCliUsername() {
        return this.getOptional("kylin.job.remote.cli.username");
    }

    public void setRemoteHadoopCliUsername(String v) {
        this.setProperty("kylin.job.remote.cli.username", v);
    }

    public String getRemoteHadoopCliPassword() {
        return this.getOptional("kylin.job.remote.cli.password");
    }

    public void setRemoteHadoopCliPassword(String v) {
        this.setProperty("kylin.job.remote.cli.password", v);
    }

    public String getCliWorkingDir() {
        return this.getOptional("kylin.job.remote.cli.working.dir");
    }

    public boolean isEmptySegmentAllowed() {
        return Boolean.parseBoolean(this.getOptional("kylin.job.allow.empty.segment", "true"));
    }

    public String getOverrideHiveTableLocation(String table) {
        return this.getOptional("hive.table.location." + table.toUpperCase());
    }

    public String getYarnStatusCheckUrl() {
        return this.getOptional("kylin.job.yarn.app.rest.check.status.url", null);
    }

    public int getYarnStatusCheckIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.job.yarn.app.rest.check.interval.seconds", "60"));
    }

    public int getMaxConcurrentJobLimit() {
        return Integer.parseInt(this.getOptional("kylin.job.concurrent.max.limit", "10"));
    }

    public String getTimeZone() {
        return this.getOptional("kylin.rest.timezone", "PST");
    }

    public String[] getRestServers() {
        return this.getOptionalStringArray("kylin.rest.servers", new String[0]);
    }

    public String getClusterName() {
        return this.getOptional("kylin.cluster.name", this.getMetadataUrlPrefix());
    }

    public int getWorkersPerServer() {
        return Integer.parseInt(this.getOptional("kylin.rest.workers.per.server", "1"));
    }

    public String[] getAdminDls() {
        return this.getOptionalStringArray("kylin.job.admin.dls", null);
    }

    public long getJobStepTimeout() {
        return Long.parseLong(this.getOptional("kylin.job.step.timeout", String.valueOf(7200)));
    }

    public double getJobCuboidSizeRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.cuboid.size.ratio", "0.25"));
    }

    public double getJobCuboidSizeMemHungryRatio() {
        return Double.parseDouble(this.getOptional("kylin.job.cuboid.size.memhungry.ratio", "0.05"));
    }

    public String getCubeAlgorithm() {
        return this.getOptional("kylin.cube.algorithm", "auto");
    }

    public double getCubeAlgorithmAutoThreshold() {
        return Double.parseDouble(this.getOptional("kylin.cube.algorithm.auto.threshold", "8"));
    }

    @Deprecated
    public int getCubeAggrGroupMaxSize() {
        return Integer.parseInt(this.getOptional("kylin.cube.aggrgroup.max.size", "12"));
    }

    public int getCubeAggrGroupMaxCombination() {
        return Integer.parseInt(this.getOptional("kylin.cube.aggrgroup.max.combination", "4096"));
    }

    public boolean getCubeAggrGroupIsMandatoryOnlyValid() {
        return Boolean.parseBoolean(this.getOptional("kylin.cube.aggrgroup.isMandatoryOnlyValid", "false"));
    }

    public String[] getCubeDimensionCustomEncodingFactories() {
        return this.getOptionalStringArray("kylin.cube.dimension.customEncodingFactories", new String[0]);
    }

    public Map<String, String> getCubeCustomMeasureTypes() {
        return this.getPropertiesByPrefix("kylin.cube.measure.customMeasureType.");
    }

    public int getDictionaryMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.dictionary.max.cardinality", "30000000"));
    }

    public int getTableSnapshotMaxMB() {
        return Integer.parseInt(this.getOptional("kylin.table.snapshot.max_mb", "300"));
    }

    public int getHBaseRegionCountMin() {
        return Integer.parseInt(this.getOptional("kylin.hbase.region.count.min", "1"));
    }

    public int getHBaseRegionCountMax() {
        return Integer.parseInt(this.getOptional("kylin.hbase.region.count.max", "500"));
    }

    public void setHBaseHFileSizeGB(float size) {
        this.setProperty("kylin.hbase.hfile.size.gb", String.valueOf(size));
    }

    public float getHBaseHFileSizeGB() {
        return Float.parseFloat(this.getOptional("kylin.hbase.hfile.size.gb", "2.0"));
    }

    public int getStoragePushDownLimitMax() {
        return Integer.parseInt(this.getOptional("kylin.query.pushdown.limit.max", "10000"));
    }

    public int getScanThreshold() {
        return Integer.parseInt(this.getOptional("kylin.query.scan.threshold", "10000000"));
    }

    public float getCubeVisitTimeoutTimes() {
        return Float.parseFloat(this.getOptional("kylin.query.cube.visit.timeout.times", "1"));
    }

    public int getBadQueryStackTraceDepth() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery.stacktrace.depth", "10"));
    }

    public int getBadQueryHistoryNum() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery.history.num", "10"));
    }

    public int getBadQueryDefaultAlertingSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery.alerting.seconds", "90"));
    }

    public int getBadQueryDefaultDetectIntervalSeconds() {
        return Integer.parseInt(this.getOptional("kylin.query.badquery.detect.interval.seconds", "60"));
    }

    public boolean getBadQueryPersistentEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.badquery.persistent.enable", "true"));
    }

    public int getCachedDictMaxEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.dict.cache.max.entry", "3000"));
    }

    public int getCachedSnapshotMaxEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.snapshot.cache.max.entry", "500"));
    }

    public boolean getQueryRunLocalCoprocessor() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.run.local.coprocessor", "false"));
    }

    public long getQueryDurationCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache.threshold.duration", String.valueOf(2000)));
    }

    public long getQueryScanCountCacheThreshold() {
        return Long.parseLong(this.getOptional("kylin.query.cache.threshold.scancount", String.valueOf(10240)));
    }

    public long getQueryMemBudget() {
        return Long.parseLong(this.getOptional("kylin.query.mem.budget", String.valueOf(0xC0000000L)));
    }

    public double getQueryCoprocessorMemGB() {
        return Double.parseDouble(this.getOptional("kylin.query.coprocessor.mem.gb", "3.0"));
    }

    public boolean isQuerySecureEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.security.enabled", "true"));
    }

    public boolean isQueryCacheEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.cache.enabled", "true"));
    }

    public boolean isQueryIgnoreUnknownFunction() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.ignore_unknown_function", "false"));
    }

    public int getQueryScanFuzzyKeyMax() {
        return Integer.parseInt(this.getOptional("kylin.query.scan.fuzzykey.max", "200"));
    }

    public int getQueryStorageVisitScanRangeMax() {
        return Integer.valueOf(this.getOptional("kylin.query.storage.visit.scanrange.max", "1000000"));
    }

    public String getQueryAccessController() {
        return this.getOptional("kylin.query.access.controller", null);
    }

    public long getSequenceExpireTime() {
        return Long.valueOf(this.getOptional("kylin.query.sequence.expire.time", "86400000"));
    }

    public boolean getQueryMetricsEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.metrics.enabled", "false"));
    }

    public int[] getQueryMetricsPercentilesIntervals() {
        String[] dft = new String[]{"60", "300", "3600"};
        return this.getOptionalIntArray("kylin.query.metrics.percentiles.intervals", dft);
    }

    public int getHBaseKeyValueSize() {
        return Integer.parseInt(this.getOptional("kylin.hbase.client.keyvalue.maxsize", "10485760"));
    }

    public String getDefaultIGTStorage() {
        return this.getOptional("kylin.query.storage.default.gtstorage", "org.apache.kylin.storage.hbase.cube.v2.CubeHBaseEndpointRPC");
    }

    public int getHBaseScanCacheRows() {
        return Integer.parseInt(this.getOptional("kylin.hbase.scan.cache_rows", "1024"));
    }

    public boolean isGrowingDictEnabled() {
        return Boolean.parseBoolean(this.getOptional("kylin.dict.growing.enabled", "false"));
    }

    public float getKylinHBaseRegionCut() {
        return Float.valueOf(this.getOptional("kylin.hbase.region.cut", "5.0")).floatValue();
    }

    public int getHBaseScanMaxResultSize() {
        return Integer.parseInt(this.getOptional("kylin.hbase.scan.max_result_size", "5242880"));
    }

    public int getCubingInMemSamplingPercent() {
        int percent = Integer.parseInt(this.getOptional("kylin.job.cubing.inmem.sampling.percent", "100"));
        percent = Math.max(percent, 1);
        percent = Math.min(percent, 100);
        return percent;
    }

    public String getHbaseDefaultCompressionCodec() {
        return this.getOptional("kylin.hbase.default.compression.codec", "none");
    }

    public String getHbaseDefaultEncoding() {
        return this.getOptional("kylin.hbase.default.encoding", "FAST_DIFF");
    }

    public int getHbaseDefaultBlockSize() {
        return Integer.valueOf(this.getOptional("kylin.hbase.default.block.size", "1048576"));
    }

    public int getHbaseSmallFamilyBlockSize() {
        return Integer.valueOf(this.getOptional("kylin.hbase.small.family.block.size", "65536"));
    }

    public boolean isHiveKeepFlatTable() {
        return Boolean.parseBoolean(this.getOptional("kylin.hive.keep.flat.table", "false"));
    }

    public String getHiveDatabaseForIntermediateTable() {
        return this.getOptional("kylin.job.hive.database.for.intermediatetable", "default");
    }

    public String getKylinOwner() {
        return this.getOptional("kylin.owner", "");
    }

    public String getSparkHome() {
        return this.getRequired("kylin.spark.home");
    }

    public String getSparkMaster() {
        return this.getRequired("kylin.spark.master");
    }

    public boolean isMailEnabled() {
        return Boolean.parseBoolean(this.getOptional("mail.enabled", "false"));
    }

    public void setMailEnabled(boolean enable) {
        this.setProperty("mail.enabled", "" + enable);
    }

    public String getMailHost() {
        return this.getOptional("mail.host", "");
    }

    public String getMailUsername() {
        return this.getOptional("mail.username", "");
    }

    public String getMailPassword() {
        return this.getOptional("mail.password", "");
    }

    public String getMailSender() {
        return this.getOptional("mail.sender", "");
    }

    public boolean isWebCrossDomainEnabled() {
        return Boolean.parseBoolean(this.getOptional("crossdomain.enable", "true"));
    }

    public int getJobRetry() {
        return Integer.parseInt(this.getOptional("kylin.job.retry", "0"));
    }

    public String toString() {
        return this.getMetadataUrl();
    }

    public String getHiveClientMode() {
        return this.getOptional("kylin.hive.client", "cli");
    }

    public String getHiveBeelineParams() {
        return this.getOptional("kylin.hive.beeline.params", "");
    }

    public String getDeployEnv() {
        return this.getOptional("deploy.env", "DEV");
    }

    public String getInitTasks() {
        return this.getOptional("kylin.init.tasks");
    }

    public int getDimCountDistinctMaxCardinality() {
        return Integer.parseInt(this.getOptional("kylin.query.dim.distinct.max", "5000000"));
    }

    public int getCubeStatsHLLPrecision() {
        return Integer.parseInt(this.getOptional("kylin.job.cubing.inmem.sampling.hll.precision", "14"));
    }

    public String getJobControllerLock() {
        return this.getOptional("kylin.job.controller.lock", "org.apache.kylin.storage.hbase.util.ZookeeperJobLock");
    }

    public Map<Integer, String> getJobEngines() {
        Map<Integer, String> r = this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.cube.engine."));
        r.put(0, "org.apache.kylin.engine.mr.MRBatchCubingEngine");
        r.put(2, "org.apache.kylin.engine.mr.MRBatchCubingEngine2");
        return r;
    }

    public Map<Integer, String> getSourceEngines() {
        Map<Integer, String> r = this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.source.engine."));
        r.put(0, "org.apache.kylin.source.hive.HiveSource");
        return r;
    }

    public Map<Integer, String> getStorageEngines() {
        Map<Integer, String> r = this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.storage.engine."));
        r.put(0, "org.apache.kylin.storage.hbase.HBaseStorage");
        r.put(1, "org.apache.kylin.storage.hybrid.HybridStorage");
        r.put(2, "org.apache.kylin.storage.hbase.HBaseStorage");
        return r;
    }

    public int getDefaultStorageEngine() {
        return Integer.parseInt(this.getOptional("kylin.default.storage.engine", "2"));
    }

    public int getDefaultCubeEngine() {
        return Integer.parseInt(this.getOptional("kylin.default.cube.engine", "2"));
    }

    public Map<Integer, String> getSchedulers() {
        Map<Integer, String> r = this.convertKeyToInteger(this.getPropertiesByPrefix("kylin.scheduler."));
        r.put(0, "org.apache.kylin.job.impl.threadpool.DefaultScheduler");
        return r;
    }

    public Integer getSchedulerType() {
        return Integer.parseInt(this.getOptional("kylin.enable.scheduler", "0"));
    }

    public String getZookeeperAddress() {
        return this.getOptional("kylin.zookeeper.address");
    }

    public String getRestAddress() {
        return this.getOptional("kylin.rest.address", "localhost:7070");
    }

    private Map<Integer, String> convertKeyToInteger(Map<String, String> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            result.put(Integer.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public boolean getCompressionResult() {
        return Boolean.parseBoolean(this.getOptional("kylin.query.endpoint.compression.result", "true"));
    }

    public Map<String, String> getUDFs() {
        return this.getPropertiesByPrefix("kylin.query.udf.");
    }

    public int getHBaseMaxConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.query.hbase.hconnection.threads.max", "2048"));
    }

    public int getHBaseCoreConnectionThreads() {
        return Integer.parseInt(this.getOptional("kylin.query.hbase.hconnection.threads.core", "2048"));
    }

    public long getHBaseConnectionThreadPoolAliveSeconds() {
        return Long.parseLong(this.getOptional("kylin.query.hbase.hconnection.threads.alive.seconds", "60"));
    }

    public long getStorageCleanupTimeThreshold() {
        return Long.valueOf(this.getOptional("kylin.storage.cleanup.time.threshold", "172800000"));
    }

    public int getAppendDictEntrySize() {
        return Integer.parseInt(this.getOptional("kylin.dict.append.entry.size", "10000000"));
    }

    public void setAppendDictEntrySize(int entrySize) {
        this.setProperty("kylin.dict.append.entry.size", String.valueOf(entrySize));
    }

    public int getAppendDictCacheSize() {
        return Integer.parseInt(this.getOptional("kylin.dict.append.cache.size", "20"));
    }

    public void setAppendDictCacheSize(int cacheSize) {
        this.setProperty("kylin.dict.append.cache.size", String.valueOf(cacheSize));
    }

    public String getCreateFlatHiveTableMethod() {
        return this.getOptional("kylin.hive.create.flat.table.method", "1");
    }
}

