/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.storage.hbase.HBaseConnection;

public class PingHBaseCLI {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String hbaseTable = args[0];
        System.out.println("Hello friend.");
        Configuration hconf = HBaseConnection.getCurrentHBaseConfiguration();
        if (User.isHBaseSecurityEnabled((Configuration)hconf)) {
            try {
                System.out.println("--------------Getting kerberos credential for user " + UserGroupInformation.getCurrentUser().getUserName());
                TokenUtil.obtainAndCacheToken((Configuration)hconf, (UserGroupInformation)UserGroupInformation.getCurrentUser());
            }
            catch (InterruptedException e) {
                System.out.println("--------------Error while getting kerberos credential for user " + UserGroupInformation.getCurrentUser().getUserName());
            }
        }
        Scan scan = new Scan();
        int limit = 20;
        HConnection conn = null;
        HTableInterface table = null;
        ResultScanner scanner = null;
        try {
            conn = HConnectionManager.createConnection((Configuration)hconf);
            table = conn.getTable(hbaseTable);
            scanner = table.getScanner(scan);
            int count = 0;
            for (Result r : scanner) {
                byte[] rowkey = r.getRow();
                System.out.println(Bytes.toStringBinary((byte[])rowkey));
                if (++count != limit) continue;
                break;
            }
        }
        finally {
            if (scanner != null) {
                scanner.close();
            }
            if (table != null) {
                table.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

