/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtableAlterMetadataCLI
extends AbstractHadoopJob {
    private static final Option OPTION_METADATA_KEY;
    private static final Option OPTION_METADATA_VALUE;
    protected static final Logger logger;
    String tableName;
    String metadataKey;
    String metadataValue;

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            options.addOption(OPTION_HTABLE_NAME);
            options.addOption(OPTION_METADATA_KEY);
            options.addOption(OPTION_METADATA_VALUE);
            this.parseOptions(options, args);
            this.tableName = this.getOptionValue(OPTION_HTABLE_NAME);
            this.metadataKey = this.getOptionValue(OPTION_METADATA_KEY);
            this.metadataValue = this.getOptionValue(OPTION_METADATA_VALUE);
            this.alter();
            return 0;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    private void alter() throws IOException {
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        HTableDescriptor table = hbaseAdmin.getTableDescriptor(TableName.valueOf((String)this.tableName));
        hbaseAdmin.disableTable(table.getTableName());
        table.setValue(this.metadataKey, this.metadataValue);
        hbaseAdmin.modifyTable(table.getTableName(), table);
        hbaseAdmin.enableTable(table.getTableName());
        hbaseAdmin.close();
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new HtableAlterMetadataCLI(), (String[])args);
        System.exit(exitCode);
    }

    static {
        OptionBuilder.withArgName((String)"key");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The metadata key");
        OPTION_METADATA_KEY = OptionBuilder.create((String)"key");
        OptionBuilder.withArgName((String)"value");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"The metadata value");
        OPTION_METADATA_VALUE = OptionBuilder.create((String)"value");
        logger = LoggerFactory.getLogger(HtableAlterMetadataCLI.class);
    }
}

