/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CleanHtableCLI
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(CleanHtableCLI.class);

    public int run(String[] args) throws Exception {
        Options options = new Options();
        try {
            this.clean();
            return 0;
        }
        catch (Exception e) {
            this.printUsage(options);
            throw e;
        }
    }

    private void clean() throws IOException {
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        HBaseAdmin hbaseAdmin = new HBaseAdmin(conf);
        for (HTableDescriptor descriptor : hbaseAdmin.listTables()) {
            String name = descriptor.getNameAsString().toLowerCase();
            if (!name.startsWith("kylin") && !name.startsWith("_kylin")) continue;
            String x = descriptor.getValue("KYLIN_HOST");
            System.out.println("table name " + descriptor.getNameAsString() + " host: " + x);
            System.out.println(descriptor);
            System.out.println();
            descriptor.setValue("OWNER", "DL-eBay-Kylin@ebay.com");
            hbaseAdmin.modifyTable(descriptor.getNameAsString(), descriptor);
        }
        hbaseAdmin.close();
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new CleanHtableCLI(), (String[])args);
        System.exit(exitCode);
    }
}

