/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.kylin.engine.mr.KylinMapper;

public class RangeKeyDistributionMapper
extends KylinMapper<Text, Text, Text, LongWritable> {
    private static final long ONE_MEGA_BYTES = 0x100000L;
    private LongWritable outputValue = new LongWritable(0L);
    private long bytesRead = 0L;
    private Text lastKey;

    protected void setup(Mapper.Context context) throws IOException {
        super.bindCurrentConfiguration(context.getConfiguration());
    }

    public void map(Text key, Text value, Mapper.Context context) throws IOException, InterruptedException {
        this.lastKey = key;
        int bytesLength = key.getLength() + value.getLength();
        this.bytesRead += (long)bytesLength;
        if (this.bytesRead >= 0x100000L) {
            this.outputValue.set(this.bytesRead);
            context.write((Object)key, (Object)this.outputValue);
            this.bytesRead = 0L;
        }
    }

    protected void cleanup(Mapper.Context context) throws IOException, InterruptedException {
        if (this.lastKey != null) {
            this.outputValue.set(this.bytesRead);
            context.write((Object)this.lastKey, (Object)this.outputValue);
        }
    }
}

