/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.JobBuilderSupport;
import org.apache.kylin.engine.mr.common.HadoopShellExecutable;
import org.apache.kylin.engine.mr.common.MapReduceExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.realization.IRealizationSegment;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.steps.BulkLoadJob;
import org.apache.kylin.storage.hbase.steps.CreateHTableJob;
import org.apache.kylin.storage.hbase.steps.CubeHFileJob;
import org.apache.kylin.storage.hbase.steps.HDFSPathGarbageCollectionStep;
import org.apache.kylin.storage.hbase.steps.MergeGCStep;
import org.apache.kylin.storage.hbase.steps.RangeKeyDistributionJob;

public class HBaseMRSteps
extends JobBuilderSupport {
    public HBaseMRSteps(IRealizationSegment seg) {
        super(seg, null);
    }

    public void addSaveCuboidToHTableSteps(DefaultChainedExecutable jobFlow, String cuboidRootPath) {
        String jobId = jobFlow.getId();
        jobFlow.addTask((AbstractExecutable)this.createRangeRowkeyDistributionStep(cuboidRootPath, jobId));
        jobFlow.addTask((AbstractExecutable)this.createCreateHTableStep(jobId));
        jobFlow.addTask((AbstractExecutable)this.createConvertCuboidToHfileStep(cuboidRootPath, jobId));
        jobFlow.addTask((AbstractExecutable)this.createBulkLoadStep(jobId));
    }

    public MapReduceExecutable createRangeRowkeyDistributionStep(String cuboidRootPath, String jobId) {
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/") + "*";
        MapReduceExecutable rowkeyDistributionStep = new MapReduceExecutable();
        rowkeyDistributionStep.setName("Calculate HTable Region Splits");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)inputPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)this.getRowkeyDistributionOutputPath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_Region_Splits_Calculator_" + this.seg.getRealization().getName() + "_Step"));
        rowkeyDistributionStep.setMapReduceParams(cmd.toString());
        rowkeyDistributionStep.setMapReduceJobClass(RangeKeyDistributionJob.class);
        return rowkeyDistributionStep;
    }

    public HadoopShellExecutable createCreateHTableStep(String jobId) {
        return this.createCreateHTableStep(jobId, false);
    }

    public HadoopShellExecutable createCreateHTableStepWithStats(String jobId) {
        return this.createCreateHTableStep(jobId, true);
    }

    private HadoopShellExecutable createCreateHTableStep(String jobId, boolean withStats) {
        HadoopShellExecutable createHtableStep = new HadoopShellExecutable();
        createHtableStep.setName("Create HTable");
        StringBuilder cmd = new StringBuilder();
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"segmentname", (String)this.seg.getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"partitions", (String)(this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000"));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"statisticsenabled", (String)String.valueOf(withStats));
        createHtableStep.setJobParams(cmd.toString());
        createHtableStep.setJobClass(CreateHTableJob.class);
        return createHtableStep;
    }

    public MapReduceExecutable createConvertCuboidToHfileStep(String cuboidRootPath, String jobId) {
        String inputPath = cuboidRootPath + (cuboidRootPath.endsWith("/") ? "" : "/") + "*";
        MapReduceExecutable createHFilesStep = new MapReduceExecutable();
        createHFilesStep.setName("Convert Cuboid Data to HFile");
        StringBuilder cmd = new StringBuilder();
        this.appendMapReduceParameters(cmd);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"partitions", (String)(this.getRowkeyDistributionOutputPath(jobId) + "/part-r-00000_hfile"));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)inputPath);
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"output", (String)this.getHFilePath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"htablename", (String)this.seg.getStorageLocationIdentifier());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"jobname", (String)("Kylin_HFile_Generator_" + this.seg.getRealization().getName() + "_Step"));
        createHFilesStep.setMapReduceParams(cmd.toString());
        createHFilesStep.setMapReduceJobClass(CubeHFileJob.class);
        createHFilesStep.setCounterSaveAs(",,byteSizeBytes");
        return createHFilesStep;
    }

    public HadoopShellExecutable createBulkLoadStep(String jobId) {
        HadoopShellExecutable bulkLoadStep = new HadoopShellExecutable();
        bulkLoadStep.setName("Load HFile to HBase Table");
        StringBuilder cmd = new StringBuilder();
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"input", (String)this.getHFilePath(jobId));
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"htablename", (String)this.seg.getStorageLocationIdentifier());
        HBaseMRSteps.appendExecCmdParameters((StringBuilder)cmd, (String)"cubename", (String)this.seg.getRealization().getName());
        bulkLoadStep.setJobParams(cmd.toString());
        bulkLoadStep.setJobClass(BulkLoadJob.class);
        return bulkLoadStep;
    }

    public MergeGCStep createMergeGCStep() {
        MergeGCStep result = new MergeGCStep();
        result.setName("Garbage Collection");
        result.setOldHTables(this.getMergingHTables());
        return result;
    }

    public List<String> getMergingHTables() {
        List mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments((CubeSegment)this.seg);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)"there should be more than 2 segments to merge");
        ArrayList mergingHTables = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingHTables.add(merging.getStorageLocationIdentifier());
        }
        return mergingHTables;
    }

    public List<String> getMergingHDFSPaths() {
        List mergingSegments = ((CubeInstance)this.seg.getRealization()).getMergingSegments((CubeSegment)this.seg);
        Preconditions.checkState((mergingSegments.size() > 1 ? 1 : 0) != 0, (Object)"there should be more than 2 segments to merge");
        ArrayList mergingHDFSPaths = Lists.newArrayList();
        for (CubeSegment merging : mergingSegments) {
            mergingHDFSPaths.add(this.getJobWorkingDir(merging.getLastBuildJobID()));
        }
        return mergingHDFSPaths;
    }

    public String getHFilePath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/hfile/");
    }

    public String getRowkeyDistributionOutputPath(String jobId) {
        return HBaseConnection.makeQualifiedPathInHBaseCluster(this.getJobWorkingDir(jobId) + "/" + this.seg.getRealization().getName() + "/rowkey_stats");
    }

    public void addMergingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        jobFlow.addTask((AbstractExecutable)this.createMergeGCStep());
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.addAll(this.getMergingHDFSPaths());
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection on HDFS");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }

    public void addCubingGarbageCollectionSteps(DefaultChainedExecutable jobFlow) {
        String jobId = jobFlow.getId();
        ArrayList<String> toDeletePaths = new ArrayList<String>();
        toDeletePaths.add(this.getFactDistinctColumnsPath(jobId));
        HDFSPathGarbageCollectionStep step = new HDFSPathGarbageCollectionStep();
        step.setName("Garbage Collection");
        step.setDeletePaths(toDeletePaths);
        step.setJobId(jobId);
        jobFlow.addTask((AbstractExecutable)step);
    }
}

