/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.engine.mr.IMROutput2;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;
import org.apache.kylin.metadata.realization.IRealizationSegment;
import org.apache.kylin.storage.hbase.steps.HBaseMRSteps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseMROutput2Transition
implements IMROutput2 {
    private static final Logger logger = LoggerFactory.getLogger(HBaseMROutput2Transition.class);

    public IMROutput2.IMRBatchCubingOutputSide2 getBatchCubingOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchCubingOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps((IRealizationSegment)seg);
            }

            public void addStepPhase2_BuildDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStepWithStats(jobFlow.getId()));
            }

            public void addStepPhase3_BuildCube(DefaultChainedExecutable jobFlow, String cuboidRootPath) {
                jobFlow.addTask((AbstractExecutable)this.steps.createConvertCuboidToHfileStep(cuboidRootPath, jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase4_Cleanup(DefaultChainedExecutable jobFlow) {
            }
        };
    }

    public IMROutput2.IMRBatchMergeOutputSide2 getBatchMergeOutputSide(final CubeSegment seg) {
        return new IMROutput2.IMRBatchMergeOutputSide2(){
            HBaseMRSteps steps;
            {
                this.steps = new HBaseMRSteps((IRealizationSegment)seg);
            }

            public void addStepPhase1_MergeDictionary(DefaultChainedExecutable jobFlow) {
                jobFlow.addTask((AbstractExecutable)this.steps.createCreateHTableStepWithStats(jobFlow.getId()));
            }

            public void addStepPhase2_BuildCube(DefaultChainedExecutable jobFlow, String cuboidRootPath) {
                jobFlow.addTask((AbstractExecutable)this.steps.createConvertCuboidToHfileStep(cuboidRootPath, jobFlow.getId()));
                jobFlow.addTask((AbstractExecutable)this.steps.createBulkLoadStep(jobFlow.getId()));
            }

            public void addStepPhase3_Cleanup(DefaultChainedExecutable jobFlow) {
                this.steps.addMergingGarbageCollectionSteps(jobFlow);
            }
        };
    }
}

