/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.engine.mr.HadoopUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.util.HiveCmdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecatedGCStep
extends AbstractExecutable {
    private static final String OLD_HTABLES = "oldHTables";
    private static final String OLD_HIVE_TABLE = "oldHiveTable";
    private static final String OLD_HDFS_PATHS = "oldHdfsPaths";
    private static final Logger logger = LoggerFactory.getLogger(DeprecatedGCStep.class);
    private StringBuffer output = new StringBuffer();

    protected ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        try {
            this.dropHBaseTable(context);
            this.dropHdfsPath(context);
            this.dropHiveTable(context);
        }
        catch (IOException e) {
            logger.error("job:" + this.getId() + " execute finished with exception", (Throwable)e);
            this.output.append("\n").append(e.getLocalizedMessage());
            return new ExecuteResult(ExecuteResult.State.ERROR, this.output.toString());
        }
        return new ExecuteResult(ExecuteResult.State.SUCCEED, this.output.toString());
    }

    private void dropHiveTable(ExecutableContext context) throws IOException {
        String hiveTable = this.getOldHiveTable();
        if (StringUtils.isNotEmpty((String)hiveTable)) {
            String dropSQL = "USE " + context.getConfig().getHiveDatabaseForIntermediateTable() + ";" + " DROP TABLE IF EXISTS  " + hiveTable + ";";
            HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder();
            hiveCmdBuilder.addStatement(dropSQL);
            context.getConfig().getCliCommandExecutor().execute(hiveCmdBuilder.build());
            this.output.append("Dropped Hive table " + hiveTable + " \n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropHBaseTable(ExecutableContext context) throws IOException {
        List<String> oldTables = this.getOldHTables();
        if (oldTables != null && oldTables.size() > 0) {
            String metadataUrlPrefix = KylinConfig.getInstanceFromEnv().getMetadataUrlPrefix();
            Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
            HBaseAdmin admin = null;
            try {
                admin = new HBaseAdmin(conf);
                for (String table : oldTables) {
                    if (!admin.tableExists(table)) continue;
                    HTableDescriptor tableDescriptor = admin.getTableDescriptor(Bytes.toBytes((String)table));
                    String host = tableDescriptor.getValue("KYLIN_HOST");
                    if (metadataUrlPrefix.equalsIgnoreCase(host)) {
                        if (admin.isTableEnabled(table)) {
                            admin.disableTable(table);
                        }
                        admin.deleteTable(table);
                        logger.debug("Dropped HBase table " + table);
                        this.output.append("Dropped HBase table " + table + " \n");
                        continue;
                    }
                    logger.debug("Skipped HBase table " + table);
                    this.output.append("Skipped HBase table " + table + " \n");
                }
            }
            finally {
                if (admin != null) {
                    try {
                        admin.close();
                    }
                    catch (IOException e) {
                        logger.error(e.getLocalizedMessage());
                    }
                }
            }
        }
    }

    private void dropHdfsPath(ExecutableContext context) throws IOException {
        List<String> oldHdfsPaths = this.getOldHdsfPaths();
        if (oldHdfsPaths != null && oldHdfsPaths.size() > 0) {
            Configuration hconf = HadoopUtil.getCurrentConfiguration();
            FileSystem fileSystem = FileSystem.get((Configuration)hconf);
            for (String path : oldHdfsPaths) {
                Path oldPath;
                if (path.endsWith("*")) {
                    path = path.substring(0, path.length() - 1);
                }
                if (fileSystem.exists(oldPath = new Path(path))) {
                    fileSystem.delete(oldPath, true);
                    logger.debug("Dropped HDFS path: " + path);
                    this.output.append("Dropped HDFS path  \"" + path + "\" \n");
                    continue;
                }
                logger.debug("HDFS path not exists: " + path);
                this.output.append("HDFS path not exists: \"" + path + "\" \n");
            }
        }
    }

    public void setOldHTables(List<String> tables) {
        this.setArrayParam(OLD_HTABLES, tables);
    }

    private List<String> getOldHTables() {
        return this.getArrayParam(OLD_HTABLES);
    }

    public void setOldHdsfPaths(List<String> paths) {
        this.setArrayParam(OLD_HDFS_PATHS, paths);
    }

    private List<String> getOldHdsfPaths() {
        return this.getArrayParam(OLD_HDFS_PATHS);
    }

    private void setArrayParam(String paramKey, List<String> paramValues) {
        this.setParam(paramKey, StringUtils.join(paramValues, (String)","));
    }

    private List<String> getArrayParam(String paramKey) {
        String ids = this.getParam(paramKey);
        if (ids != null) {
            String[] splitted = StringUtils.split((String)ids, (String)",");
            ArrayList result = Lists.newArrayListWithExpectedSize((int)splitted.length);
            for (String id : splitted) {
                result.add(id);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public void setOldHiveTable(String hiveTable) {
        this.setParam(OLD_HIVE_TABLE, hiveTable);
    }

    private String getOldHiveTable() {
        return this.getParam(OLD_HIVE_TABLE);
    }
}

