/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2.filter;

import com.google.common.base.Stopwatch;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.kylin.common.util.ByteArray;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.dimension.DimensionEncoding;
import org.apache.kylin.metadata.filter.UDF.MassInValueProvider;
import org.apache.kylin.metadata.filter.function.Functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MassInValueProviderImpl
implements MassInValueProvider {
    public static final Logger logger = LoggerFactory.getLogger(MassInValueProviderImpl.class);
    private static final Cache<String, Pair<Long, Set<ByteArray>>> hdfs_caches = CacheBuilder.newBuilder().maximumSize(3L).removalListener((RemovalListener)new RemovalListener<Object, Object>(){

        public void onRemoval(RemovalNotification<Object, Object> notification) {
            logger.debug(String.valueOf(notification.getCause()));
        }
    }).build();
    private Set<ByteArray> ret;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MassInValueProviderImpl(Functions.FilterTableType filterTableType, String filterResourceIdentifier, DimensionEncoding encoding) {
        block10: {
            this.ret = Sets.newHashSet();
            if (filterTableType == Functions.FilterTableType.HDFS) {
                logger.info("Start to load HDFS filter table from " + filterResourceIdentifier);
                Stopwatch stopwatch = new Stopwatch().start();
                FileSystem fileSystem = null;
                try {
                    Cache<String, Pair<Long, Set<ByteArray>>> cache = hdfs_caches;
                    synchronized (cache) {
                        fileSystem = FileSystem.get((Configuration)HBaseConfiguration.create());
                        long modificationTime = fileSystem.getFileStatus(new Path(filterResourceIdentifier)).getModificationTime();
                        Pair cached = (Pair)hdfs_caches.getIfPresent((Object)filterResourceIdentifier);
                        if (cached != null && ((Long)cached.getFirst()).equals(modificationTime)) {
                            this.ret = (Set)cached.getSecond();
                            logger.info("Load HDFS from cache using " + stopwatch.elapsedMillis() + " millis");
                            return;
                        }
                        FSDataInputStream inputStream = fileSystem.open(new Path(filterResourceIdentifier));
                        List lines = IOUtils.readLines((InputStream)inputStream);
                        logger.info("Load HDFS finished after " + stopwatch.elapsedMillis() + " millis");
                        for (String line : lines) {
                            if (StringUtils.isEmpty((String)line)) continue;
                            try {
                                ByteArray byteArray = ByteArray.allocate((int)encoding.getLengthOfEncoding());
                                encoding.encode(line.getBytes(), line.getBytes().length, byteArray.array(), 0);
                                this.ret.add(byteArray);
                            }
                            catch (Exception e) {
                                logger.warn("Error when encoding the filter line " + line);
                            }
                        }
                        hdfs_caches.put((Object)filterResourceIdentifier, (Object)Pair.newPair((Object)modificationTime, this.ret));
                        logger.info("Mass In values constructed after " + stopwatch.elapsedMillis() + " millis, containing " + this.ret.size() + " entries");
                        break block10;
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException("error when loading the mass in values", e);
                }
            }
            throw new RuntimeException("HBASE_TABLE FilterTableType Not supported yet");
        }
    }

    public Set<?> getMassInValues() {
        return this.ret;
    }
}

