/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.storage.hbase.common.coprocessor.AggrKey;
import org.apache.kylin.storage.hbase.common.coprocessor.AggregationCache;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;

public class ObserverAggregationCache
extends AggregationCache {
    private final ObserverAggregators aggregators;

    public ObserverAggregationCache(ObserverAggregators aggregators) {
        this.aggregators = aggregators;
    }

    public RegionScanner getScanner(RegionScanner innerScanner) {
        return new AggregationRegionScanner(innerScanner);
    }

    @Override
    public MeasureAggregator[] createBuffer() {
        return this.aggregators.createBuffer();
    }

    private class AggregationRegionScanner
    implements RegionScanner {
        private final RegionScanner innerScanner;
        private final Iterator<Map.Entry<AggrKey, MeasureAggregator[]>> iterator;

        public AggregationRegionScanner(RegionScanner innerScanner) {
            this.innerScanner = innerScanner;
            this.iterator = ObserverAggregationCache.this.aggBufMap.entrySet().iterator();
        }

        public boolean next(List<Cell> results) throws IOException {
            try {
                boolean hasMore = false;
                if (this.iterator.hasNext()) {
                    Map.Entry<AggrKey, MeasureAggregator[]> entry = this.iterator.next();
                    this.makeCells(entry, results);
                    hasMore = this.iterator.hasNext();
                }
                return hasMore;
            }
            catch (Exception e) {
                throw new IOException("Error when calling next", e);
            }
        }

        private void makeCells(Map.Entry<AggrKey, MeasureAggregator[]> entry, List<Cell> results) {
            byte[][] families = ObserverAggregationCache.this.aggregators.getHColFamilies();
            byte[][] qualifiers = ObserverAggregationCache.this.aggregators.getHColQualifiers();
            int nHCols = ObserverAggregationCache.this.aggregators.getHColsNum();
            AggrKey rowKey = entry.getKey();
            MeasureAggregator[] aggBuf = entry.getValue();
            ByteBuffer[] rowValues = ObserverAggregationCache.this.aggregators.getHColValues(aggBuf);
            if (nHCols == 0) {
                KeyValue keyValue = new KeyValue(rowKey.get(), rowKey.offset(), rowKey.length(), null, 0, 0, null, 0, 0, Long.MAX_VALUE, KeyValue.Type.Put, null, 0, 0);
                results.add((Cell)keyValue);
            } else {
                for (int i = 0; i < nHCols; ++i) {
                    KeyValue keyValue = new KeyValue(rowKey.get(), rowKey.offset(), rowKey.length(), families[i], 0, families[i].length, qualifiers[i], 0, qualifiers[i].length, Long.MAX_VALUE, KeyValue.Type.Put, rowValues[i].array(), 0, rowValues[i].position());
                    results.add((Cell)keyValue);
                }
            }
        }

        public boolean next(List<Cell> result, int limit) throws IOException {
            return this.next(result);
        }

        public boolean nextRaw(List<Cell> result) throws IOException {
            return this.next(result);
        }

        public boolean nextRaw(List<Cell> result, int limit) throws IOException {
            return this.next(result);
        }

        public void close() throws IOException {
            this.innerScanner.close();
        }

        public HRegionInfo getRegionInfo() {
            return this.innerScanner.getRegionInfo();
        }

        public long getMaxResultSize() {
            return Long.MAX_VALUE;
        }

        public boolean isFilterDone() throws IOException {
            return false;
        }

        public boolean reseek(byte[] row) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getMvccReadPoint() {
            return Long.MAX_VALUE;
        }
    }
}

