/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.storage.hbase.common.coprocessor.AggrKey;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorBehavior;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorFilter;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorProjector;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.AggregateRegionObserver;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregationCache;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverTuple;

public class AggregationScanner
implements RegionScanner {
    private RegionScanner outerScanner;
    private CoprocessorBehavior behavior;

    public AggregationScanner(CoprocessorRowType type, CoprocessorFilter filter, CoprocessorProjector groupBy, ObserverAggregators aggrs, RegionScanner innerScanner, CoprocessorBehavior behavior) throws IOException {
        AggregateRegionObserver.LOG.info((Object)"Kylin Coprocessor start");
        this.behavior = behavior;
        Stats stats = new Stats();
        ObserverAggregationCache aggCache = this.buildAggrCache(innerScanner, type, groupBy, aggrs, filter, stats);
        stats.countOutputRow(aggCache.getSize());
        this.outerScanner = aggCache.getScanner(innerScanner);
        AggregateRegionObserver.LOG.info((Object)("Kylin Coprocessor aggregation done: " + stats));
    }

    ObserverAggregationCache buildAggrCache(RegionScanner innerScanner, CoprocessorRowType type, CoprocessorProjector projector, ObserverAggregators aggregators, CoprocessorFilter filter, Stats stats) throws IOException {
        ObserverAggregationCache aggCache = new ObserverAggregationCache(aggregators);
        ObserverTuple tuple = new ObserverTuple(type);
        boolean hasMore = true;
        ArrayList<Cell> results = new ArrayList<Cell>();
        int meaninglessByte = 0;
        while (hasMore) {
            results.clear();
            hasMore = innerScanner.nextRaw(results);
            if (results.isEmpty()) continue;
            if (stats != null) {
                stats.countInputRow(results);
            }
            Cell cell = (Cell)results.get(0);
            tuple.setUnderlying(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength());
            if (this.behavior == CoprocessorBehavior.SCAN) {
                int endIndex = cell.getRowOffset() + cell.getRowLength();
                for (int i = cell.getRowOffset(); i < endIndex; ++i) {
                    meaninglessByte = (byte)(meaninglessByte + cell.getRowArray()[i]);
                }
                continue;
            }
            if (this.behavior.ordinal() < CoprocessorBehavior.SCAN_FILTER.ordinal() || filter != null && !filter.evaluate(tuple) || this.behavior.ordinal() < CoprocessorBehavior.SCAN_FILTER_AGGR.ordinal()) continue;
            AggrKey aggKey = projector.getAggrKey(results);
            MeasureAggregator[] bufs = aggCache.getBuffer(aggKey);
            aggregators.aggregate(bufs, results);
            if (this.behavior.ordinal() < CoprocessorBehavior.SCAN_FILTER_AGGR_CHECKMEM.ordinal()) continue;
            aggCache.checkMemoryUsage();
        }
        if (this.behavior == CoprocessorBehavior.SCAN) {
            System.out.println("meaningless byte is now " + meaninglessByte);
        }
        return aggCache;
    }

    public boolean next(List<Cell> results) throws IOException {
        return this.outerScanner.next(results);
    }

    public boolean next(List<Cell> result, int limit) throws IOException {
        return this.outerScanner.next(result, limit);
    }

    public boolean nextRaw(List<Cell> result) throws IOException {
        return this.outerScanner.nextRaw(result);
    }

    public boolean nextRaw(List<Cell> result, int limit) throws IOException {
        return this.outerScanner.nextRaw(result, limit);
    }

    public void close() throws IOException {
        this.outerScanner.close();
    }

    public HRegionInfo getRegionInfo() {
        return this.outerScanner.getRegionInfo();
    }

    public boolean isFilterDone() throws IOException {
        return this.outerScanner.isFilterDone();
    }

    public boolean reseek(byte[] row) throws IOException {
        return this.outerScanner.reseek(row);
    }

    public long getMaxResultSize() {
        return this.outerScanner.getMaxResultSize();
    }

    public long getMvccReadPoint() {
        return this.outerScanner.getMvccReadPoint();
    }

    private static class Stats {
        long inputRows = 0L;
        long inputBytes = 0L;
        long outputRows = 0L;

        private Stats() {
        }

        public void countInputRow(List<Cell> row) {
            ++this.inputRows;
            this.inputBytes += (long)row.get(0).getRowLength();
            int n = row.size();
            for (int i = 0; i < n; ++i) {
                this.inputBytes += (long)row.get(i).getValueLength();
            }
        }

        public void countOutputRow(long rowCount) {
            this.outputRows += rowCount;
        }

        public String toString() {
            double percent = (double)this.outputRows / (double)this.inputRows * 100.0;
            return Math.round(percent) + "% = " + this.outputRows + " (out rows) / " + this.inputRows + " (in rows); in bytes = " + this.inputBytes + "; est. out bytes = " + Math.round((double)this.inputBytes * percent / 100.0);
        }
    }
}

