/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorBehavior;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorFilter;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorProjector;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.AggregationScanner;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;

public class AggregateRegionObserver
extends BaseRegionObserver {
    static final Log LOG = LogFactory.getLog(AggregateRegionObserver.class);
    static final String COPROCESSOR_ENABLE = "_Coprocessor_Enable";
    static final String TYPE = "_Type";
    static final String PROJECTOR = "_Projector";
    static final String AGGREGATORS = "_Aggregators";
    static final String FILTER = "_Filter";
    static final String BEHAVIOR = "_Behavior";

    public final RegionScanner postScannerOpen(ObserverContext<RegionCoprocessorEnvironment> ctxt, Scan scan, RegionScanner innerScanner) throws IOException {
        boolean copAbortOnError = ((RegionCoprocessorEnvironment)ctxt.getEnvironment()).getConfiguration().getBoolean("hbase.coprocessor.abortonerror", true);
        if (copAbortOnError) {
            try {
                return this.doPostScannerObserver(ctxt, scan, innerScanner);
            }
            catch (Throwable e) {
                LOG.error((Object)"Kylin Coprocessor Error", e);
                return innerScanner;
            }
        }
        return this.doPostScannerObserver(ctxt, scan, innerScanner);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner doPostScannerObserver(ObserverContext<RegionCoprocessorEnvironment> ctxt, Scan scan, RegionScanner innerScanner) throws IOException {
        byte[] coprocessorEnableBytes = scan.getAttribute(COPROCESSOR_ENABLE);
        if (coprocessorEnableBytes == null || coprocessorEnableBytes.length == 0 || coprocessorEnableBytes[0] == 0) {
            return innerScanner;
        }
        byte[] typeBytes = scan.getAttribute(TYPE);
        CoprocessorRowType type = CoprocessorRowType.deserialize(typeBytes);
        byte[] projectorBytes = scan.getAttribute(PROJECTOR);
        CoprocessorProjector projector = CoprocessorProjector.deserialize(projectorBytes);
        byte[] aggregatorBytes = scan.getAttribute(AGGREGATORS);
        ObserverAggregators aggregators = ObserverAggregators.deserialize(aggregatorBytes);
        byte[] filterBytes = scan.getAttribute(FILTER);
        CoprocessorFilter filter = CoprocessorFilter.deserialize(filterBytes);
        CoprocessorBehavior coprocessorBehavior = CoprocessorBehavior.SCAN_FILTER_AGGR_CHECKMEM;
        try {
            byte[] behavior = scan.getAttribute(BEHAVIOR);
            if (behavior != null && behavior.length != 0) {
                coprocessorBehavior = CoprocessorBehavior.valueOf(new String(behavior));
            }
        }
        catch (Exception e) {
            LOG.error((Object)"failed to parse behavior,using default behavior SCAN_FILTER_AGGR_CHECKMEM", (Throwable)e);
            coprocessorBehavior = CoprocessorBehavior.SCAN_FILTER_AGGR_CHECKMEM;
        }
        HRegion region = ((RegionCoprocessorEnvironment)ctxt.getEnvironment()).getRegion();
        region.startRegionOperation();
        try {
            RegionScanner regionScanner = innerScanner;
            synchronized (regionScanner) {
                AggregationScanner aggregationScanner = new AggregationScanner(type, filter, projector, aggregators, innerScanner, coprocessorBehavior);
                return aggregationScanner;
            }
        }
        finally {
            region.closeRegionOperation();
        }
    }
}

