/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.exception.ScanOutOfLimitException;
import org.apache.kylin.storage.hbase.cube.v1.CubeSegmentTupleIterator;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;
import org.apache.kylin.storage.translate.HBaseKeyRange;

public class SerializedHBaseTupleIterator
implements ITupleIterator {
    private static final int PARTIAL_DEFAULT_LIMIT = 10000;
    private final StorageContext context;
    private final int partialResultLimit;
    private final List<CubeSegmentTupleIterator> segmentIteratorList;
    private final Iterator<CubeSegmentTupleIterator> segmentIteratorIterator;
    private ITupleIterator segmentIterator;
    private int scanCount;
    private ITuple next;

    public SerializedHBaseTupleIterator(HConnection conn, List<HBaseKeyRange> segmentKeyRanges, CubeInstance cube, Set<TblColRef> dimensions, TupleFilter filter, Set<TblColRef> groupBy, List<RowValueDecoder> rowValueDecoders, StorageContext context, TupleInfo returnTupleInfo) {
        this.context = context;
        int limit = context.getLimit();
        this.partialResultLimit = Math.max(limit, 10000);
        this.segmentIteratorList = new ArrayList<CubeSegmentTupleIterator>(segmentKeyRanges.size());
        Map<CubeSegment, List<HBaseKeyRange>> rangesMap = this.makeRangesMap(segmentKeyRanges);
        for (Map.Entry<CubeSegment, List<HBaseKeyRange>> entry : rangesMap.entrySet()) {
            CubeSegmentTupleIterator it = new CubeSegmentTupleIterator(entry.getKey(), entry.getValue(), conn, dimensions, filter, groupBy, rowValueDecoders, context, returnTupleInfo);
            this.segmentIteratorList.add(it);
        }
        this.segmentIteratorIterator = this.segmentIteratorList.iterator();
        this.segmentIterator = this.segmentIteratorIterator.hasNext() ? (ITupleIterator)this.segmentIteratorIterator.next() : ITupleIterator.EMPTY_TUPLE_ITERATOR;
    }

    private Map<CubeSegment, List<HBaseKeyRange>> makeRangesMap(List<HBaseKeyRange> segmentKeyRanges) {
        HashMap map = Maps.newHashMap();
        for (HBaseKeyRange range : segmentKeyRanges) {
            List list = (List)map.get(range.getCubeSegment());
            if (list == null) {
                list = Lists.newArrayList();
                map.put(range.getCubeSegment(), list);
            }
            list.add(range);
        }
        return map;
    }

    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        if (this.context.isLimitEnabled() && this.scanCount >= this.context.getLimit() + this.context.getOffset()) {
            return false;
        }
        if (this.context.isAcceptPartialResult() && this.scanCount > this.partialResultLimit) {
            this.context.setPartialResultReturned(true);
            return false;
        }
        if (this.scanCount >= this.context.getThreshold()) {
            throw new ScanOutOfLimitException("Scan row count exceeded threshold: " + this.context.getThreshold() + ", please add filter condition to narrow down backend scan range, like where clause.");
        }
        if (this.segmentIterator.hasNext()) {
            this.next = (ITuple)this.segmentIterator.next();
            ++this.scanCount;
            return true;
        }
        if (this.segmentIteratorIterator.hasNext()) {
            this.segmentIterator.close();
            this.segmentIterator = this.segmentIteratorIterator.next();
            return this.hasNext();
        }
        return false;
    }

    public ITuple next() {
        if (this.next == null) {
            this.hasNext();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
        }
        ITuple r = this.next;
        this.next = null;
        return r;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.segmentIterator.close();
        while (this.segmentIteratorIterator.hasNext()) {
            this.segmentIterator = this.segmentIteratorIterator.next();
            this.segmentIterator.close();
        }
    }
}

