/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.ShardingHash;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.cube.model.HBaseMappingDesc;
import org.apache.kylin.cube.model.RowKeyDesc;
import org.apache.kylin.dict.lookup.LookupStringTable;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.realization.SQLDigest;
import org.apache.kylin.metadata.tuple.ITupleIterator;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.StorageContext;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.apache.kylin.storage.hbase.cube.v1.SerializedHBaseTupleIterator;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverEnabler;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;
import org.apache.kylin.storage.translate.ColumnValueRange;
import org.apache.kylin.storage.translate.DerivedFilterTranslator;
import org.apache.kylin.storage.translate.HBaseKeyRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CubeStorageQuery
implements IStorageQuery {
    private static final Logger logger = LoggerFactory.getLogger(CubeStorageQuery.class);
    private static final int MERGE_KEYRANGE_THRESHOLD = 100;
    private final CubeInstance cubeInstance;
    private final CubeDesc cubeDesc;
    private final String uuid;

    public CubeStorageQuery(CubeInstance cube) {
        this.cubeInstance = cube;
        this.cubeDesc = cube.getDescriptor();
        this.uuid = cube.getUuid();
    }

    public ITupleIterator search(StorageContext context, SQLDigest sqlDigest, TupleInfo returnTupleInfo) {
        this.notifyBeforeStorageQuery(sqlDigest);
        Collection groups = sqlDigest.groupbyColumns;
        TupleFilter filter = sqlDigest.filter;
        HashSet<TblColRef> dimensions = new HashSet<TblColRef>();
        HashSet<FunctionDesc> metrics = new HashSet<FunctionDesc>();
        this.buildDimensionsAndMetrics(dimensions, metrics, sqlDigest);
        HashSet others = Sets.newHashSet(dimensions);
        others.removeAll(groups);
        HashSet derivedPostAggregation = Sets.newHashSet();
        Set<TblColRef> groupsD = this.expandDerived(groups, derivedPostAggregation);
        Set<TblColRef> othersD = this.expandDerived(others, derivedPostAggregation);
        othersD.removeAll(groupsD);
        HashSet dimensionsD = Sets.newHashSet();
        dimensionsD.addAll(groupsD);
        dimensionsD.addAll(othersD);
        Cuboid cuboid = this.identifyCuboid(dimensionsD, metrics);
        context.setCuboid(cuboid);
        Set<TblColRef> singleValuesD = this.findSingleValueColumns(filter);
        boolean isExactAggregation = this.isExactAggregation(cuboid, groupsD, othersD, singleValuesD, derivedPostAggregation);
        context.setExactAggregation(isExactAggregation);
        HashSet groupsCopD = Sets.newHashSet(groupsD);
        this.collectNonEvaluable(filter, groupsCopD);
        TupleFilter filterD = this.translateDerived(filter, groupsCopD);
        List<HBaseKeyRange> scans = this.buildScanRanges(this.flattenToOrAndFilter(filterD), dimensionsD);
        List<RowValueDecoder> valueDecoders = this.translateAggregation(this.cubeDesc.getHbaseMapping(), metrics, context);
        this.setThreshold(dimensionsD, valueDecoders, context);
        this.setCoprocessor(groupsCopD, valueDecoders, context);
        this.setLimit(filter, context);
        HConnection conn = HBaseConnection.get(context.getConnUrl());
        return new SerializedHBaseTupleIterator(conn, scans, this.cubeInstance, dimensionsD, filterD, groupsCopD, valueDecoders, context, returnTupleInfo);
    }

    private void buildDimensionsAndMetrics(Collection<TblColRef> dimensions, Collection<FunctionDesc> metrics, SQLDigest sqlDigest) {
        for (FunctionDesc func : sqlDigest.aggregations) {
            if (func.isDimensionAsMetric()) continue;
            metrics.add(func);
        }
        for (TblColRef column : sqlDigest.allColumns) {
            if (sqlDigest.metricColumns.contains(column)) continue;
            dimensions.add(column);
        }
    }

    private Cuboid identifyCuboid(Set<TblColRef> dimensions, Collection<FunctionDesc> metrics) {
        for (FunctionDesc metric : metrics) {
            if (!metric.getMeasureType().onlyAggrInBaseCuboid()) continue;
            return Cuboid.getBaseCuboid((CubeDesc)this.cubeDesc);
        }
        long cuboidID = 0L;
        for (TblColRef column : dimensions) {
            int index = this.cubeDesc.getRowkey().getColumnBitIndex(column);
            cuboidID |= 1L << index;
        }
        return Cuboid.findById((CubeDesc)this.cubeDesc, (long)cuboidID);
    }

    private boolean isExactAggregation(Cuboid cuboid, Collection<TblColRef> groups, Set<TblColRef> othersD, Set<TblColRef> singleValuesD, Set<TblColRef> derivedPostAggregation) {
        boolean exact = true;
        if (cuboid.requirePostAggregation()) {
            exact = false;
            logger.info("exactAggregation is false because cuboid " + cuboid.getInputID() + "=> " + cuboid.getId());
        }
        if (!groups.containsAll(derivedPostAggregation)) {
            exact = false;
            logger.info("exactAggregation is false because derived column require post aggregation: " + derivedPostAggregation);
        }
        if (!singleValuesD.containsAll(othersD)) {
            exact = false;
            logger.info("exactAggregation is false because some column not on group by: " + othersD + " (single value column: " + singleValuesD + ")");
        }
        if (exact) {
            logger.info("exactAggregation is true");
        }
        return exact;
    }

    private Set<TblColRef> expandDerived(Collection<TblColRef> cols, Set<TblColRef> derivedPostAggregation) {
        HashSet expanded = Sets.newHashSet();
        for (TblColRef col : cols) {
            if (this.cubeDesc.hasHostColumn(col)) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
                for (TblColRef hostCol : hostInfo.columns) {
                    expanded.add(hostCol);
                    if (hostInfo.isOneToOne) continue;
                    derivedPostAggregation.add(hostCol);
                }
                continue;
            }
            expanded.add(col);
        }
        return expanded;
    }

    private Set<TblColRef> findSingleValueColumns(TupleFilter filter) {
        Collection<Object> toCheck;
        if (filter instanceof CompareTupleFilter) {
            toCheck = Collections.singleton(filter);
        } else if (filter instanceof LogicalTupleFilter && filter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            toCheck = filter.getChildren();
        } else {
            return Collections.EMPTY_SET;
        }
        HashSet result = Sets.newHashSet();
        for (TupleFilter f : toCheck) {
            CompareTupleFilter compFilter;
            if (!(f instanceof CompareTupleFilter) || (compFilter = (CompareTupleFilter)f).getOperator() != TupleFilter.FilterOperatorEnum.EQ || compFilter.getValues().size() != 1 || compFilter.getColumn() == null) continue;
            result.add(compFilter.getColumn());
        }
        HashSet resultD = Sets.newHashSet();
        for (TblColRef col : result) {
            if (this.cubeDesc.isExtendedColumn(col)) {
                throw new CubeDesc.CannotFilterExtendedColumnException(col);
            }
            if (this.cubeDesc.isDerived(col)) {
                CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
                if (!hostInfo.isOneToOne) continue;
                for (TblColRef hostCol : hostInfo.columns) {
                    resultD.add(hostCol);
                }
                continue;
            }
            resultD.add(col);
        }
        return resultD;
    }

    private void collectNonEvaluable(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null) {
            return;
        }
        if (filter.isEvaluable()) {
            for (TupleFilter child : filter.getChildren()) {
                this.collectNonEvaluable(child, collector);
            }
        } else {
            this.collectColumnsRecursively(filter, collector);
        }
    }

    private void collectColumnsRecursively(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null) {
            return;
        }
        if (filter instanceof ColumnTupleFilter) {
            this.collectColumns(((ColumnTupleFilter)filter).getColumn(), collector);
        }
        for (TupleFilter child : filter.getChildren()) {
            this.collectColumnsRecursively(child, collector);
        }
    }

    private void collectColumns(TblColRef col, Set<TblColRef> collector) {
        if (this.cubeDesc.isExtendedColumn(col)) {
            throw new CubeDesc.CannotFilterExtendedColumnException(col);
        }
        if (this.cubeDesc.isDerived(col)) {
            CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(col);
            for (TblColRef h : hostInfo.columns) {
                collector.add(h);
            }
        } else {
            collector.add(col);
        }
    }

    private TupleFilter translateDerived(TupleFilter filter, Set<TblColRef> collector) {
        if (filter == null) {
            return filter;
        }
        if (filter instanceof CompareTupleFilter) {
            return this.translateDerivedInCompare((CompareTupleFilter)filter, collector);
        }
        List children = filter.getChildren();
        ArrayList newChildren = Lists.newArrayListWithCapacity((int)children.size());
        boolean modified = false;
        for (TupleFilter child : children) {
            TupleFilter translated = this.translateDerived(child, collector);
            newChildren.add(translated);
            if (child == translated) continue;
            modified = true;
        }
        if (modified) {
            filter = this.replaceChildren(filter, newChildren);
        }
        return filter;
    }

    private TupleFilter replaceChildren(TupleFilter filter, List<TupleFilter> newChildren) {
        if (filter instanceof LogicalTupleFilter) {
            LogicalTupleFilter r = new LogicalTupleFilter(filter.getOperator());
            r.addChildren(newChildren);
            return r;
        }
        throw new IllegalStateException("Cannot replaceChildren on " + filter);
    }

    private TupleFilter translateDerivedInCompare(CompareTupleFilter compf, Set<TblColRef> collector) {
        if (compf.getColumn() == null || compf.getValues().isEmpty()) {
            return compf;
        }
        TblColRef derived = compf.getColumn();
        if (this.cubeDesc.isExtendedColumn(derived)) {
            throw new CubeDesc.CannotFilterExtendedColumnException(derived);
        }
        if (!this.cubeDesc.isDerived(derived)) {
            return compf;
        }
        CubeDesc.DeriveInfo hostInfo = this.cubeDesc.getHostInfo(derived);
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)this.cubeInstance.getConfig());
        CubeSegment seg = this.cubeInstance.getLatestReadySegment();
        LookupStringTable lookup = cubeMgr.getLookupTable(seg, hostInfo.dimension);
        Pair translated = DerivedFilterTranslator.translate((LookupStringTable)lookup, (CubeDesc.DeriveInfo)hostInfo, (CompareTupleFilter)compf);
        TupleFilter translatedFilter = (TupleFilter)translated.getFirst();
        boolean loosened = (Boolean)translated.getSecond();
        if (loosened) {
            this.collectColumnsRecursively(translatedFilter, collector);
        }
        return translatedFilter;
    }

    private List<RowValueDecoder> translateAggregation(HBaseMappingDesc hbaseMapping, Collection<FunctionDesc> metrics, StorageContext context) {
        HashMap codecMap = Maps.newHashMap();
        for (FunctionDesc aggrFunc : metrics) {
            RowValueDecoder codec;
            Collection hbCols = hbaseMapping.findHBaseColumnByFunction(aggrFunc);
            if (hbCols.isEmpty()) {
                throw new IllegalStateException("can't find HBaseColumnDesc for function " + aggrFunc.getFullExpression());
            }
            HBaseColumnDesc bestHBCol = null;
            int bestIndex = -1;
            Iterator i$ = hbCols.iterator();
            if (i$.hasNext()) {
                HBaseColumnDesc hbCol;
                bestHBCol = hbCol = (HBaseColumnDesc)i$.next();
                bestIndex = hbCol.findMeasure(aggrFunc);
            }
            if ((codec = (RowValueDecoder)codecMap.get(bestHBCol)) == null) {
                codec = new RowValueDecoder(bestHBCol);
                codecMap.put(bestHBCol, codec);
            }
            codec.setProjectIndex(bestIndex);
        }
        return new ArrayList<RowValueDecoder>(codecMap.values());
    }

    private TupleFilter flattenToOrAndFilter(TupleFilter filter) {
        if (filter == null) {
            return null;
        }
        TupleFilter flatFilter = filter.flatFilter();
        if (flatFilter.getOperator() == TupleFilter.FilterOperatorEnum.AND) {
            LogicalTupleFilter f = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
            f.addChild(flatFilter);
            flatFilter = f;
        }
        if (flatFilter.getOperator() != TupleFilter.FilterOperatorEnum.OR) {
            throw new IllegalStateException();
        }
        return flatFilter;
    }

    private List<HBaseKeyRange> buildScanRanges(TupleFilter flatFilter, Collection<TblColRef> dimensionColumns) {
        List<Object> result = Lists.newArrayList();
        logger.info("Current cubeInstance is " + this.cubeInstance + " with " + this.cubeInstance.getSegments().size() + " segs in all");
        List segs = this.cubeInstance.getSegments(SegmentStatusEnum.READY);
        logger.info("READY segs count: " + segs.size());
        StringBuilder sb = new StringBuilder("hbasekeyrange trace: ");
        for (CubeSegment cubeSeg : segs) {
            List<Collection<ColumnValueRange>> orAndDimRanges = this.translateToOrAndDimRanges(flatFilter, cubeSeg);
            if (orAndDimRanges == null) continue;
            ArrayList scanRanges = Lists.newArrayListWithCapacity((int)orAndDimRanges.size());
            for (Collection<ColumnValueRange> andDimRanges : orAndDimRanges) {
                HBaseKeyRange rowKeyRange = new HBaseKeyRange(dimensionColumns, andDimRanges, cubeSeg, this.cubeDesc);
                scanRanges.add(rowKeyRange);
            }
            sb.append(scanRanges.size() + "=(mergeoverlap)>");
            List<HBaseKeyRange> mergedRanges = this.mergeOverlapRanges(scanRanges);
            sb.append(mergedRanges.size() + "=(mergetoomany)>");
            mergedRanges = this.mergeTooManyRanges(mergedRanges);
            sb.append(mergedRanges.size() + ",");
            result.addAll(mergedRanges);
        }
        logger.info(sb.toString());
        logger.info("hbasekeyrange count: " + result.size());
        this.dropUnhitSegments((List<HBaseKeyRange>)result);
        logger.info("hbasekeyrange count after dropping unhit :" + result.size());
        if (this.cubeDesc.isEnableSharding()) {
            result = this.duplicateRangeByShard((List<HBaseKeyRange>)result);
        }
        logger.info("hbasekeyrange count after dropping duplicatebyshard :" + result.size());
        return result;
    }

    private List<Collection<ColumnValueRange>> translateToOrAndDimRanges(TupleFilter flatFilter, CubeSegment cubeSegment) {
        ArrayList result = Lists.newArrayList();
        if (flatFilter == null) {
            result.add(Collections.emptyList());
            return result;
        }
        for (TupleFilter andFilter : flatFilter.getChildren()) {
            if (andFilter.getOperator() != TupleFilter.FilterOperatorEnum.AND) {
                throw new IllegalStateException("Filter should be AND instead of " + andFilter);
            }
            Collection<ColumnValueRange> andRanges = this.translateToAndDimRanges(andFilter.getChildren(), cubeSegment);
            if (andRanges == null) continue;
            result.add(andRanges);
        }
        return this.preprocessConstantConditions(result);
    }

    private List<Collection<ColumnValueRange>> preprocessConstantConditions(List<Collection<ColumnValueRange>> orAndRanges) {
        boolean globalAlwaysTrue = false;
        Iterator<Collection<ColumnValueRange>> iterator = orAndRanges.iterator();
        while (iterator.hasNext()) {
            Collection<ColumnValueRange> andRanges = iterator.next();
            Iterator<ColumnValueRange> iterator2 = andRanges.iterator();
            boolean hasAlwaysFalse = false;
            while (iterator2.hasNext()) {
                ColumnValueRange range = iterator2.next();
                if (range.satisfyAll()) {
                    iterator2.remove();
                    continue;
                }
                if (!range.satisfyNone()) continue;
                hasAlwaysFalse = true;
            }
            if (hasAlwaysFalse) {
                iterator.remove();
                continue;
            }
            if (!andRanges.isEmpty()) continue;
            globalAlwaysTrue = true;
            break;
        }
        if (globalAlwaysTrue) {
            orAndRanges.clear();
            orAndRanges.add(Collections.emptyList());
        }
        return orAndRanges;
    }

    private Collection<ColumnValueRange> translateToAndDimRanges(List<? extends TupleFilter> andFilters, CubeSegment cubeSegment) {
        HashMap<TblColRef, ColumnValueRange> rangeMap = new HashMap<TblColRef, ColumnValueRange>();
        for (TupleFilter tupleFilter : andFilters) {
            CompareTupleFilter comp;
            if (!(tupleFilter instanceof CompareTupleFilter) || (comp = (CompareTupleFilter)tupleFilter).getColumn() == null) continue;
            ColumnValueRange range = new ColumnValueRange(comp.getColumn(), (Collection)comp.getValues(), comp.getOperator());
            this.andMerge(range, rangeMap);
        }
        RowKeyDesc rowkey = cubeSegment.getCubeDesc().getRowkey();
        Iterator iterator = rangeMap.values().iterator();
        while (iterator.hasNext()) {
            ColumnValueRange range = (ColumnValueRange)iterator.next();
            if (rowkey.isUseDictionary(range.getColumn())) {
                range.preEvaluateWithDict(cubeSegment.getDictionary(range.getColumn()));
            }
            if (range.satisfyAll()) {
                iterator.remove();
                continue;
            }
            if (!range.satisfyNone()) continue;
            return null;
        }
        return rangeMap.values();
    }

    private void andMerge(ColumnValueRange range, Map<TblColRef, ColumnValueRange> rangeMap) {
        ColumnValueRange columnRange = rangeMap.get(range.getColumn());
        if (columnRange == null) {
            rangeMap.put(range.getColumn(), range);
        } else {
            columnRange.andMerge(range);
        }
    }

    private List<HBaseKeyRange> mergeOverlapRanges(List<HBaseKeyRange> keyRanges) {
        if (keyRanges.size() <= 1) {
            return keyRanges;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Merging key range from " + keyRanges.size());
        }
        Collections.sort(keyRanges);
        LinkedList<HBaseKeyRange> mergedRanges = new LinkedList<HBaseKeyRange>();
        int beginIndex = 0;
        byte[] maxStopKey = keyRanges.get(0).getStopKey();
        for (int index = 0; index < keyRanges.size(); ++index) {
            HBaseKeyRange keyRange = keyRanges.get(index);
            if (Bytes.compareTo((byte[])maxStopKey, (byte[])keyRange.getStartKey()) < 0) {
                HBaseKeyRange mergedRange = this.mergeKeyRange(keyRanges, beginIndex, index - 1);
                mergedRanges.add(mergedRange);
                beginIndex = index;
            }
            if (Bytes.compareTo((byte[])maxStopKey, (byte[])keyRange.getStopKey()) >= 0) continue;
            maxStopKey = keyRange.getStopKey();
        }
        HBaseKeyRange mergedRange = this.mergeKeyRange(keyRanges, beginIndex, keyRanges.size() - 1);
        mergedRanges.add(mergedRange);
        if (logger.isDebugEnabled()) {
            logger.debug("Merging key range to " + mergedRanges.size());
        }
        return mergedRanges;
    }

    private HBaseKeyRange mergeKeyRange(List<HBaseKeyRange> keyRanges, int from, int to) {
        HBaseKeyRange keyRange = keyRanges.get(from);
        int mergeSize = to - from + 1;
        if (mergeSize > 1) {
            CubeSegment cubeSegment = keyRange.getCubeSegment();
            Cuboid cuboid = keyRange.getCuboid();
            byte[] startKey = keyRange.getStartKey();
            byte[] stopKey = keyRange.getStopKey();
            long partitionColumnStartDate = Long.MAX_VALUE;
            long partitionColumnEndDate = 0L;
            TreeSet<Pair<byte[], byte[]>> newFuzzyKeys = new TreeSet<Pair<byte[], byte[]>>(new Comparator<Pair<byte[], byte[]>>(){

                @Override
                public int compare(Pair<byte[], byte[]> o1, Pair<byte[], byte[]> o2) {
                    int partialResult = Bytes.compareTo((byte[])((byte[])o1.getFirst()), (byte[])((byte[])o2.getFirst()));
                    if (partialResult != 0) {
                        return partialResult;
                    }
                    return Bytes.compareTo((byte[])((byte[])o1.getSecond()), (byte[])((byte[])o2.getSecond()));
                }
            });
            LinkedList newFlatOrAndFilter = Lists.newLinkedList();
            boolean hasNonFuzzyRange = false;
            for (int k = from; k <= to; ++k) {
                HBaseKeyRange nextRange = keyRanges.get(k);
                hasNonFuzzyRange = hasNonFuzzyRange || nextRange.getFuzzyKeys().isEmpty();
                newFuzzyKeys.addAll(nextRange.getFuzzyKeys());
                newFlatOrAndFilter.addAll(nextRange.getFlatOrAndFilter());
                if (Bytes.compareTo((byte[])stopKey, (byte[])nextRange.getStopKey()) < 0) {
                    stopKey = nextRange.getStopKey();
                }
                if (nextRange.getPartitionColumnStartDate() > 0L && nextRange.getPartitionColumnStartDate() < partitionColumnStartDate) {
                    partitionColumnStartDate = nextRange.getPartitionColumnStartDate();
                }
                if (nextRange.getPartitionColumnEndDate() >= Long.MAX_VALUE || nextRange.getPartitionColumnEndDate() <= partitionColumnEndDate) continue;
                partitionColumnEndDate = nextRange.getPartitionColumnEndDate();
            }
            if (hasNonFuzzyRange) {
                newFuzzyKeys.clear();
            }
            partitionColumnStartDate = partitionColumnStartDate == Long.MAX_VALUE ? 0L : partitionColumnStartDate;
            partitionColumnEndDate = partitionColumnEndDate == 0L ? Long.MAX_VALUE : partitionColumnEndDate;
            keyRange = new HBaseKeyRange(cubeSegment, cuboid, startKey, stopKey, (List)Lists.newArrayList(newFuzzyKeys), (List)newFlatOrAndFilter, partitionColumnStartDate, partitionColumnEndDate);
        }
        return keyRange;
    }

    private List<HBaseKeyRange> mergeTooManyRanges(List<HBaseKeyRange> keyRanges) {
        if (keyRanges.size() < 100) {
            return keyRanges;
        }
        LinkedList<HBaseKeyRange> mergedRanges = new LinkedList<HBaseKeyRange>();
        HBaseKeyRange mergedRange = this.mergeKeyRange(keyRanges, 0, keyRanges.size() - 1);
        mergedRanges.add(mergedRange);
        return mergedRanges;
    }

    private void dropUnhitSegments(List<HBaseKeyRange> scans) {
        if (this.cubeDesc.getModel().getPartitionDesc().isPartitioned()) {
            Iterator<HBaseKeyRange> iterator = scans.iterator();
            while (iterator.hasNext()) {
                HBaseKeyRange scan = iterator.next();
                if (scan.hitSegment()) continue;
                iterator.remove();
            }
        }
    }

    private List<HBaseKeyRange> duplicateRangeByShard(List<HBaseKeyRange> scans) {
        ArrayList ret = Lists.newArrayList();
        for (HBaseKeyRange scan : scans) {
            CubeSegment segment = scan.getCubeSegment();
            byte[] startKey = scan.getStartKey();
            byte[] stopKey = scan.getStopKey();
            short cuboidShardNum = segment.getCuboidShardNum(Long.valueOf(scan.getCuboid().getId()));
            short cuboidShardBase = segment.getCuboidBaseShard(Long.valueOf(scan.getCuboid().getId()));
            for (short i = 0; i < cuboidShardNum; i = (short)(i + 1)) {
                short newShard = ShardingHash.normalize((short)cuboidShardBase, (short)i, (int)segment.getTotalShards());
                byte[] newStartKey = this.duplicateKeyAndChangeShard(newShard, startKey);
                byte[] newStopKey = this.duplicateKeyAndChangeShard(newShard, stopKey);
                HBaseKeyRange newRange = new HBaseKeyRange(segment, scan.getCuboid(), newStartKey, newStopKey, scan.getFuzzyKeys(), scan.getFlatOrAndFilter(), scan.getPartitionColumnStartDate(), scan.getPartitionColumnEndDate());
                ret.add(newRange);
            }
        }
        Collections.sort(ret, new Comparator<HBaseKeyRange>(){

            @Override
            public int compare(HBaseKeyRange o1, HBaseKeyRange o2) {
                return Bytes.compareTo((byte[])o1.getStartKey(), (byte[])o2.getStartKey());
            }
        });
        return ret;
    }

    private byte[] duplicateKeyAndChangeShard(short newShard, byte[] bytes) {
        byte[] ret = Arrays.copyOf(bytes, bytes.length);
        BytesUtil.writeShort((short)newShard, (byte[])ret, (int)0, (int)2);
        return ret;
    }

    private void setThreshold(Collection<TblColRef> dimensions, List<RowValueDecoder> valueDecoders, StorageContext context) {
        if (!RowValueDecoder.hasMemHungryMeasures(valueDecoders)) {
            return;
        }
        int rowSizeEst = dimensions.size() * 3;
        for (RowValueDecoder decoder : valueDecoders) {
            MeasureDesc[] measures = decoder.getMeasures();
            BitSet projectionIndex = decoder.getProjectionIndex();
            int i = projectionIndex.nextSetBit(0);
            while (i >= 0) {
                FunctionDesc func = measures[i].getFunction();
                rowSizeEst += func.getReturnDataType().getStorageBytesEstimate();
                i = projectionIndex.nextSetBit(i + 1);
            }
        }
        long rowEst = this.cubeInstance.getConfig().getQueryMemBudget() / (long)rowSizeEst;
        if (rowEst > 0L) {
            logger.info("Memory budget is set to: " + rowEst);
            context.setThreshold((int)rowEst);
        } else {
            logger.info("Memory budget is not set.");
        }
    }

    private void setLimit(TupleFilter filter, StorageContext context) {
        boolean goodSort;
        boolean goodAggr = context.isExactAggregation();
        boolean goodFilter = filter == null || TupleFilter.isEvaluableRecursively((TupleFilter)filter) && context.isCoprocessorEnabled();
        boolean bl = goodSort = !context.hasSort();
        if (goodAggr && goodFilter && goodSort) {
            logger.info("Enable limit " + context.getLimit());
            context.enableLimit();
        }
    }

    private void setCoprocessor(Set<TblColRef> groupsCopD, List<RowValueDecoder> valueDecoders, StorageContext context) {
        ObserverEnabler.enableCoprocessorIfBeneficial(this.cubeInstance, groupsCopD, valueDecoders, context);
    }

    private void notifyBeforeStorageQuery(SQLDigest sqlDigest) {
        for (MeasureDesc measure : this.cubeDesc.getMeasures()) {
            MeasureType measureType = measure.getFunction().getMeasureType();
            measureType.adjustSqlDigest(measure, sqlDigest);
        }
    }
}

