/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.hadoop.io.LongWritable;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.cube.model.HBaseColumnDesc;
import org.apache.kylin.measure.BufferedMeasureEncoder;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.storage.hbase.steps.RowValueDecoder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RowValueDecoderTest
extends LocalFileMetadataTestCase {
    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        MetadataManager.clearCache();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    @Test
    public void testDecode() throws Exception {
        CubeDesc cubeDesc = CubeManager.getInstance((KylinConfig)RowValueDecoderTest.getTestConfig()).getCube("test_kylin_cube_with_slr_ready").getDescriptor();
        HBaseColumnDesc hbaseCol = cubeDesc.getHbaseMapping().getColumnFamily()[0].getColumns()[0];
        BufferedMeasureEncoder codec = new BufferedMeasureEncoder(hbaseCol.getMeasures());
        BigDecimal sum = new BigDecimal("333.1234567");
        BigDecimal min = new BigDecimal("333.1111111");
        BigDecimal max = new BigDecimal("333.1999999");
        LongMutable count = new LongMutable(2L);
        LongMutable item_count = new LongMutable(100L);
        ByteBuffer buf = codec.encode(new Object[]{sum, min, max, count, item_count});
        buf.flip();
        byte[] valueBytes = new byte[buf.limit()];
        System.arraycopy(buf.array(), 0, valueBytes, 0, buf.limit());
        RowValueDecoder rowValueDecoder = new RowValueDecoder(hbaseCol);
        for (MeasureDesc measure : cubeDesc.getMeasures()) {
            FunctionDesc aggrFunc = measure.getFunction();
            int index = hbaseCol.findMeasure(aggrFunc);
            rowValueDecoder.setProjectIndex(index);
        }
        rowValueDecoder.decodeAndConvertJavaObj(valueBytes);
        Object[] measureValues = rowValueDecoder.getValues();
        Assert.assertEquals((Object)"[333.1235, 333.1111, 333.2000, 2, 100]", (Object)Arrays.toString(measureValues));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testError() throws Exception {
        CubeDesc cubeDesc = CubeManager.getInstance((KylinConfig)RowValueDecoderTest.getTestConfig()).getCube("test_kylin_cube_with_slr_ready").getDescriptor();
        HBaseColumnDesc hbaseCol = cubeDesc.getHbaseMapping().getColumnFamily()[0].getColumns()[0];
        BufferedMeasureEncoder codec = new BufferedMeasureEncoder(hbaseCol.getMeasures());
        BigDecimal sum = new BigDecimal("11111111111111111111333.1234567");
        BigDecimal min = new BigDecimal("333.1111111");
        BigDecimal max = new BigDecimal("333.1999999");
        LongWritable count = new LongWritable(2L);
        LongMutable item_count = new LongMutable(100L);
        codec.encode(new Object[]{sum, min, max, count, item_count});
    }
}

