/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.kylin.common.util.Bytes;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorBehavior;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorFilter;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorProjector;
import org.apache.kylin.storage.hbase.common.coprocessor.CoprocessorRowType;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.AggregationScanner;
import org.apache.kylin.storage.hbase.cube.v1.coprocessor.observer.ObserverAggregators;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregateRegionObserverTest {
    byte[] mask = new byte[]{-1, -1, 0, 0};
    byte[] k1 = new byte[]{1, 1, 0, 1};
    byte[] k2 = new byte[]{1, 1, 0, 2};
    byte[] k3 = new byte[]{2, 2, 0, 3};
    byte[] k4 = new byte[]{2, 2, 0, 4};
    ArrayList<Cell> cellsInput = Lists.newArrayList();
    byte[] family = Bytes.toBytes((String)"f");
    byte[] q1 = Bytes.toBytes((String)"q1");
    byte[] q2 = Bytes.toBytes((String)"q2");
    ObserverAggregators.HCol c1 = new ObserverAggregators.HCol(this.family, this.q1, new String[]{"SUM", "COUNT"}, new String[]{"decimal", "long"});
    ObserverAggregators.HCol c2 = new ObserverAggregators.HCol(this.family, this.q2, new String[]{"SUM"}, new String[]{"decimal"});

    @Before
    public void setup() {
        this.cellsInput.add(this.newCell(this.k1, this.c1, "10.5", 1));
        this.cellsInput.add(this.newCell(this.k2, this.c1, "11.5", 2));
        this.cellsInput.add(this.newCell(this.k3, this.c1, "12.5", 3));
        this.cellsInput.add(this.newCell(this.k4, this.c1, "13.5", 4));
        this.cellsInput.add(this.newCell(this.k1, this.c2, "21.5"));
        this.cellsInput.add(this.newCell(this.k2, this.c2, "22.5"));
        this.cellsInput.add(this.newCell(this.k3, this.c2, "23.5"));
        this.cellsInput.add(this.newCell(this.k4, this.c2, "24.5"));
    }

    private Cell newCell(byte[] key, ObserverAggregators.HCol col, String decimal) {
        return this.newCell(key, col, decimal, Integer.MIN_VALUE);
    }

    private Cell newCell(byte[] key, ObserverAggregators.HCol col, String decimal, int number) {
        Object[] objectArray;
        if (number == Integer.MIN_VALUE) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = new BigDecimal(decimal);
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = new BigDecimal(decimal);
            objectArray = objectArray3;
            objectArray3[1] = new LongMutable((long)number);
        }
        Object[] values = objectArray;
        ByteBuffer buf = col.measureCodec.encode(values);
        KeyValue keyValue = new KeyValue(key, 0, key.length, col.family, 0, col.family.length, col.qualifier, 0, col.qualifier.length, Long.MAX_VALUE, KeyValue.Type.Put, buf.array(), 0, buf.position());
        return keyValue;
    }

    @Test
    public void test() throws IOException {
        CoprocessorRowType rowType = this.newRowType();
        CoprocessorProjector projector = new CoprocessorProjector(this.mask, true);
        ObserverAggregators aggregators = new ObserverAggregators(new ObserverAggregators.HCol[]{this.c1, this.c2});
        CoprocessorFilter filter = CoprocessorFilter.deserialize(null);
        HashSet<String> expectedResult = new HashSet<String>();
        expectedResult.add("\\x02\\x02\\x00\\x00, f:q1, [26.0, 7]");
        expectedResult.add("\\x02\\x02\\x00\\x00, f:q2, [48.0]");
        expectedResult.add("\\x01\\x01\\x00\\x00, f:q1, [22.0, 3]");
        expectedResult.add("\\x01\\x01\\x00\\x00, f:q2, [44.0]");
        MockupRegionScanner innerScanner = new MockupRegionScanner(this.cellsInput);
        AggregationScanner aggrScanner = new AggregationScanner(rowType, filter, projector, aggregators, (RegionScanner)innerScanner, CoprocessorBehavior.SCAN_FILTER_AGGR_CHECKMEM);
        ArrayList result = Lists.newArrayList();
        boolean hasMore = true;
        while (hasMore) {
            result.clear();
            hasMore = aggrScanner.next((List)result);
            if (result.isEmpty()) continue;
            Cell cell = (Cell)result.get(0);
            ObserverAggregators.HCol hcol = null;
            if (ObserverAggregators.match((ObserverAggregators.HCol)this.c1, (Cell)cell)) {
                hcol = this.c1;
            } else if (ObserverAggregators.match((ObserverAggregators.HCol)this.c2, (Cell)cell)) {
                hcol = this.c2;
            } else {
                Assert.fail();
            }
            hcol.measureCodec.decode(ByteBuffer.wrap(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()), hcol.measureValues);
            String rowKey = this.toString(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), this.mask);
            String col = Bytes.toString((byte[])hcol.family) + ":" + Bytes.toString((byte[])hcol.qualifier);
            String values = Arrays.toString(hcol.measureValues);
            System.out.println(rowKey);
            System.out.println(col);
            System.out.println(values);
            Assert.assertTrue((boolean)expectedResult.contains(rowKey + ", " + col + ", " + values));
        }
        aggrScanner.close();
    }

    @Test
    public void testNoMeasure() throws IOException {
        CoprocessorRowType rowType = this.newRowType();
        CoprocessorProjector projector = new CoprocessorProjector(this.mask, true);
        ObserverAggregators aggregators = new ObserverAggregators(new ObserverAggregators.HCol[0]);
        CoprocessorFilter filter = CoprocessorFilter.deserialize(null);
        HashSet<String> expectedResult = new HashSet<String>();
        expectedResult.add("\\x02\\x02\\x00\\x00");
        expectedResult.add("\\x01\\x01\\x00\\x00");
        MockupRegionScanner innerScanner = new MockupRegionScanner(this.cellsInput);
        AggregationScanner aggrScanner = new AggregationScanner(rowType, filter, projector, aggregators, (RegionScanner)innerScanner, CoprocessorBehavior.SCAN_FILTER_AGGR_CHECKMEM);
        ArrayList result = Lists.newArrayList();
        boolean hasMore = true;
        while (hasMore) {
            result.clear();
            hasMore = aggrScanner.next((List)result);
            if (result.isEmpty()) continue;
            Cell cell = (Cell)result.get(0);
            String rowKey = this.toString(cell.getRowArray(), cell.getRowOffset(), cell.getRowLength(), this.mask);
            Assert.assertTrue((boolean)expectedResult.contains(rowKey));
        }
        aggrScanner.close();
    }

    private String toString(byte[] array, int offset, short length, byte[] mask) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int ch = array[offset + i] & 0xFF & mask[i];
            result.append(String.format("\\x%02X", ch));
        }
        return result.toString();
    }

    private CoprocessorRowType newRowType() {
        TableDesc t = new TableDesc();
        t.setName("TABLE");
        t.setDatabase("DEFAULT");
        TblColRef[] cols = new TblColRef[]{this.newCol(1, "A", t), this.newCol(2, "B", t), this.newCol(3, "C", t), this.newCol(4, "D", t)};
        int[] sizes = new int[]{1, 1, 1, 1};
        return new CoprocessorRowType(cols, sizes, 0);
    }

    private TblColRef newCol(int i, String name, TableDesc t) {
        return ColumnDesc.mockup((TableDesc)t, (int)i, (String)name, null).getRef();
    }

    public static class MockupRegionScanner
    implements RegionScanner {
        List<Cell> input;
        int i = 0;

        public MockupRegionScanner(List<Cell> cellInputs) {
            this.input = cellInputs;
        }

        public boolean next(List<Cell> results) throws IOException {
            return this.nextRaw(results);
        }

        public boolean next(List<Cell> result, int limit) throws IOException {
            return this.next(result);
        }

        public void close() throws IOException {
        }

        public HRegionInfo getRegionInfo() {
            return null;
        }

        public boolean isFilterDone() throws IOException {
            return false;
        }

        public boolean reseek(byte[] row) throws IOException {
            return false;
        }

        public long getMaxResultSize() {
            return 0L;
        }

        public long getMvccReadPoint() {
            return 0L;
        }

        public boolean nextRaw(List<Cell> result) throws IOException {
            if (this.i < this.input.size()) {
                result.add(this.input.get(this.i));
                ++this.i;
            }
            return this.i < this.input.size();
        }

        public boolean nextRaw(List<Cell> result, int limit) throws IOException {
            return this.nextRaw(result);
        }
    }
}

