/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.measure.MeasureAggregator;
import org.apache.kylin.measure.MeasureIngester;
import org.apache.kylin.measure.MeasureType;
import org.apache.kylin.metadata.MetadataManager;
import org.apache.kylin.metadata.model.FunctionDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.storage.IStorageQuery;
import org.apache.kylin.storage.hbase.cube.v1.CubeStorageQuery;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CubeStorageQueryTest
extends LocalFileMetadataTestCase {
    private CubeInstance cube;

    public CubeManager getCubeManager() {
        return CubeManager.getInstance((KylinConfig)CubeStorageQueryTest.getTestConfig());
    }

    private CubeInstance getTestKylinCubeWithSeller() {
        return this.getCubeManager().getCube("test_kylin_cube_with_slr_empty");
    }

    @Before
    public void setUp() throws Exception {
        this.createTestMetadata();
        MetadataManager.clearCache();
        this.cube = this.getTestKylinCubeWithSeller();
    }

    @After
    public void after() throws Exception {
        this.cleanupTestMetadata();
    }

    private void validateIdentifyCuboidOnStorageQnery(CubeDesc cubeDesc, IStorageQuery query) {
        long baseCuboidId = cubeDesc.getRowkey().getFullMask();
        try {
            Method method = query.getClass().getDeclaredMethod("identifyCuboid", Set.class, Collection.class);
            method.setAccessible(true);
            HashSet dimensions = Sets.newHashSet();
            ArrayList metrics = Lists.newArrayList();
            Object ret = method.invoke((Object)query, dimensions, metrics);
            Assert.assertTrue((boolean)(ret instanceof Cuboid));
            Assert.assertNotEquals((long)baseCuboidId, (long)((Cuboid)ret).getId());
            for (MeasureDesc measureDesc : cubeDesc.getMeasures()) {
                Collections.addAll(metrics, measureDesc.getFunction());
            }
            FunctionDesc mockUpFuncDesc = new FunctionDesc();
            Field field = FunctionDesc.class.getDeclaredField("measureType");
            field.setAccessible(true);
            field.set(mockUpFuncDesc, (Object)new MockUpMeasureType());
            metrics.add(mockUpFuncDesc);
            ret = method.invoke((Object)query, dimensions, metrics);
            Assert.assertEquals((long)baseCuboidId, (long)((Cuboid)ret).getId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testIdentifyCuboidV1() {
        CubeDesc cubeDesc = this.cube.getDescriptor();
        CubeStorageQuery query = new CubeStorageQuery(this.cube);
        this.validateIdentifyCuboidOnStorageQnery(cubeDesc, (IStorageQuery)query);
    }

    @Test
    public void testIdentifyCuboidV2() {
        CubeDesc cubeDesc = this.cube.getDescriptor();
        org.apache.kylin.storage.hbase.cube.v2.CubeStorageQuery query = new org.apache.kylin.storage.hbase.cube.v2.CubeStorageQuery(this.cube);
        this.validateIdentifyCuboidOnStorageQnery(cubeDesc, (IStorageQuery)query);
    }

    class MockUpMeasureType
    extends MeasureType<String> {
        MockUpMeasureType() {
        }

        public MeasureIngester<String> newIngester() {
            return null;
        }

        public MeasureAggregator<String> newAggregator() {
            return null;
        }

        public boolean needRewrite() {
            return false;
        }

        public Class<?> getRewriteCalciteAggrFunctionClass() {
            return null;
        }

        public boolean onlyAggrInBaseCuboid() {
            return true;
        }
    }
}

