/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import java.util.Collection;
import java.util.List;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.filter.TupleFilterSerializer;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.storage.hbase.common.coprocessor.FilterBaseTest;
import org.junit.Assert;
import org.junit.Test;

public class FilterEvaluateTest
extends FilterBaseTest {
    @Test
    public void testEvaluate00() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 0);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)matcheCounts[0]);
    }

    @Test
    public void testEvaluate01() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildEQCompareFilter(groups, 1);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)matcheCounts[1]);
    }

    @Test
    public void testEvaluate02() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter filter = this.buildOrFilter(groups);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)(matcheCounts[0] + matcheCounts[1] - matcheCounts[2]));
    }

    @Test
    public void testEvaluate03() {
        List<TblColRef> groups = this.buildGroups();
        TupleFilter filter = this.buildAndFilter(groups);
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)matcheCounts[2]);
    }

    @Test
    public void testEvaluate04() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "0");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)matcheCounts[2]);
    }

    @Test
    public void testEvaluate05() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "1");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)(matcheCounts[0] - matcheCounts[2]));
    }

    @Test
    public void testEvaluate06() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "2");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 1;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)(matcheCounts[1] - matcheCounts[2]));
    }

    @Test
    public void testEvaluate07() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "3");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)0L);
    }

    @Test
    public void testEvaluate08() {
        List<TblColRef> groups = this.buildGroups();
        CompareTupleFilter filter = this.buildCompareCaseFilter(groups, "4");
        byte[] bytes = TupleFilterSerializer.serialize((TupleFilter)filter, (IFilterCodeSystem)CS);
        TupleFilter newFilter = TupleFilterSerializer.deserialize((byte[])bytes, (IFilterCodeSystem)CS);
        int number = 10000;
        int[] matcheCounts = new int[]{0, 0, 0};
        Collection<Tuple> tuples = this.generateTuple(number, groups, matcheCounts);
        int match = this.evaluateTuples(tuples, newFilter);
        Assert.assertEquals((long)match, (long)(number - matcheCounts[0] - matcheCounts[1] + matcheCounts[2]));
    }
}

