/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.common.coprocessor;

import com.google.common.collect.Lists;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.kylin.common.util.LocalFileMetadataTestCase;
import org.apache.kylin.metadata.filter.CaseTupleFilter;
import org.apache.kylin.metadata.filter.ColumnTupleFilter;
import org.apache.kylin.metadata.filter.CompareTupleFilter;
import org.apache.kylin.metadata.filter.ConstantTupleFilter;
import org.apache.kylin.metadata.filter.DynamicTupleFilter;
import org.apache.kylin.metadata.filter.IFilterCodeSystem;
import org.apache.kylin.metadata.filter.LogicalTupleFilter;
import org.apache.kylin.metadata.filter.StringCodeSystem;
import org.apache.kylin.metadata.filter.TupleFilter;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.IEvaluatableTuple;
import org.apache.kylin.metadata.tuple.Tuple;
import org.apache.kylin.metadata.tuple.TupleInfo;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class FilterBaseTest
extends LocalFileMetadataTestCase {
    static final IFilterCodeSystem CS = StringCodeSystem.INSTANCE;
    private static String[][] SAMPLE_DATA = new String[][]{{"2013-03-10", "2012-01-12", "2014-03-10"}, {"ClothinShoes & Accessories", "ABIN", "FP-GTC", "FP-NON-GTC"}};

    @BeforeClass
    public static void setUp() throws Exception {
        FilterBaseTest.staticCreateTestMetadata();
    }

    @AfterClass
    public static void after() throws Exception {
        FilterBaseTest.cleanAfterClass();
    }

    protected List<TblColRef> buildGroups() {
        ArrayList<TblColRef> groups = new ArrayList<TblColRef>();
        TableDesc t1 = TableDesc.mockup((String)"DEFAULT.TEST_KYLIN_FACT");
        ColumnDesc c1 = ColumnDesc.mockup((TableDesc)t1, (int)2, (String)"CAL_DT", (String)"string");
        TblColRef cf1 = c1.getRef();
        groups.add(cf1);
        TableDesc t2 = TableDesc.mockup((String)"DEFAULT.TEST_CATEGORY_GROUPINGS");
        ColumnDesc c2 = ColumnDesc.mockup((TableDesc)t2, (int)14, (String)"META_CATEG_NAME", (String)"string");
        TblColRef cf2 = c2.getRef();
        groups.add(cf2);
        return groups;
    }

    protected CompareTupleFilter buildEQCompareFilter(List<TblColRef> groups, int index) {
        TblColRef column = groups.get(index);
        CompareTupleFilter compareFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
        ColumnTupleFilter columnFilter = new ColumnTupleFilter(column);
        compareFilter.addChild((TupleFilter)columnFilter);
        ConstantTupleFilter constantFilter = null;
        if (index == 0) {
            constantFilter = new ConstantTupleFilter((Object)"2013-03-10");
        } else if (index == 1) {
            constantFilter = new ConstantTupleFilter((Object)"ClothinShoes & Accessories");
        }
        compareFilter.addChild((TupleFilter)constantFilter);
        return compareFilter;
    }

    protected CompareTupleFilter buildINCompareFilter(TblColRef dateColumn) throws ParseException {
        CompareTupleFilter compareFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.IN);
        ColumnTupleFilter columnFilter = new ColumnTupleFilter(dateColumn);
        compareFilter.addChild((TupleFilter)columnFilter);
        ArrayList inValues = Lists.newArrayList();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Date startDate = simpleDateFormat.parse("1970-01-01");
        Date endDate = simpleDateFormat.parse("2100-01-01");
        Calendar start = Calendar.getInstance();
        start.setTime(startDate);
        Calendar end = Calendar.getInstance();
        end.setTime(endDate);
        Date date = start.getTime();
        while (start.before(end)) {
            inValues.add(simpleDateFormat.format(date));
            start.add(5, 1);
            date = start.getTime();
        }
        ConstantTupleFilter constantFilter = new ConstantTupleFilter((Collection)inValues);
        compareFilter.addChild((TupleFilter)constantFilter);
        return compareFilter;
    }

    protected TupleFilter buildAndFilter(List<TblColRef> columns) {
        CompareTupleFilter compareFilter1 = this.buildEQCompareFilter(columns, 0);
        CompareTupleFilter compareFilter2 = this.buildEQCompareFilter(columns, 1);
        LogicalTupleFilter andFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.AND);
        andFilter.addChild((TupleFilter)compareFilter1);
        andFilter.addChild((TupleFilter)compareFilter2);
        return andFilter;
    }

    protected TupleFilter buildOrFilter(List<TblColRef> columns) {
        CompareTupleFilter compareFilter1 = this.buildEQCompareFilter(columns, 0);
        CompareTupleFilter compareFilter2 = this.buildEQCompareFilter(columns, 1);
        LogicalTupleFilter logicFilter = new LogicalTupleFilter(TupleFilter.FilterOperatorEnum.OR);
        logicFilter.addChild((TupleFilter)compareFilter1);
        logicFilter.addChild((TupleFilter)compareFilter2);
        return logicFilter;
    }

    protected CaseTupleFilter buildCaseFilter(List<TblColRef> groups) {
        CaseTupleFilter caseFilter = new CaseTupleFilter();
        TupleFilter when0 = this.buildAndFilter(groups);
        caseFilter.addChild(when0);
        ConstantTupleFilter then0 = new ConstantTupleFilter((Object)"0");
        caseFilter.addChild((TupleFilter)then0);
        CompareTupleFilter when1 = this.buildEQCompareFilter(groups, 0);
        caseFilter.addChild((TupleFilter)when1);
        ConstantTupleFilter then1 = new ConstantTupleFilter((Object)"1");
        caseFilter.addChild((TupleFilter)then1);
        CompareTupleFilter when2 = this.buildEQCompareFilter(groups, 1);
        caseFilter.addChild((TupleFilter)when2);
        ConstantTupleFilter then2 = new ConstantTupleFilter((Object)"2");
        caseFilter.addChild((TupleFilter)then2);
        TupleFilter when3 = this.buildOrFilter(groups);
        caseFilter.addChild(when3);
        ConstantTupleFilter then3 = new ConstantTupleFilter((Object)"3");
        caseFilter.addChild((TupleFilter)then3);
        ConstantTupleFilter else4 = new ConstantTupleFilter((Object)"4");
        caseFilter.addChild((TupleFilter)else4);
        return caseFilter;
    }

    protected CompareTupleFilter buildCompareCaseFilter(List<TblColRef> groups, String constValue) {
        CompareTupleFilter compareFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
        CaseTupleFilter caseFilter = this.buildCaseFilter(groups);
        compareFilter.addChild((TupleFilter)caseFilter);
        ConstantTupleFilter constantFilter = new ConstantTupleFilter((Object)constValue);
        compareFilter.addChild((TupleFilter)constantFilter);
        return compareFilter;
    }

    protected CompareTupleFilter buildCompareDynamicFilter(List<TblColRef> groups) {
        CompareTupleFilter compareFilter = new CompareTupleFilter(TupleFilter.FilterOperatorEnum.EQ);
        compareFilter.addChild((TupleFilter)new ColumnTupleFilter(groups.get(0)));
        compareFilter.addChild((TupleFilter)new DynamicTupleFilter("?0"));
        compareFilter.bindVariable("?0", (Object)"abc");
        return compareFilter;
    }

    protected void compareFilter(TupleFilter f1, TupleFilter f2) {
        int s2;
        String str2;
        if (f1 == null && f2 == null) {
            return;
        }
        if (f1 == null || f2 == null) {
            throw new IllegalStateException("f1=" + f1 + ", f2=" + f2);
        }
        String str1 = f1.toString();
        if (!str1.equals(str2 = f2.toString())) {
            throw new IllegalStateException("f1=" + str1 + ", f2=" + str2);
        }
        int s1 = f1.getChildren().size();
        if (s1 != (s2 = f2.getChildren().size())) {
            throw new IllegalStateException("f1=" + str1 + ", f2=" + str2 + " has different children: " + s1 + " vs. " + s2);
        }
        for (int i = 0; i < s1; ++i) {
            this.compareFilter((TupleFilter)f1.getChildren().get(i), (TupleFilter)f2.getChildren().get(i));
        }
    }

    protected Collection<Tuple> generateTuple(int number, List<TblColRef> columns, int[] matches) {
        ArrayList<Tuple> tuples = new ArrayList<Tuple>(number);
        TupleInfo info = new TupleInfo();
        for (int i = 0; i < columns.size(); ++i) {
            TblColRef column = columns.get(i);
            info.setField(column.getName(), column, i);
        }
        int allMatches = 0;
        Random rand = new Random();
        for (int i = 0; i < number; ++i) {
            Tuple t = new Tuple(info);
            boolean isFullMatch = true;
            for (int k = 0; k < columns.size(); ++k) {
                TblColRef column = columns.get(k);
                int index = Math.abs(rand.nextInt()) % SAMPLE_DATA[k].length;
                t.setDimensionValue(column.getName(), SAMPLE_DATA[k][index]);
                if (index == 0) {
                    int n = k;
                    matches[n] = matches[n] + 1;
                    continue;
                }
                isFullMatch = false;
            }
            if (isFullMatch) {
                ++allMatches;
            }
            tuples.add(t);
        }
        matches[2] = allMatches;
        return tuples;
    }

    protected int evaluateTuples(Collection<Tuple> tuples, TupleFilter filter) {
        int match = 0;
        for (Tuple t : tuples) {
            if (!filter.evaluate((IEvaluatableTuple)t, CS)) continue;
            ++match;
        }
        return match;
    }
}

