/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.util.Util;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.util.RelAggPushDownUtil;

public class RuleUtils {
    private RuleUtils() {
    }

    public static boolean isJoinOnlyOneAggChild(KapJoinRel joinRel) {
        RelNode joinRightChild;
        RelNode joinLeftChild;
        RelNode joinLeft = joinRel.getLeft();
        RelNode joinRight = joinRel.getRight();
        if (joinLeft instanceof RelSubset && joinRight instanceof RelSubset) {
            RelSubset joinLeftChildSub = (RelSubset)joinLeft;
            RelSubset joinRightChildSub = (RelSubset)joinRight;
            joinLeftChild = (RelNode)Util.first((Object)joinLeftChildSub.getBest(), (Object)joinLeftChildSub.getOriginal());
            joinRightChild = (RelNode)Util.first((Object)joinRightChildSub.getBest(), (Object)joinRightChildSub.getOriginal());
        } else if (joinLeft instanceof HepRelVertex && joinRight instanceof HepRelVertex) {
            joinLeftChild = ((HepRelVertex)joinLeft).getCurrentRel();
            joinRightChild = ((HepRelVertex)joinRight).getCurrentRel();
        } else {
            return false;
        }
        String project = QueryContext.current().getProject();
        if (project != null && NProjectManager.getProjectConfig((String)project).isEnhancedAggPushDownEnabled() && RelAggPushDownUtil.canRelAnsweredBySnapshot((String)project, (RelNode)joinRight) && RelAggPushDownUtil.isUnmatchedJoinRel((KapJoinRel)joinRel)) {
            QueryContext.current().setEnhancedAggPushDown(true);
            return true;
        }
        return RuleUtils.isContainAggregate(joinLeftChild) ^ RuleUtils.isContainAggregate(joinRightChild);
    }

    private static boolean isContainAggregate(RelNode node) {
        final boolean[] isContainAggregate = new boolean[]{false};
        new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (isContainAggregate[0]) {
                    return;
                }
                RelNode relNode = node;
                if (node instanceof RelSubset) {
                    relNode = (RelNode)Util.first((Object)((RelSubset)node).getBest(), (Object)((RelSubset)node).getOriginal());
                } else if (node instanceof HepRelVertex) {
                    relNode = ((HepRelVertex)node).getCurrentRel();
                }
                if (relNode instanceof Aggregate) {
                    isContainAggregate[0] = true;
                }
                super.visit(relNode, ordinal, parent);
            }
        }.go(node);
        return isContainAggregate[0];
    }

    public static boolean isCast(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        return SqlKind.CAST == rexNode.getKind();
    }

    public static boolean isPlainTableColumn(int colIdx, RelNode relNode) {
        if (relNode instanceof HepRelVertex) {
            relNode = ((HepRelVertex)relNode).getCurrentRel();
        }
        if (relNode instanceof TableScan) {
            return true;
        }
        if (relNode instanceof Join) {
            Join join = (Join)relNode;
            int offset = 0;
            for (RelNode input : join.getInputs()) {
                if (colIdx >= offset && colIdx < offset + input.getRowType().getFieldCount()) {
                    return RuleUtils.isPlainTableColumn(colIdx - offset, input);
                }
                offset += input.getRowType().getFieldCount();
            }
        } else if (relNode instanceof Project) {
            RexNode inputRex = (RexNode)((Project)relNode).getProjects().get(colIdx);
            if (inputRex instanceof RexInputRef) {
                return RuleUtils.isPlainTableColumn(((RexInputRef)inputRex).getIndex(), ((Project)relNode).getInput());
            }
        } else if (relNode instanceof Filter) {
            return RuleUtils.isPlainTableColumn(colIdx, relNode.getInput(0));
        }
        return false;
    }

    public static boolean containCast(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        if (SqlKind.CAST == rexNode.getKind()) {
            RexNode operand = (RexNode)((RexCall)rexNode).getOperands().get(0);
            return !(operand instanceof RexCall) || operand.getKind() == SqlKind.CASE;
        }
        return false;
    }

    public static boolean isNotNullLiteral(RexNode node) {
        return !RuleUtils.isNullLiteral(node);
    }

    public static boolean isNullLiteral(RexNode node) {
        return node instanceof RexLiteral && ((RexLiteral)node).isNull();
    }
}

