/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryModelPriorities {
    private static final Pattern MODEL_PRIORITY_PATTERN = Pattern.compile("SELECT\\W+/\\*\\+\\W*([^*/]+)\\*/");
    private static final Pattern CUBE_PRIORITY_PATTERN = Pattern.compile("(?<=--(\\s){0,2}CubePriority\\().*(?=\\)(\\s)*[\r\n])");

    private QueryModelPriorities() {
    }

    private static String getHint(String sql) {
        Matcher matcher = MODEL_PRIORITY_PATTERN.matcher(sql.toUpperCase(Locale.ROOT));
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    public static String[] getModelPrioritiesFromComment(String sql) {
        String[] models = QueryModelPriorities.doGetModelPrioritiesFromComment(sql);
        if (models.length > 0) {
            return models;
        }
        return QueryModelPriorities.loadCubePriorityFromComment(sql);
    }

    static String[] doGetModelPrioritiesFromComment(String sql) {
        String hint = QueryModelPriorities.getHint(sql).toUpperCase(Locale.ROOT);
        if (hint.isEmpty() || hint.indexOf("MODEL_PRIORITY(") != 0) {
            return new String[0];
        }
        String[] modelHints = hint.replace("MODEL_PRIORITY(", "").replace(")", "").split(",");
        for (int i = 0; i < modelHints.length; ++i) {
            modelHints[i] = modelHints[i].trim();
        }
        return modelHints;
    }

    static String[] loadCubePriorityFromComment(String sql) {
        Matcher matcher = CUBE_PRIORITY_PATTERN.matcher(sql + "\n");
        if (matcher.find()) {
            String cubeNames = matcher.group().trim().toUpperCase(Locale.ROOT);
            return cubeNames.split(",");
        }
        return new String[0];
    }
}

