/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.sql.SQLException;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;

public class QueryHelper {
    static final String RUN_CONSTANT_QUERY_LOCALLY = "kylin.query.engine.run-constant-query-locally";

    private QueryHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset<Row> singleQuery(String sql, String project) throws SQLException {
        String prevRunLocalConf = Unsafe.setProperty((String)RUN_CONSTANT_QUERY_LOCALLY, (String)"FALSE");
        try {
            KylinConfigExt projectKylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(project).getConfig();
            QueryExec queryExec = new QueryExec(project, (KylinConfig)projectKylinConfig);
            QueryParams queryParams = new QueryParams(NProjectManager.getProjectConfig((String)project), sql, project, 0, 0, queryExec.getDefaultSchemaName(), true);
            String convertedSql = QueryUtil.massageSql((QueryParams)queryParams);
            queryExec.executeQuery(convertedSql);
        }
        finally {
            if (prevRunLocalConf == null) {
                Unsafe.clearProperty((String)RUN_CONSTANT_QUERY_LOCALLY);
            } else {
                Unsafe.setProperty((String)RUN_CONSTANT_QUERY_LOCALLY, (String)prevRunLocalConf);
            }
        }
        return SparderEnv.getDF();
    }

    public static Dataset<Row> sql(SparkSession session, String project, String sqlText) {
        try {
            return QueryHelper.singleQuery(sqlText, project);
        }
        catch (SQLException e) {
            return session.sql(sqlText);
        }
    }
}

