/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.metadata.realization.NoStreamingRealizationFoundException;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.routing.RealizationChooser;
import org.apache.kylin.query.util.ContextInitialCutStrategy;
import org.apache.kylin.query.util.ContextReCutStrategy;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryContextCutter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueryContextCutter.class);
    private static final int MAX_RETRY_TIMES_OF_CONTEXT_CUT = 10;

    private QueryContextCutter() {
    }

    public static void analyzeOlapContext(RelNode root) {
        QueryContextCutter.cutContext(new ContextInitialCutStrategy(), (OLAPRel)((KapRel)root.getInput(0)), root);
        QueryContextCutter.fillOlapContextPropertiesWithRelTree(root);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<OLAPContext> selectRealization(RelNode root, boolean isReCutBanned) {
        ContextInitialCutStrategy firstRoundStrategy = new ContextInitialCutStrategy();
        ContextReCutStrategy reCutStrategy = new ContextReCutStrategy();
        QueryContextCutter.cutContext(firstRoundStrategy, (OLAPRel)((KapRel)root.getInput(0)), root);
        int retryCutTimes = 0;
        while (retryCutTimes++ < 10) {
            try {
                QueryContextCutter.fillOlapContextPropertiesWithRelTree(root);
                List<OLAPContext> olapContexts = QueryContextCutter.chooseCandidate();
                if (isReCutBanned) {
                    throw new NoRealizationFoundException("There is no need to select realizations for OlapContexts.");
                }
                List<OLAPContext> list = olapContexts;
                return list;
            }
            catch (NoRealizationFoundException | NoStreamingRealizationFoundException e) {
                if (isReCutBanned && e instanceof NoStreamingRealizationFoundException) {
                    QueryContextCutter.checkStreamingTableWithAutoModeling();
                } else if (isReCutBanned || e instanceof NoStreamingRealizationFoundException) {
                    throw e;
                }
                reCutStrategy.tryCutToSmallerContexts(root, (RuntimeException)e);
            }
            finally {
                if (!isReCutBanned) continue;
                ContextUtil.listContextsHavingScan().forEach(olapContext -> {
                    if (olapContext.realization != null) {
                        olapContext.unfixModel();
                    }
                });
            }
        }
        String errorMsg = "too many unmatched joins in this query, please check it or create corresponding realization.";
        ContextUtil.dumpCalcitePlan((String)("cannot find proper realizations After re-cut 10 times. \nError: " + errorMsg), (RelNode)root, (Logger)log);
        throw new NoRealizationFoundException(errorMsg);
    }

    private static void fillOlapContextPropertiesWithRelTree(RelNode queryRoot) {
        OLAPRel.OLAPImplementor kapImplementor = new OLAPRel.OLAPImplementor();
        kapImplementor.visitChild(queryRoot.getInput(0), queryRoot);
        QueryContext.current().record("collect_olap_context_info");
    }

    private static List<OLAPContext> chooseCandidate() {
        List contexts = ContextUtil.listContextsHavingScan();
        contexts.forEach(olapContext -> {
            olapContext.setHasSelected(true);
            log.info("Context for realization matching: {}", olapContext);
        });
        long selectLayoutStartTime = System.currentTimeMillis();
        if (contexts.size() > 1) {
            RealizationChooser.multiThreadSelectLayoutCandidate((List)contexts);
        } else {
            RealizationChooser.selectLayoutCandidate((List)contexts);
        }
        log.info("select layout candidate for {} olapContext cost {} ms", (Object)contexts.size(), (Object)(System.currentTimeMillis() - selectLayoutStartTime));
        QueryContext.current().record("end select realization");
        return contexts;
    }

    static void cutContext(ICutContextStrategy strategy, OLAPRel rootOfSubCtxTree, RelNode queryRoot) {
        if (strategy.needCutOff(rootOfSubCtxTree)) {
            strategy.cutOffContext(rootOfSubCtxTree, queryRoot);
        }
        if (strategy instanceof ContextInitialCutStrategy) {
            ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER OLAPCONTEXT IS SET IN FIRST ROUND", (RelNode)queryRoot, (Logger)log);
        } else {
            ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER OLAPCONTEXT IS RE-CUT OFF ", (RelNode)queryRoot, (Logger)log);
        }
    }

    private static void checkStreamingTableWithAutoModeling() {
        for (OLAPContext context : ContextUtil.listContextsHavingScan()) {
            for (OLAPTableScan tableScan : context.allTableScans) {
                TableDesc tableDesc = tableScan.getTableRef().getTableDesc();
                if (1 != tableDesc.getSourceType() || !tableDesc.getKafkaConfig().hasBatchTable()) continue;
                throw new NoStreamingRealizationFoundException((ErrorCodeSupplier)ServerErrorCode.STREAMING_TABLE_NOT_SUPPORT_AUTO_MODELING, String.format(Locale.ROOT, MsgPicker.getMsg().getStreamingTableNotSupportAutoModeling(), new Object[0]));
            }
        }
        throw new NoRealizationFoundException("No realization found for auto modeling.");
    }
}

