/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOrderBy;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWith;
import org.apache.calcite.sql.SqlWithItem;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataLoadingRange;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.tool.CalciteParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterPushDownUtil {
    private static final Logger logger = LoggerFactory.getLogger(FilterPushDownUtil.class);
    private static final String HIVE_DEFAULT_SCHEMA = "DEFAULT";

    static String applyDataLoadingRange(String sqlToUpdate, NDataLoadingRange range) throws SqlParseException {
        Preconditions.checkNotNull((Object)range);
        SegmentRange readySegmentRange = range.getCoveredRange();
        Preconditions.checkNotNull((Object)readySegmentRange);
        String tableName = range.getTableName();
        String columnName = range.getColumnName();
        String[] schemaAndShortName = tableName.split("\\.");
        Preconditions.checkState((schemaAndShortName.length == 2 ? 1 : 0) != 0);
        String start = DateFormat.formatToDateStr((long)((Long)readySegmentRange.getStart()), (String)"yyyy-MM-dd");
        String waterMark = DateFormat.formatToDateStr((long)((Long)readySegmentRange.getEnd()), (String)"yyyy-MM-dd");
        String extraCondition = String.format(Locale.ROOT, "%s >= '%s' and %s <= '%s'", columnName, start, columnName, waterMark);
        return FilterPushDownUtil.applyFilterCondition(sqlToUpdate, extraCondition, tableName);
    }

    static String applyFilterCondition(String sqlToUpdate, String extraCondition, String targetTable) throws SqlParseException {
        targetTable = FilterPushDownUtil.quickTableCheck(sqlToUpdate, targetTable);
        SqlCall inputToNode = (SqlCall)CalciteParser.parse((String)sqlToUpdate);
        ConditionModifier modifier = new ConditionModifier(targetTable, extraCondition);
        modifier.visit(inputToNode);
        return inputToNode.toSqlString(SqlDialect.DatabaseProduct.HIVE.getDialect()).toString();
    }

    private static String quickTableCheck(String sql, String targetTable) {
        Preconditions.checkNotNull((Object)targetTable);
        String[] names = targetTable.split("\\.");
        Preconditions.checkState((names.length == 2 && names[0].length() > 0 && names[1].length() > 0 ? 1 : 0) != 0, (Object)("Malformed target table '" + targetTable + "', missing schema or table name."));
        if (names[0].trim().equalsIgnoreCase(HIVE_DEFAULT_SCHEMA)) {
            targetTable = names[1];
        }
        Preconditions.checkState((boolean)sql.contains(targetTable), (Object)("The target table '" + targetTable + "' cannot be found in query\n." + sql));
        return targetTable;
    }

    private static class AliasModifier
    extends SqlBasicVisitor {
        private String aliasName;

        AliasModifier(String aliasName) {
            this.aliasName = aliasName;
        }

        public SqlCall visit(SqlCall call) {
            if (call instanceof SqlBasicCall) {
                SqlBasicCall basicCall = (SqlBasicCall)call;
                for (SqlNode node : basicCall.getOperands()) {
                    node.accept((SqlVisitor)this);
                }
            }
            return null;
        }

        public SqlIdentifier visit(SqlIdentifier identifier) {
            if (identifier.names.size() == 2) {
                Object[] values = (String[])identifier.names.toArray((Object[])new String[0]);
                values[0] = this.aliasName;
                identifier.names = ImmutableList.copyOf((Object[])values);
            }
            return null;
        }
    }

    private static class ConditionModifier
    extends SqlBasicVisitor {
        private final String targetTable;
        private final String filterCondition;

        ConditionModifier(String targetTable, String filterCondition) {
            this.targetTable = targetTable.toUpperCase(Locale.ROOT);
            this.filterCondition = filterCondition;
        }

        public Object visit(SqlNodeList nodeList) {
            for (SqlNode node : nodeList) {
                if (!(node instanceof SqlWithItem)) continue;
                SqlWithItem item = (SqlWithItem)node;
                item.query.accept((SqlVisitor)this);
            }
            return null;
        }

        public Object visit(SqlCall call) {
            if (call instanceof SqlSelect) {
                SqlSelect select = (SqlSelect)call;
                select.getFrom().accept((SqlVisitor)this);
                try {
                    this.updateTableScanSelect(select);
                }
                catch (SqlParseException e) {
                    throw new IllegalArgumentException("While parsing filter condition '" + this.filterCondition + "' throws an " + e.getCause().getClass().getName());
                }
                return null;
            }
            if (call instanceof SqlOrderBy) {
                SqlOrderBy orderBy = (SqlOrderBy)call;
                orderBy.query.accept((SqlVisitor)this);
                return null;
            }
            if (call instanceof SqlWith) {
                SqlWith sqlWith = (SqlWith)call;
                sqlWith.withList.accept((SqlVisitor)this);
                sqlWith.body.accept((SqlVisitor)this);
            }
            if (call instanceof SqlBasicCall) {
                SqlBasicCall basicCall = (SqlBasicCall)call;
                for (SqlNode node : basicCall.getOperands()) {
                    node.accept((SqlVisitor)this);
                }
                return null;
            }
            if (call instanceof SqlJoin) {
                SqlJoin node = (SqlJoin)call;
                node.getRight().accept((SqlVisitor)this);
                node.getLeft().accept((SqlVisitor)this);
                return null;
            }
            return null;
        }

        private void updateTableScanSelect(SqlSelect sqlSelectToUpdate) throws SqlParseException {
            ArrayList nameAliasNamePairs = Lists.newArrayList();
            SqlNode from = sqlSelectToUpdate.getFrom();
            LinkedList<SqlNode> queue = new LinkedList<SqlNode>();
            queue.push(from);
            while (queue.size() > 0) {
                SqlNode pop = (SqlNode)queue.pop();
                if (pop instanceof SqlIdentifier) {
                    nameAliasNamePairs.add(new Pair((Object)pop.toString(), (Object)""));
                } else if (this.sqlKindEqualsAs(pop)) {
                    this.extractNames(nameAliasNamePairs, pop);
                }
                if (!(pop instanceof SqlJoin)) continue;
                queue.push(((SqlJoin)pop).getLeft());
                queue.push(((SqlJoin)pop).getRight());
            }
            for (Pair pair : nameAliasNamePairs) {
                if (!((String)pair.getFirst()).contains(this.targetTable)) continue;
                SqlNode toAppend = this.createCondition(this.filterCondition, (Pair<String, String>)pair);
                if (sqlSelectToUpdate.getWhere() == null) {
                    sqlSelectToUpdate.setWhere(toAppend);
                    continue;
                }
                SqlNode where = sqlSelectToUpdate.getWhere();
                SqlBasicCall newWhere = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AND, new SqlNode[]{where, toAppend}, where.getParserPosition());
                sqlSelectToUpdate.setWhere((SqlNode)newWhere);
            }
        }

        private boolean sqlKindEqualsAs(SqlNode node) {
            return node instanceof SqlBasicCall && node.getKind() == SqlKind.AS;
        }

        private void extractNames(List<Pair<String, String>> nameAndAliasNames, SqlNode node) {
            SqlBasicCall call;
            SqlNode sqlNode;
            if (node instanceof SqlBasicCall && (sqlNode = (call = (SqlBasicCall)node).getOperands()[0]) instanceof SqlIdentifier) {
                String name = sqlNode.toString();
                String aliasName = call.getOperands()[1].toString();
                nameAndAliasNames.add((Pair<String, String>)new Pair((Object)name, (Object)aliasName));
            }
        }

        private SqlNode createCondition(String filterCondition, Pair<String, String> tableNameAndAliasName) throws SqlParseException {
            Preconditions.checkState((filterCondition != null && filterCondition.length() > 0 ? 1 : 0) != 0, (Object)"Filter condition can not be NULL or empty string.");
            SqlNode node = SqlParser.create((String)filterCondition).parseExpression();
            if (((String)tableNameAndAliasName.getSecond()).length() > 0) {
                AliasModifier aliasModifier = new AliasModifier((String)tableNameAndAliasName.getSecond());
                if (node instanceof SqlCall) {
                    aliasModifier.visit((SqlCall)node);
                }
            }
            return node;
        }
    }
}

