/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.relnode.OLAPTableScan;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.apache.kylin.query.util.QueryContextCutter;

public class ContextReCutStrategy
implements ICutContextStrategy {
    private ICutContextStrategy.CutContextImplementor reCutter;

    public List<OLAPRel> cutOffContext(OLAPRel rootRel, RelNode parentOfRoot) {
        for (OLAPTableScan tableScan : rootRel.getContext().allTableScans) {
            tableScan.setColumnRowType(null);
        }
        OLAPContext originCtx = rootRel.getContext();
        this.reCutter.visitChild((RelNode)rootRel);
        OLAPContext.clearThreadLocalContextById((int)originCtx.id);
        return Lists.newArrayList((Object[])new OLAPRel[]{rootRel});
    }

    public boolean needCutOff(OLAPRel rootRel) {
        return rootRel.getContext() != null && rootRel.getContext().isHasJoin();
    }

    void tryCutToSmallerContexts(RelNode root, RuntimeException e) {
        ICutContextStrategy.CutContextImplementor cutter = this.getReCutter() == null ? new ICutContextStrategy.CutContextImplementor(Objects.requireNonNull(OLAPContext.getThreadLocalContexts()).size()) : new ICutContextStrategy.CutContextImplementor(this.getReCutter().getCtxSeq());
        this.setReCutter(cutter);
        for (OLAPContext context : ContextUtil.listContextsHavingScan()) {
            if (context.isHasSelected() && context.realization == null && (!context.isHasPreCalcJoin() || context.getModelAlias() != null)) {
                throw e;
            }
            if (context.isHasSelected() && context.realization == null) {
                QueryContextCutter.cutContext(this, context.getTopNode(), root);
                ContextUtil.setSubContexts((RelNode)root.getInput(0));
                continue;
            }
            if (context.realization != null) {
                context.unfixModel();
            }
            context.clearCtxInfo();
        }
    }

    @Generated
    public ICutContextStrategy.CutContextImplementor getReCutter() {
        return this.reCutter;
    }

    @Generated
    public void setReCutter(ICutContextStrategy.CutContextImplementor reCutter) {
        this.reCutter = reCutter;
    }
}

