/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.util;

import java.util.List;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.util.HepUtils;
import org.apache.kylin.query.util.ICutContextStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextInitialCutStrategy
implements ICutContextStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ContextInitialCutStrategy.class);

    public List<OLAPRel> cutOffContext(OLAPRel rootRel, RelNode parentOfRoot) {
        KapRel.OLAPContextImplementor contextImplementor = new KapRel.OLAPContextImplementor();
        KapRel.ContextVisitorState initState = KapRel.ContextVisitorState.init();
        contextImplementor.visitChild((RelNode)rootRel, (RelNode)rootRel, initState);
        if (initState.hasFreeTable()) {
            contextImplementor.allocateContext((KapRel)rootRel, parentOfRoot);
        }
        this.toLeafJoinForm();
        ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER HEP PLANNER", (RelNode)rootRel, (Logger)log);
        contextImplementor.optimizeContextCut();
        return Lists.newArrayList((Object[])new OLAPRel[]{rootRel});
    }

    public boolean needCutOff(OLAPRel rootRel) {
        return true;
    }

    private void toLeafJoinForm() {
        for (OLAPContext context : ContextUtil.listContexts()) {
            int i;
            RelNode parentOfTopNode = context.getParentOfTopNode();
            if (parentOfTopNode == null) {
                for (i = 0; i < context.getTopNode().getInputs().size(); ++i) {
                    context.getTopNode().replaceInput(i, HepUtils.runRuleCollection(context.getTopNode().getInput(i), HepUtils.CUBOID_OPT_RULES));
                }
                ((KapRel)context.getTopNode()).setContext(context);
                continue;
            }
            for (i = 0; i < parentOfTopNode.getInputs().size(); ++i) {
                if (context.getTopNode() != parentOfTopNode.getInput(i)) continue;
                RelNode newInput = HepUtils.runRuleCollection(parentOfTopNode.getInput(i), HepUtils.CUBOID_OPT_RULES);
                ((KapRel)newInput).setContext(context);
                context.setTopNode((OLAPRel)((KapRel)newInput));
                parentOfTopNode.replaceInput(i, newInput);
            }
        }
    }
}

