/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.exec.sparder;

import java.sql.SQLException;
import java.util.List;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.ForceToTieredStorage;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.cuboid.NLayoutCandidate;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.query.engine.exec.ExecuteResult;
import org.apache.kylin.query.engine.exec.QueryPlanExec;
import org.apache.kylin.query.engine.exec.calcite.CalciteQueryPlanExec;
import org.apache.kylin.query.engine.exec.sparder.QueryEngine;
import org.apache.kylin.query.engine.meta.MutableDataContext;
import org.apache.kylin.query.engine.meta.SimpleDataContext;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapContext;
import org.apache.kylin.query.relnode.KapRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.relnode.OLAPRel;
import org.apache.kylin.query.runtime.SparkEngine;
import org.apache.kylin.query.util.QueryContextCutter;
import org.apache.spark.SparkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparderQueryPlanExec
implements QueryPlanExec {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SparderQueryPlanExec.class);

    @Override
    public List<List<String>> execute(RelNode rel, MutableDataContext dataContext) {
        return ImmutableList.copyOf((Iterable)this.executeToIterable(rel, dataContext).getRows());
    }

    @Override
    public ExecuteResult executeToIterable(RelNode rel, MutableDataContext dataContext) {
        QueryContext.currentTrace().startSpan("MODEL_MATCHING");
        ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN BEFORE (SparderQueryPlanExec) SELECT REALIZATION", (RelNode)rel, (Logger)log);
        QueryContext.current().record("end_plan");
        QueryContext.current().getQueryTagInfo().setWithoutSyntaxError(true);
        QueryContextCutter.selectRealization(rel, BackdoorToggles.getIsQueryFromAutoModeling());
        ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER (SparderQueryPlanExec) SELECT REALIZATION IS SET", (RelNode)rel, (Logger)log);
        List contexts = ContextUtil.listContexts();
        for (OLAPContext context : contexts) {
            if (!SparderQueryPlanExec.hasEmptyRealization(context)) continue;
            return new CalciteQueryPlanExec().executeToIterable(rel, dataContext);
        }
        if (!(dataContext instanceof SimpleDataContext) || !((SimpleDataContext)dataContext).isContentQuery() || KapConfig.wrap((KylinConfig)((SimpleDataContext)dataContext).getKylinConfig()).runConstantQueryLocally()) {
            for (OLAPContext context : contexts) {
                if (context.olapSchema == null || !context.storageContext.isEmptyLayout() || context.isHasAgg()) continue;
                QueryContext.fillEmptyResultSetMetrics();
                return new ExecuteResult((Iterable)Lists.newArrayList(), 0);
            }
        }
        this.rewrite(rel);
        return this.internalCompute((QueryEngine)new SparkEngine(), dataContext, rel.getInput(0));
    }

    private static boolean forceTableIndexAtException(Exception e) {
        return !QueryContext.current().isForceTableIndex() && e instanceof SparkException && !QueryContext.current().getSecondStorageUsageMap().isEmpty();
    }

    private static boolean shouldRetryOnSecondStorage(Exception e) {
        return QueryContext.current().isRetrySecondStorage() && e instanceof SparkException && !QueryContext.current().getSecondStorageUsageMap().isEmpty();
    }

    private static boolean hasEmptyRealization(OLAPContext context) {
        return context.realization == null && context.isConstantQueryWithAggregations();
    }

    protected ExecuteResult internalCompute(QueryEngine queryEngine, DataContext dataContext, RelNode rel) {
        try {
            return queryEngine.computeToIterable(dataContext, rel);
        }
        catch (Exception e) {
            Exception cause = e;
            while (SparderQueryPlanExec.shouldRetryOnSecondStorage(cause)) {
                try {
                    return queryEngine.computeToIterable(dataContext, rel);
                }
                catch (Exception retryException) {
                    if (log.isInfoEnabled()) {
                        log.info("Failed to use second storage table-index", (Throwable)e);
                    }
                    QueryContext.current().setLastFailed(true);
                    cause = retryException;
                    this.checkOnlyTsAnswer();
                }
            }
            if (SparderQueryPlanExec.forceTableIndexAtException(e)) {
                if (log.isInfoEnabled()) {
                    log.info("Failed to use second storage table-index", (Throwable)e);
                }
                QueryContext.current().setForceTableIndex(true);
                QueryContext.current().getSecondStorageUsageMap().clear();
            } else if (e instanceof SQLException) {
                this.handleForceToTieredStorage(e);
            } else {
                return (ExecuteResult)ExceptionUtils.rethrow((Throwable)e);
            }
            return queryEngine.computeToIterable(dataContext, rel);
        }
    }

    private void rewrite(RelNode rel) {
        OLAPRel.RewriteImplementor rewriteImplementor = new OLAPRel.RewriteImplementor();
        rewriteImplementor.visitChild(rel, rel.getInput(0));
        QueryContext.current().setCalcitePlan((Object)rel.copy(rel.getTraitSet(), rel.getInputs()));
        ContextUtil.dumpCalcitePlan((String)"EXECUTION PLAN AFTER REWRITE", (RelNode)rel, (Logger)log);
        QueryContext.current().getQueryTagInfo().setSparderUsed(true);
        boolean exactlyMatch = ContextUtil.listContextsHavingScan().stream().noneMatch(this::isAggImperfectMatch);
        QueryContext.current().getMetrics().setExactlyMatch(exactlyMatch);
        KapContext.setKapRel((KapRel)((KapRel)rel.getInput(0)));
        KapContext.setRowType((RelDataType)rel.getRowType());
        QueryContext.current().record("end_rewrite");
    }

    private boolean isAggImperfectMatch(OLAPContext ctx) {
        NLayoutCandidate candidate = ctx.storageContext.getCandidate();
        if (candidate == null) {
            return false;
        }
        long layoutId = candidate.getLayoutEntity().getId();
        return IndexEntity.isAggIndex((long)layoutId) && !ctx.isExactlyAggregate() || IndexEntity.isTableIndex((long)layoutId) && ctx.isHasAgg();
    }

    private void handleForceToTieredStorage(Exception e) {
        if (e.getMessage().equals("should route use forcedToTieredStorage")) {
            ForceToTieredStorage forcedToTieredStorage = QueryContext.current().getForcedToTieredStorage();
            boolean forceTableIndex = QueryContext.current().isForceTableIndex();
            QueryContext.current().setLastFailed(true);
            QueryContext.current().setRetrySecondStorage(false);
            if (forcedToTieredStorage == ForceToTieredStorage.CH_FAIL_TO_PUSH_DOWN && !forceTableIndex) {
                ExceptionUtils.rethrow((Throwable)e);
            } else {
                if (forcedToTieredStorage == ForceToTieredStorage.CH_FAIL_TO_RETURN) {
                    throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FORCED_TO_TIEREDSTORAGE_RETURN_ERROR, MsgPicker.getMsg().getForcedToTieredstorageReturnError());
                }
                if (forcedToTieredStorage == ForceToTieredStorage.CH_FAIL_TO_PUSH_DOWN) {
                    throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FORCED_TO_TIEREDSTORAGE_RETURN_ERROR, MsgPicker.getMsg().getForcedToTieredstorageAndForceToIndex());
                }
                throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FORCED_TO_TIEREDSTORAGE_INVALID_PARAMETER, MsgPicker.getMsg().getForcedToTieredstorageInvalidParameter());
            }
        }
    }

    private void checkOnlyTsAnswer() {
        if (QueryContext.current().getForcedToTieredStorage() == ForceToTieredStorage.CH_FAIL_TO_RETURN) {
            throw new KylinException((ErrorCodeSupplier)QueryErrorCode.FORCED_TO_TIEREDSTORAGE_RETURN_ERROR, MsgPicker.getMsg().getForcedToTieredstorageReturnError());
        }
    }
}

