/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine.exec.calcite;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumerableInterpretable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.tree.ClassDeclaration;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.runtime.ArrayBindable;
import org.apache.calcite.runtime.Bindable;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.query.engine.exec.QueryPlanExec;
import org.apache.kylin.query.engine.meta.MutableDataContext;

public class CalciteQueryPlanExec
implements QueryPlanExec {
    @Override
    public List<List<String>> execute(RelNode rel, MutableDataContext dataContext) {
        QueryContext.currentTrace().startSpan("EXECUTION");
        this.initContextVars(dataContext);
        List<List<String>> result = this.doExecute(rel, dataContext);
        QueryContext.fillEmptyResultSetMetrics();
        QueryContext.currentTrace().endLastSpan();
        return result;
    }

    public List<List<String>> doExecute(RelNode rel, DataContext dataContext) {
        Bindable bindable = EnumerableInterpretable.toBindable(new HashMap(), (CalcitePrepare.SparkHandler)new TrivialSparkHandler(), (EnumerableRel)((EnumerableRel)rel), (EnumerableRel.Prefer)EnumerableRel.Prefer.ARRAY);
        Enumerable rawResult = bindable.bind(dataContext);
        LinkedList<List<String>> result = new LinkedList<List<String>>();
        QueryContext.currentTrace().startSpan("FETCH_RESULT");
        for (Object rawRow : rawResult.toList()) {
            LinkedList<String> row = new LinkedList<String>();
            if (rel.getRowType().getFieldCount() > 1) {
                Object[] rowData = (Object[])rawRow;
                for (int i = 0; i < rowData.length; ++i) {
                    row.add(this.rawQueryResultToString(rowData[i], ((RelDataTypeField)rel.getRowType().getFieldList().get(i)).getType()));
                }
            } else {
                row.add(this.rawQueryResultToString(rawRow, ((RelDataTypeField)rel.getRowType().getFieldList().get(0)).getType()));
            }
            result.add(row);
        }
        return result;
    }

    private void initContextVars(MutableDataContext dataContext) {
        TimeZone timezone = (TimeZone)DataContext.Variable.TIME_ZONE.get((DataContext)dataContext);
        long time = System.currentTimeMillis();
        long localOffset = timezone.getOffset(System.currentTimeMillis());
        dataContext.putContextVar(DataContext.Variable.UTC_TIMESTAMP.camelName, time);
        dataContext.putContextVar(DataContext.Variable.CURRENT_TIMESTAMP.camelName, time + localOffset);
        dataContext.putContextVar(DataContext.Variable.LOCAL_TIMESTAMP.camelName, time + localOffset);
    }

    private String rawQueryResultToString(Object object, RelDataType dataType) {
        String value = String.valueOf(object);
        switch (dataType.getSqlTypeName()) {
            case DATE: {
                return DateFormat.formatDayToEpochToDateStr((long)Long.parseLong(value), (TimeZone)TimeZone.getTimeZone("GMT"));
            }
            case TIMESTAMP: {
                return DateFormat.castTimestampToString((long)Long.parseLong(value), (TimeZone)TimeZone.getTimeZone("GMT"));
            }
            case TIME: {
                return DateFormat.formatToTimeStr((long)Long.parseLong(value), (String)"HH:mm:ss", (TimeZone)TimeZone.getTimeZone("GMT"));
            }
        }
        return value;
    }

    private static class TrivialSparkHandler
    implements CalcitePrepare.SparkHandler {
        private TrivialSparkHandler() {
        }

        public RelNode flattenTypes(RelOptPlanner planner, RelNode rootRel, boolean restructure) {
            return rootRel;
        }

        public void registerRules(CalcitePrepare.SparkHandler.RuleSetBuilder builder) {
        }

        public boolean enabled() {
            return false;
        }

        public ArrayBindable compile(ClassDeclaration expr, String s) {
            throw new UnsupportedOperationException();
        }

        public Object sparkContext() {
            throw new UnsupportedOperationException();
        }
    }
}

