/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.impl.AggregateFunctionImpl;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.fun.udf.UdfDef;
import org.apache.calcite.sql.fun.udf.UdfEmptyImplementor;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.measure.MeasureTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDFRegistry {
    private KylinConfig kylinConfig;
    private Map<String, UDFDefinition> udfDefinitions = new HashMap<String, UDFDefinition>();
    private static final Logger logger = LoggerFactory.getLogger(UDFRegistry.class);
    static HashMultimap<String, Function> allUdfMap = UDFRegistry.genAllUdf();

    public static UDFRegistry getInstance(KylinConfig config, String project) {
        return (UDFRegistry)config.getManager(project, UDFRegistry.class);
    }

    static UDFRegistry newInstance(KylinConfig conf, String project) {
        try {
            String cls = UDFRegistry.class.getName();
            Class clz = ClassUtil.forName((String)cls, UDFRegistry.class);
            return (UDFRegistry)clz.getConstructor(KylinConfig.class, String.class).newInstance(conf, project);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init DataModelManager from " + conf, e);
        }
    }

    public UDFRegistry(KylinConfig kylinConfig, String project) {
        this.kylinConfig = kylinConfig;
        for (Map.Entry entry : KylinConfig.getInstanceFromEnv().getUDFs().entrySet()) {
            this.udfDefinitions.put((String)entry.getKey(), new UDFDefinition(((String)entry.getKey()).trim().toUpperCase(Locale.ROOT), ((String)entry.getValue()).trim()));
        }
        for (Map.Entry entry : MeasureTypeFactory.getUDAFs().entrySet()) {
            this.udfDefinitions.put((String)entry.getKey(), new UDFDefinition(((String)entry.getKey()).trim().toUpperCase(Locale.ROOT), ((Class)entry.getValue()).getName().trim(), null));
        }
    }

    public Collection<UDFDefinition> getUdfDefinitions() {
        return Collections.unmodifiableCollection(this.udfDefinitions.values());
    }

    private static HashMultimap<String, Function> genAllUdf() {
        HashMultimap allUdfMap = HashMultimap.create();
        HashMap udfDefinitions = new HashMap();
        for (Map.Entry entry : KylinConfig.getInstanceFromEnv().getUDFs().entrySet()) {
            udfDefinitions.put(entry.getKey(), new UDFDefinition(((String)entry.getKey()).trim().toUpperCase(Locale.ROOT), ((String)entry.getValue()).trim()));
        }
        for (UDFDefinition udfDef : Collections.unmodifiableCollection(udfDefinitions.values())) {
            try {
                Class<?> clazz = Class.forName(udfDef.getClassName());
                if (UdfDef.class.isAssignableFrom(clazz)) {
                    SqlOperator udfOp = (SqlOperator)clazz.getField("OPERATOR").get(null);
                    UdfEmptyImplementor udfImpl = UdfEmptyImplementor.INSTANCE;
                    udfImpl = (CallImplementor)clazz.getField("IMPLEMENTOR").get(null);
                    SqlStdOperatorTable.instance().register(udfOp);
                    RexImpTable.INSTANCE.defineImplementor(udfOp, (CallImplementor)udfImpl);
                    continue;
                }
                for (SqlOperator method : clazz.getMethods()) {
                    if (method.getDeclaringClass() == Object.class) continue;
                    ScalarFunction function = ScalarFunctionImpl.create((Method)method);
                    allUdfMap.put((Object)method.getName(), (Object)function);
                }
            }
            catch (Exception e) {
                logger.error("Register UDF {} fail", (Object)udfDef.getClassName(), (Object)e);
            }
        }
        HashMap udafDefinitions = new HashMap();
        for (Map.Entry entry : MeasureTypeFactory.getUDAFs().entrySet()) {
            udafDefinitions.put(entry.getKey(), new UDFDefinition(((String)entry.getKey()).trim().toUpperCase(Locale.ROOT), ((Class)entry.getValue()).getName().trim(), null));
        }
        for (UDFDefinition udfDef : Collections.unmodifiableCollection(udafDefinitions.values())) {
            try {
                AggregateFunctionImpl aggFunction = AggregateFunctionImpl.create(Class.forName(udfDef.getClassName()));
                allUdfMap.put((Object)udfDef.getName(), (Object)aggFunction);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("UDAF class '" + udfDef.getClassName() + "' not found");
            }
        }
        return allUdfMap;
    }

    public static class UDFDefinition {
        String name;
        String className;
        String methodName;
        List<String> paths = null;

        public UDFDefinition(String name, String className) {
            this(name, className, "*");
        }

        public UDFDefinition(String name, String className, String methodName) {
            this.name = name;
            this.className = className;
            this.methodName = methodName;
        }

        public String getName() {
            return this.name;
        }

        public String getClassName() {
            return this.className;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public List<String> getPaths() {
            return this.paths;
        }
    }
}

