/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Table;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.engine.RelColumnMetaDataExtractor;
import org.apache.kylin.query.engine.TypeSystem;
import org.apache.kylin.query.engine.data.TableSchema;

public class SchemaMetaData {
    private QueryExec queryExec;

    public SchemaMetaData(String project, KylinConfig kylinConfig) {
        this.queryExec = new QueryExec(project, kylinConfig);
    }

    public List<TableSchema> getTables() {
        return this.queryExec.getRootSchema().getSubSchemaMap().values().stream().flatMap(schema -> this.getTables((CalciteSchema)schema).stream()).collect(Collectors.toList());
    }

    private List<TableSchema> getTables(CalciteSchema schema) {
        HashMap<String, Table> tables = new HashMap<String, Table>();
        String schemaName = schema.getName() == null ? "defaultSchema" : schema.getName();
        for (String tableName2 : schema.getTableNames()) {
            tables.put(tableName2, schema.getTable(tableName2, false).getTable());
        }
        tables.putAll(schema.getTablesBasedOnNullaryFunctions());
        LinkedList<TableSchema> tableSchemas = new LinkedList<TableSchema>();
        tables.forEach((tableName, table) -> tableSchemas.add(this.convertToTableSchema("defaultCatalog", schemaName, (String)tableName, (Table)table)));
        return tableSchemas;
    }

    private TableSchema convertToTableSchema(String catalogName, String schemaName, String tableName, Table table) {
        return new TableSchema(catalogName, schemaName, tableName, table.getJdbcTableType().toString(), null, RelColumnMetaDataExtractor.getColumnMetadata((RelDataType)table.getRowType((RelDataTypeFactory)this.javaTypeFactory())));
    }

    private JavaTypeFactory javaTypeFactory() {
        new TypeSystem();
        return TypeSystem.javaTypeFactory();
    }
}

