/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.runtime.GeoFunctions;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.OracleSqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.calcite.util.Pair;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.query.engine.KECalciteConfig;
import org.apache.kylin.query.engine.TypeSystem;
import org.apache.kylin.query.engine.view.ModelViewExpander;
import org.apache.kylin.query.schema.KylinSqlValidator;

public class SQLConverter {
    private final SqlParser.Config parserConfig;
    private final SqlValidator validator;
    private final SqlOperatorTable sqlOperatorTable;
    private final SqlToRelConverter sqlToRelConverter;
    private final CalciteConnectionConfig connectionConfig;

    private SQLConverter(KECalciteConfig connectionConfig, RelOptPlanner planner, Prepare.CatalogReader catalogReader) {
        this(connectionConfig, planner, catalogReader, null);
    }

    private SQLConverter(KECalciteConfig connectionConfig, RelOptPlanner planner, Prepare.CatalogReader catalogReader, RelOptTable.ViewExpander viewExpander) {
        this.connectionConfig = connectionConfig;
        this.parserConfig = SqlParser.configBuilder().setQuotedCasing(connectionConfig.quotedCasing()).setUnquotedCasing(connectionConfig.unquotedCasing()).setQuoting(connectionConfig.quoting()).setIdentifierMaxLength(connectionConfig.getIdentifierMaxLength()).setConformance(connectionConfig.conformance()).setCaseSensitive(connectionConfig.caseSensitive()).build();
        this.sqlOperatorTable = this.createOperatorTable(connectionConfig, catalogReader);
        this.validator = this.createValidator((CalciteConnectionConfig)connectionConfig, catalogReader, this.sqlOperatorTable);
        this.sqlToRelConverter = this.createSqlToRelConverter(viewExpander, planner, this.validator, catalogReader);
    }

    public static SQLConverter createConverter(KECalciteConfig connectionConfig, RelOptPlanner planner, Prepare.CatalogReader catalogReader) {
        SQLConverter sqlConverter = new SQLConverter(connectionConfig, planner, catalogReader);
        return new SQLConverter(connectionConfig, planner, catalogReader, new ModelViewExpander(sqlConverter::convertSqlToRelNode));
    }

    public RelRoot convertSqlToRelNode(String sql) throws SqlParseException {
        SqlNode sqlNode = this.parseSQL(sql);
        QueryContext.current().record("end calcite parse sql");
        return this.convertToRelNode(sqlNode);
    }

    public CalcitePrepare.AnalyzeViewResult analyzeSQl(String sql) throws SqlParseException {
        SqlNode sqlNode = this.parseSQL(sql);
        RelRoot relRoot = this.convertToRelNode(sqlNode);
        return new CalcitePrepare.AnalyzeViewResult(null, this.validator, sql, sqlNode, relRoot.validatedRowType, relRoot, null, null, null, null, false);
    }

    private SqlValidator createValidator(CalciteConnectionConfig connectionConfig, Prepare.CatalogReader catalogReader, SqlOperatorTable sqlOperatorTable) {
        KylinSqlValidator sqlValidator = new KylinSqlValidator((SqlValidatorImpl)SqlValidatorUtil.newValidator((SqlOperatorTable)sqlOperatorTable, (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)this.javaTypeFactory(), (SqlConformance)connectionConfig.conformance()));
        sqlValidator.setIdentifierExpansion(true);
        sqlValidator.setDefaultNullCollation(connectionConfig.defaultNullCollation());
        return sqlValidator;
    }

    private SqlOperatorTable createOperatorTable(KECalciteConfig connectionConfig, Prepare.CatalogReader catalogReader) {
        LinkedHashSet<Object> tables = new LinkedHashSet<Object>();
        String[] stringArray = connectionConfig.operatorTables();
        int n = stringArray.length;
        block10: for (int i = 0; i < n; ++i) {
            String opTable;
            switch (opTable = stringArray[i]) {
                case "standard": {
                    tables.add(SqlStdOperatorTable.instance());
                    continue block10;
                }
                case "oracle": {
                    tables.add(OracleSqlOperatorTable.instance());
                    continue block10;
                }
                case "spatial": {
                    tables.add(CalciteCatalogReader.operatorTable((String)GeoFunctions.class.getName()));
                    continue block10;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Unknown operator table: '%s'. Check the kylin.query.calcite.extras-props.FUN config please", opTable));
                }
            }
        }
        tables.add(SqlStdOperatorTable.instance());
        SqlOperatorTable composedOperatorTable = ChainedSqlOperatorTable.of((SqlOperatorTable[])tables.toArray(new SqlOperatorTable[0]));
        return ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{composedOperatorTable, catalogReader});
    }

    private SqlToRelConverter createSqlToRelConverter(RelOptTable.ViewExpander viewExpander, RelOptPlanner planner, SqlValidator sqlValidator, Prepare.CatalogReader catalogReader) {
        SqlToRelConverter.Config config = SqlToRelConverter.configBuilder().withTrimUnusedFields(true).withExpand(((Boolean)Prepare.THREAD_EXPAND.get()).booleanValue()).withExplain(false).build();
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.javaTypeFactory()));
        return new SqlToRelConverter(viewExpander, sqlValidator, catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, config);
    }

    private JavaTypeFactory javaTypeFactory() {
        return TypeSystem.javaTypeFactory();
    }

    private SqlNode parseSQL(String sql) throws SqlParseException {
        return SqlParser.create((String)sql, (SqlParser.Config)this.parserConfig).parseQuery();
    }

    private RelRoot convertToRelNode(SqlNode sqlNode) {
        RelRoot root = this.sqlToRelConverter.convertQuery(sqlNode, true, true);
        if (this.connectionConfig.forceDecorrelate()) {
            root = root.withRel(this.sqlToRelConverter.decorrelate(sqlNode, root.rel));
        }
        RelNode rel = root.rel;
        if (this.connectionConfig.projectUnderRelRoot() && !root.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)root.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef(rel, field));
            }
            LogicalProject project = LogicalProject.create((RelNode)root.rel, projects, (RelDataType)root.validatedRowType);
            root = new RelRoot((RelNode)project, root.validatedRowType, root.kind, (List)root.fields, RelCollations.EMPTY);
        }
        return root;
    }
}

