/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.sql.Date;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.NewQueryRefuseException;
import org.apache.kylin.common.exception.TargetSegmentNotFoundException;
import org.apache.kylin.common.persistence.transaction.TransactionException;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.persistence.transaction.UnitOfWorkParams;
import org.apache.kylin.common.util.DBUtils;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.NativeQueryRealization;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.metadata.querymeta.SelectedColumnMeta;
import org.apache.kylin.metadata.realization.NoStreamingRealizationFoundException;
import org.apache.kylin.query.engine.PrepareSqlStateParam;
import org.apache.kylin.query.engine.QueryExec;
import org.apache.kylin.query.engine.data.QueryResult;
import org.apache.kylin.query.exception.BusyQueryException;
import org.apache.kylin.query.exception.NotSupportedSQLException;
import org.apache.kylin.query.mask.QueryResultMasks;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.util.PushDownQueryRequestLimits;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.QueryParams;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.source.adhocquery.PushdownResult;
import org.apache.spark.SparkException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRoutingEngine {
    private static final Logger logger = LoggerFactory.getLogger(QueryRoutingEngine.class);
    public static final String SPARK_MEM_LIMIT_EXCEEDED = "Container killed by YARN for exceeding memory limits";
    public static final String SPARK_JOB_FAILED = "Job aborted due to stage failure";
    private static final Pattern PTN_SUM_LC = Pattern.compile("\\s*\\bSUM_LC\\s*[(]\\s*.*\\.?.*\\s*[,]\\s*.*\\.?.*\\s*[)]\\s*", 2);

    public QueryResult queryWithSqlMassage(QueryParams queryParams) throws Exception {
        QueryContext.current().setAclInfo(queryParams.getAclInfo());
        KylinConfig projectKylinConfig = NProjectManager.getProjectConfig((String)queryParams.getProject());
        QueryExec queryExec = new QueryExec(queryParams.getProject(), projectKylinConfig, true);
        queryParams.setDefaultSchema(queryExec.getDefaultSchemaName());
        if (queryParams.isForcedToPushDown()) {
            this.checkContainsSumLC(queryParams);
            return this.pushDownQuery(null, queryParams);
        }
        try {
            QueryResult queryResult = (QueryResult)this.doTransactionEnabled(() -> {
                if (projectKylinConfig.enableReplaceDynamicParams() && queryParams.isPrepareStatementWithParams()) {
                    queryParams.setSql(queryParams.getPrepareSql());
                }
                String correctedSql = QueryUtil.massageSql((QueryParams)queryParams);
                QueryContext.current().getMetrics().setCorrectedSql(correctedSql);
                QueryContext.current().setPartialMatchIndex(queryParams.isPartialMatchIndex());
                logger.info("The corrected query: {}", (Object)correctedSql);
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("AcceptPartialResult", String.valueOf(queryParams.isAcceptPartial()));
                OLAPContext.setParameters(parameters);
                OLAPContext.clearThreadLocalContexts();
                if (!queryParams.isACLDisabledOrAdmin()) {
                    QueryResultMasks.init((String)queryParams.getProject(), (KylinConfig)NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(queryParams.getProject()).getConfig());
                }
                if (BackdoorToggles.getPrepareOnly()) {
                    return this.prepareOnly(correctedSql, queryExec, Lists.newArrayList(), Lists.newArrayList());
                }
                if (queryParams.isPrepareStatementWithParams()) {
                    for (int i = 0; i < queryParams.getParams().length; ++i) {
                        this.setParam(queryExec, i, queryParams.getParams()[i]);
                    }
                }
                return this.execute(correctedSql, queryExec);
            }, queryParams.getProject());
            return queryResult;
        }
        catch (TransactionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SQLException && cause.getCause() instanceof KylinException) {
                throw (SQLException)cause;
            }
            if (this.shouldPushdown(cause, queryParams)) {
                QueryResult queryResult = this.pushDownQuery((SQLException)cause, queryParams);
                return queryResult;
            }
            throw e;
        }
        catch (SQLException e) {
            if (e.getCause() instanceof KylinException) {
                if (this.checkIfRetryQuery(e.getCause())) {
                    NProjectLoader.removeCache();
                    QueryResult queryResult = this.queryWithSqlMassage(queryParams);
                    return queryResult;
                }
                if (e.getCause() instanceof NewQueryRefuseException && this.shouldPushdown(e, queryParams)) {
                    QueryResult queryResult = this.pushDownQuery(e, queryParams);
                    return queryResult;
                }
                throw e;
            }
            if (this.shouldPushdown(e, queryParams)) {
                QueryResult queryResult = this.pushDownQuery(e, queryParams);
                return queryResult;
            }
            throw e;
        }
        finally {
            QueryResultMasks.remove();
        }
    }

    public boolean checkIfRetryQuery(Throwable cause) {
        if (TargetSegmentNotFoundException.causedBySegmentNotFound((Throwable)cause) && QueryContext.current().getMetrics().getRetryTimes() == 0) {
            logger.info("Retry current query, retry times:{}, cause:{}", (Object)QueryContext.current().getMetrics().getRetryTimes(), (Object)cause.getMessage());
            QueryContext.current().getMetrics().addRetryTimes();
            return true;
        }
        return false;
    }

    private void checkContainsSumLC(QueryParams queryParams) {
        if (PTN_SUM_LC.matcher(queryParams.getSql()).find()) {
            String message = "sum_lc() function now is not supported by other query engine";
            throw new NotSupportedSQLException(message);
        }
    }

    protected boolean shouldPushdown(Throwable e, QueryParams queryParams) {
        if (queryParams.isForcedToIndex()) {
            return false;
        }
        if (e.getCause() instanceof NoStreamingRealizationFoundException) {
            return false;
        }
        if (e.getCause() instanceof SparkException && e.getCause().getMessage().contains(SPARK_JOB_FAILED)) {
            return false;
        }
        if (e.getCause() instanceof NewQueryRefuseException) {
            return this.checkBigQueryPushDown(queryParams);
        }
        if (PTN_SUM_LC.matcher(queryParams.getSql()).find()) {
            return false;
        }
        return e instanceof SQLException && !e.getMessage().contains(SPARK_MEM_LIMIT_EXCEEDED);
    }

    private <T> T doTransactionEnabled(UnitOfWork.Callback<T> f, String project) throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        if (kylinConfig.isTransactionEnabledInQuery()) {
            return (T)UnitOfWork.doInTransactionWithRetry((UnitOfWorkParams)UnitOfWorkParams.builder().unitName(project).readonly(true).processor(f).build());
        }
        return (T)f.process();
    }

    @VisibleForTesting
    public QueryResult execute(String correctedSql, QueryExec queryExec) throws Exception {
        QueryResult queryResult = queryExec.executeQuery(correctedSql);
        ArrayList nativeQueryRealizationList = Lists.newArrayList();
        for (NativeQueryRealization nqReal : OLAPContext.getNativeRealizations()) {
            nativeQueryRealizationList.add(new QueryContext.NativeQueryRealization(nqReal.getModelId(), nqReal.getModelAlias(), nqReal.getLayoutId(), nqReal.getIndexType(), nqReal.isPartialMatchModel(), nqReal.isValid(), nqReal.isLayoutExist(), nqReal.isStreamingLayout(), nqReal.getSnapshots()));
        }
        QueryContext.current().setNativeQueryRealizationList((List)nativeQueryRealizationList);
        return queryResult;
    }

    private boolean checkBigQueryPushDown(QueryParams queryParams) {
        KylinConfigExt kylinConfig = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(queryParams.getProject()).getConfig();
        boolean isPush = QueryUtil.isBigQueryPushDownCapable((KylinConfig)kylinConfig);
        if (isPush) {
            logger.info("Big query route to pushdown.");
        }
        return isPush;
    }

    private QueryResult pushDownQuery(SQLException sqlException, QueryParams queryParams) throws SQLException {
        QueryContext.current().getMetrics().setOlapCause((Throwable)sqlException);
        QueryContext.current().getQueryTagInfo().setPushdown(true);
        PushdownResult result = null;
        try {
            result = this.tryPushDownSelectQuery(queryParams, sqlException, BackdoorToggles.getPrepareOnly());
        }
        catch (KylinException e) {
            logger.error("Pushdown failed with kylin exception ", (Throwable)e);
            throw e;
        }
        catch (Exception e2) {
            logger.error("Pushdown engine failed current query too", (Throwable)e2);
            throw new RuntimeException("[" + QueryContext.current().getPushdownEngine() + " Exception] " + e2.getMessage());
        }
        if (result == null) {
            throw sqlException;
        }
        return new QueryResult(result.getRows(), result.getSize(), null, result.getColumnMetas());
    }

    public PushdownResult tryPushDownSelectQuery(QueryParams queryParams, SQLException sqlException, boolean isPrepare) throws Exception {
        QueryContext.currentTrace().startSpan("SQL_PUSHDOWN_TRANSFORMATION");
        Semaphore semaphore = PushDownQueryRequestLimits.getSingletonInstance();
        logger.info("Query: {} Before the current push down counter {}.", (Object)QueryContext.current().getQueryId(), (Object)semaphore.availablePermits());
        boolean acquired = false;
        boolean asyncQuery = QueryContext.current().getQueryTagInfo().isAsyncQuery();
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)queryParams.getProject());
        try {
            int queryTimeout = KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds();
            if (!asyncQuery && projectConfig.isPushDownEnabled()) {
                acquired = semaphore.tryAcquire(queryTimeout, TimeUnit.SECONDS);
                if (!acquired) {
                    logger.info("query: {} failed to get acquire.", (Object)QueryContext.current().getQueryId());
                    throw new BusyQueryException("Query rejected. Caused by PushDown query server is too busy.");
                }
                logger.info("query: {} success to get acquire.", (Object)QueryContext.current().getQueryId());
            }
            String sqlString = queryParams.getSql();
            if (this.isPrepareStatementWithParams(queryParams)) {
                sqlString = queryParams.getPrepareSql();
            }
            if (BackdoorToggles.getPrepareOnly()) {
                sqlString = QueryUtil.addLimit((String)sqlString);
            }
            String massagedSql = QueryUtil.appendLimitOffset((String)queryParams.getProject(), (String)sqlString, (int)queryParams.getLimit(), (int)queryParams.getOffset());
            if (this.isPrepareStatementWithParams(queryParams)) {
                QueryContext.current().getMetrics().setCorrectedSql(massagedSql);
            }
            queryParams.setSql(massagedSql);
            queryParams.setSqlException(sqlException);
            queryParams.setPrepare(isPrepare);
            PushdownResult pushdownResult = PushDownUtil.tryIterQuery((QueryParams)queryParams);
            return pushdownResult;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted sql push down at the stage of QueryRoutingEngine", (String)"Current step: try push down select query");
            throw e;
        }
        finally {
            if (acquired) {
                semaphore.release();
                logger.info("Query: {} success to release acquire", (Object)QueryContext.current().getQueryId());
            }
            logger.info("Query: {} After the current push down counter {}.", (Object)QueryContext.current().getQueryId(), (Object)semaphore.availablePermits());
        }
    }

    private boolean isPrepareStatementWithParams(QueryParams queryParams) {
        KylinConfig projectConfig = NProjectManager.getProjectConfig((String)queryParams.getProject());
        return (KapConfig.getInstanceFromEnv().enablePushdownPrepareStatementWithParams() || projectConfig.enableReplaceDynamicParams()) && queryParams.isPrepareStatementWithParams();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult prepareOnly(String correctedSql, QueryExec queryExec, List<List<String>> results, List<SelectedColumnMeta> columnMetas) throws SQLException {
        CalcitePrepareImpl.KYLIN_ONLY_PREPARE.set(true);
        Statement preparedStatement = null;
        try {
            List<StructField> fields = queryExec.getColumnMetaData(correctedSql);
            for (int i = 0; i < fields.size(); ++i) {
                StructField field = fields.get(i);
                String columnName = field.getName();
                if (columnName.startsWith("_KY_")) continue;
                columnMetas.add(new SelectedColumnMeta(false, false, false, false, field.isNullable() ? 1 : 0, true, field.getPrecision(), columnName, columnName, null, null, null, field.getPrecision(), Math.max(field.getScale(), 0), field.getDataType(), field.getDataTypeName(), true, false, false));
            }
            QueryResult queryResult = new QueryResult(new LinkedList(), 0, fields, columnMetas);
            return queryResult;
        }
        finally {
            CalcitePrepareImpl.KYLIN_ONLY_PREPARE.set(false);
            DBUtils.closeQuietly(preparedStatement);
        }
    }

    private void setParam(QueryExec queryExec, int index, PrepareSqlStateParam param) {
        Class<?> clazz;
        boolean isNull = null == param.getValue();
        try {
            clazz = Class.forName(param.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(clazz);
        switch (rep) {
            case PRIMITIVE_CHAR: 
            case CHARACTER: 
            case STRING: {
                queryExec.setPrepareParam(index, isNull ? null : String.valueOf(param.getValue()));
                break;
            }
            case PRIMITIVE_INT: 
            case INTEGER: {
                queryExec.setPrepareParam(index, isNull ? 0 : Integer.parseInt(param.getValue()));
                break;
            }
            case PRIMITIVE_SHORT: 
            case SHORT: {
                queryExec.setPrepareParam(index, isNull ? (short)0 : Short.parseShort(param.getValue()));
                break;
            }
            case PRIMITIVE_LONG: 
            case LONG: {
                queryExec.setPrepareParam(index, isNull ? 0L : Long.parseLong(param.getValue()));
                break;
            }
            case PRIMITIVE_FLOAT: 
            case FLOAT: {
                queryExec.setPrepareParam(index, Float.valueOf(isNull ? 0.0f : Float.parseFloat(param.getValue())));
                break;
            }
            case PRIMITIVE_DOUBLE: 
            case DOUBLE: {
                queryExec.setPrepareParam(index, isNull ? 0.0 : Double.parseDouble(param.getValue()));
                break;
            }
            case PRIMITIVE_BOOLEAN: 
            case BOOLEAN: {
                queryExec.setPrepareParam(index, !isNull && Boolean.parseBoolean(param.getValue()));
                break;
            }
            case PRIMITIVE_BYTE: 
            case BYTE: {
                queryExec.setPrepareParam(index, isNull ? (byte)0 : Byte.parseByte(param.getValue()));
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_DATE: {
                queryExec.setPrepareParam(index, isNull ? null : Date.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIME: {
                queryExec.setPrepareParam(index, isNull ? null : Time.valueOf(param.getValue()));
                break;
            }
            case JAVA_SQL_TIMESTAMP: {
                queryExec.setPrepareParam(index, isNull ? null : Timestamp.valueOf(param.getValue()));
                break;
            }
            default: {
                queryExec.setPrepareParam(index, isNull ? null : param.getValue());
            }
        }
    }
}

