/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import io.kyligence.kap.query.optrule.KapProjectJoinTransposeRule;
import java.util.LinkedList;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;

public class QueryOptimizer {
    private final RelOptPlanner planner;

    public QueryOptimizer(RelOptPlanner planner) {
        this.planner = planner;
    }

    public RelRoot optimize(RelRoot relRoot) {
        RelVisitor visitor = new RelVisitor(){

            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof TableScan) {
                    RelOptCluster cluster = node.getCluster();
                    RelOptTable.ToRelContext context = RelOptUtil.getContext((RelOptCluster)cluster);
                    RelNode r = node.getTable().toRel(context);
                    QueryOptimizer.this.planner.registerClass(r);
                }
                if (node instanceof Union) {
                    QueryOptimizer.this.planner.removeRule((RelOptRule)KapProjectJoinTransposeRule.INSTANCE);
                }
                super.visit(node, ordinal, parent);
            }
        };
        visitor.go(relRoot.rel);
        Program program = Programs.standard();
        return relRoot.withRel(program.run(this.planner, relRoot.rel, this.getDesiredRootTraitSet(relRoot), new LinkedList(), new LinkedList()));
    }

    private RelTraitSet getDesiredRootTraitSet(RelRoot root) {
        return root.rel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
    }
}

