/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.calcite.DataContext;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.ReadFsSwitch;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.query.StructField;
import org.apache.kylin.metadata.realization.NoRealizationFoundException;
import org.apache.kylin.query.calcite.KylinRelDataTypeSystem;
import org.apache.kylin.query.engine.KECalciteConfig;
import org.apache.kylin.query.engine.PlannerFactory;
import org.apache.kylin.query.engine.ProjectSchemaFactory;
import org.apache.kylin.query.engine.QueryOptimizer;
import org.apache.kylin.query.engine.RelColumnMetaDataExtractor;
import org.apache.kylin.query.engine.SQLConverter;
import org.apache.kylin.query.engine.TypeSystem;
import org.apache.kylin.query.engine.data.QueryResult;
import org.apache.kylin.query.engine.exec.ExecuteResult;
import org.apache.kylin.query.engine.exec.calcite.CalciteQueryPlanExec;
import org.apache.kylin.query.engine.exec.sparder.SparderQueryPlanExec;
import org.apache.kylin.query.engine.meta.SimpleDataContext;
import org.apache.kylin.query.engine.view.ViewAnalyzer;
import org.apache.kylin.query.mask.QueryResultMasks;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.OLAPContext;
import org.apache.kylin.query.util.AsyncQueryUtil;
import org.apache.kylin.query.util.CalcitePlanRouterVisitor;
import org.apache.kylin.query.util.HepUtils;
import org.apache.kylin.query.util.QueryContextCutter;
import org.apache.kylin.query.util.QueryInterruptChecker;
import org.apache.kylin.query.util.QueryUtil;
import org.apache.kylin.query.util.RelAggPushDownUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryExec {
    private static final Logger logger = LoggerFactory.getLogger(QueryExec.class);
    private static final int MAX_TRY_TIMES_OPTIMIZED = 10;
    private String sparderQueryOptimizedExceptionMsg = "";
    private final KylinConfig kylinConfig;
    private final KECalciteConfig config;
    private final RelOptPlanner planner;
    private final ProjectSchemaFactory schemaFactory;
    private final Prepare.CatalogReader catalogReader;
    private final SQLConverter sqlConverter;
    private final QueryOptimizer queryOptimizer;
    private final SimpleDataContext dataContext;
    private final boolean allowAlternativeQueryPlan;
    private final CalciteSchema rootSchema;

    public QueryExec(String project, KylinConfig kylinConfig, boolean allowAlternativeQueryPlan) {
        this.kylinConfig = kylinConfig;
        this.config = KECalciteConfig.fromKapConfig((KylinConfig)kylinConfig);
        this.schemaFactory = new ProjectSchemaFactory(project, kylinConfig);
        this.rootSchema = this.schemaFactory.createProjectRootSchema();
        String defaultSchemaName = this.schemaFactory.getDefaultSchema();
        this.catalogReader = this.createCatalogReader((CalciteConnectionConfig)this.config, this.rootSchema, defaultSchemaName);
        this.planner = new PlannerFactory(kylinConfig).createVolcanoPlanner((CalciteConnectionConfig)this.config);
        this.sqlConverter = SQLConverter.createConverter(this.config, this.planner, this.catalogReader);
        this.dataContext = this.createDataContext(this.rootSchema);
        this.planner.setExecutor((RexExecutor)new RexExecutorImpl((DataContext)this.dataContext));
        this.queryOptimizer = new QueryOptimizer(this.planner);
        this.allowAlternativeQueryPlan = allowAlternativeQueryPlan;
        if (kylinConfig.getAutoModelViewEnabled()) {
            this.schemaFactory.addModelViewSchemas(this.rootSchema, new SimpleViewAnalyzer(this.rootSchema, defaultSchemaName));
        }
    }

    public QueryExec(String project, KylinConfig kylinConfig) {
        this(project, kylinConfig, false);
    }

    public void plannerRemoveRules(List<RelOptRule> rules) {
        for (RelOptRule rule : rules) {
            this.planner.removeRule(rule);
        }
    }

    public void plannerAddRules(List<RelOptRule> rules) {
        for (RelOptRule rule : rules) {
            this.planner.addRule(rule);
        }
    }

    public QueryResult executeQuery(String sql) throws SQLException {
        this.magicDirts(sql);
        QueryContext queryContext = QueryContext.current();
        try {
            this.beforeQuery();
            QueryContext.currentTrace().startSpan("SQL_PARSE_AND_OPTIMIZE");
            RelRoot relRoot = this.sqlConverter.convertSqlToRelNode(sql);
            queryContext.record("end_convert_to_relnode");
            RelNode node = this.queryOptimizer.optimize((RelRoot)relRoot).rel;
            queryContext.record("end_calcite_optimize");
            List resultFields = RelColumnMetaDataExtractor.getColumnMetadata((RelDataType)relRoot.validatedRowType);
            if (resultFields.isEmpty()) {
                QueryContext.fillEmptyResultSetMetrics();
                QueryResult queryResult = new QueryResult();
                return queryResult;
            }
            if (this.kylinConfig.getEmptyResultForSelectStar() && QueryUtil.isSelectStarStatement((String)sql) && !QueryContext.current().getQueryTagInfo().isAsyncQuery()) {
                QueryResult queryResult = new QueryResult((Iterable)Lists.newArrayList(), 0, resultFields);
                return queryResult;
            }
            List columnNames = resultFields.stream().map(StructField::getName).collect(Collectors.toList());
            QueryContext.current().setColumnNames(columnNames);
            QueryResultMasks.setRootRelNode((RelNode)node);
            QueryResult queryResult = new QueryResult(this.executeQueryPlan(this.postOptimize(node)), resultFields);
            if (queryContext.getQueryTagInfo().isAsyncQuery()) {
                AsyncQueryUtil.saveMetaDataAndFileInfo((QueryContext)queryContext, (List)queryResult.getColumnMetas());
            }
            QueryResult queryResult2 = queryResult;
            return queryResult2;
        }
        catch (SqlParseException e) {
            throw this.newSqlException(sql, "parse failed: " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (ReadFsSwitch.turnOnSwitcherIfBackupFsAllowed((Throwable)e, (String)KapConfig.wrap((KylinConfig)this.kylinConfig).getSwitchBackupFsExceptionAllowString())) {
                logger.info("Retry sql after hitting allowed exception and turn on backup read FS", (Throwable)e);
                QueryResult queryResult = this.executeQuery(sql);
                return queryResult;
            }
            throw this.newSqlException(sql, e.getMessage(), e);
        }
        finally {
            this.afterQuery();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OLAPContext> deriveOlapContexts(String sql) {
        ArrayList contexts = Lists.newArrayList();
        try {
            OLAPContext.clearThreadLocalContexts();
            RelNode relNode = this.parseAndOptimize(sql);
            QueryContextCutter.analyzeOlapContext(relNode);
            Collection tmp = OLAPContext.getThreadLocalContexts();
            if (CollectionUtils.isNotEmpty((Collection)tmp)) {
                contexts.addAll(tmp);
            }
        }
        catch (Exception e) {
            logger.error("Sql Parsing error.", (Throwable)e);
        }
        finally {
            OLAPContext.clearThreadLocalContexts();
        }
        return contexts;
    }

    private void magicDirts(String sql) {
        if (sql.contains("ReadFsSwitch.turnOnBackupFsWhile")) {
            ReadFsSwitch.turnOnBackupFsWhile();
        }
    }

    @VisibleForTesting
    public RelNode parseAndOptimize(String sql) throws SqlParseException {
        this.beforeQuery();
        RelRoot relRoot = this.sqlConverter.convertSqlToRelNode(sql);
        return this.queryOptimizer.optimize((RelRoot)relRoot).rel;
    }

    public List<RelNode> postOptimize(RelNode node) {
        LinkedHashSet<RelOptRule> postOptRules = new LinkedHashSet<RelOptRule>();
        if (this.kylinConfig.isConvertSumExpressionEnabled()) {
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.SumExprRules);
        }
        if (this.kylinConfig.isConvertCountDistinctExpressionEnabled()) {
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.CountDistinctExprRules);
        }
        if (this.kylinConfig.isAggregatePushdownEnabled()) {
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.AggPushDownRules);
        }
        if (this.kylinConfig.isOptimizedSumCastDoubleRuleEnabled()) {
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.SumCastDoubleRules);
        }
        if (this.kylinConfig.isQueryFilterReductionEnabled()) {
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.FilterReductionRules);
        }
        if (!postOptRules.isEmpty()) {
            RelNode transformed = HepUtils.runRuleCollection(node, postOptRules, false);
            if (transformed != node && this.allowAlternativeQueryPlan) {
                return Lists.newArrayList((Object[])new RelNode[]{transformed, node});
            }
            return Lists.newArrayList((Object[])new RelNode[]{transformed});
        }
        return Lists.newArrayList((Object[])new RelNode[]{node});
    }

    @VisibleForTesting
    public RelRoot sqlToRelRoot(String sql) throws SqlParseException {
        return this.sqlConverter.convertSqlToRelNode(sql);
    }

    @VisibleForTesting
    public RelRoot optimize(RelRoot relRoot) {
        return this.queryOptimizer.optimize(relRoot);
    }

    public List<StructField> getColumnMetaData(String sql) throws SQLException {
        try {
            this.beforeQuery();
            RelRoot relRoot = this.sqlConverter.convertSqlToRelNode(sql);
            List list = RelColumnMetaDataExtractor.getColumnMetadata((RelDataType)relRoot.validatedRowType);
            return list;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            this.afterQuery();
        }
    }

    @VisibleForTesting
    public <T> T wrapSqlTest(Function<QueryExec, T> testFunc) {
        try {
            this.beforeQuery();
            T t = testFunc.apply(this);
            return t;
        }
        finally {
            this.afterQuery();
        }
    }

    private void beforeQuery() {
        Prepare.CatalogReader.THREAD_LOCAL.set(this.catalogReader);
        KECalciteConfig.THREAD_LOCAL.set(this.config);
    }

    private void afterQuery() {
        Prepare.CatalogReader.THREAD_LOCAL.remove();
        KECalciteConfig.THREAD_LOCAL.remove();
    }

    public void setContextVar(String name, Object val) {
        this.dataContext.putContextVar(name, val);
    }

    public void setPrepareParam(int idx, Object val) {
        this.dataContext.setPrepareParam(idx, val);
    }

    public String getDefaultSchemaName() {
        return this.schemaFactory.getDefaultSchema();
    }

    public CalciteSchema getRootSchema() {
        return this.rootSchema;
    }

    private ExecuteResult executeQueryPlan(List<RelNode> rels) {
        boolean routeToCalcite = this.routeToCalciteEngine(rels.get(0));
        this.dataContext.setContentQuery(routeToCalcite);
        if (!QueryContext.current().getQueryTagInfo().isAsyncQuery() && KapConfig.wrap((KylinConfig)this.kylinConfig).runConstantQueryLocally() && routeToCalcite) {
            QueryContext.current().getQueryTagInfo().setConstantQuery(true);
            return new CalciteQueryPlanExec().executeToIterable(rels.get(0), this.dataContext);
        }
        return this.sparderQuery(rels);
    }

    private ExecuteResult sparderQuery(List<RelNode> rels) {
        Throwable lastException = null;
        for (RelNode rel : rels) {
            try {
                OLAPContext.clearThreadLocalContexts();
                OLAPContext.clearParameter();
                return new SparderQueryPlanExec().executeToIterable(rel, this.dataContext);
            }
            catch (NoRealizationFoundException e) {
                ExecuteResult result = this.tryEnhancedAggPushDown(rel);
                if (result != null) {
                    return result;
                }
                lastException = e;
            }
            catch (IllegalArgumentException e) {
                if (e.getMessage().contains("Unsupported function name BITMAP_UUID")) {
                    if (rels.size() > 1) {
                        logger.error("Optimized relNode query fail, try origin relNode.", (Throwable)e);
                    }
                    lastException = e;
                    continue;
                }
                throw e;
            }
        }
        assert (lastException != null);
        throw lastException;
    }

    private ExecuteResult tryEnhancedAggPushDown(RelNode rel) {
        String project = QueryContext.current().getProject();
        if (project != null && NProjectManager.getProjectConfig((String)project).isEnhancedAggPushDownEnabled()) {
            LinkedHashSet<RelOptRule> postOptRules = new LinkedHashSet<RelOptRule>();
            postOptRules.addAll((Collection<RelOptRule>)HepUtils.AggPushDownRules);
            return this.sparderQueryOptimized(rel, 1, postOptRules);
        }
        return null;
    }

    private ExecuteResult sparderQueryOptimized(RelNode relNode, int tryTimes, Collection<RelOptRule> postOptRules) {
        if (QueryContext.current().getUnmatchedJoinDigest().isEmpty() || tryTimes > 10) {
            return null;
        }
        if (!QueryContext.current().isEnhancedAggPushDown() && tryTimes > 1) {
            return null;
        }
        OLAPContext.clearThreadLocalContexts();
        OLAPContext.clearParameter();
        RelAggPushDownUtil.clearCtxRelNode((RelNode)relNode);
        QueryContext.current().setEnhancedAggPushDown(false);
        RelNode transformed = HepUtils.runRuleCollection(relNode, postOptRules, false);
        ContextUtil.dumpCalcitePlan((String)("EXECUTION PLAN AFTER TABLEINDEX JOIN SNAPSHOT AGG PUSH DOWN tryTimes: " + tryTimes), (RelNode)transformed, (Logger)logger);
        try {
            RelAggPushDownUtil.clearUnmatchedJoinDigest();
            return new SparderQueryPlanExec().executeToIterable(transformed, this.dataContext);
        }
        catch (NoRealizationFoundException e) {
            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted SparderQueryOptimized NoRealizationFoundException", (String)"Current step: TableIndex join snapshot aggPushDown");
            return this.sparderQueryOptimized(transformed, ++tryTimes, postOptRules);
        }
        catch (Exception e) {
            QueryInterruptChecker.checkThreadInterrupted((String)"Interrupted SparderQueryOptimized error", (String)"Current step: Table Index join snapshot aggPushDown");
            this.setSparderQueryOptimizedExceptionMsg(e.getMessage());
            return null;
        }
    }

    private Prepare.CatalogReader createCatalogReader(CalciteConnectionConfig connectionConfig, CalciteSchema rootSchema, String defaultSchemaName) {
        KylinRelDataTypeSystem relTypeSystem = new KylinRelDataTypeSystem();
        JavaTypeFactoryImpl javaTypeFactory = new JavaTypeFactoryImpl((RelDataTypeSystem)relTypeSystem);
        return new CalciteCatalogReader(rootSchema, Collections.singletonList(defaultSchemaName), (RelDataTypeFactory)javaTypeFactory, connectionConfig);
    }

    private SimpleDataContext createDataContext(CalciteSchema rootSchema) {
        return new SimpleDataContext(rootSchema.plus(), TypeSystem.javaTypeFactory(), this.kylinConfig);
    }

    private boolean routeToCalciteEngine(RelNode rel) {
        return this.isConstantQuery(rel) && this.isCalciteEngineCapable(rel);
    }

    private boolean isConstantQuery(RelNode rel) {
        if (TableScan.class.isAssignableFrom(rel.getClass())) {
            return false;
        }
        for (RelNode input : rel.getInputs()) {
            if (this.isConstantQuery(input)) continue;
            return false;
        }
        return true;
    }

    private boolean isCalciteEngineCapable(RelNode rel) {
        Project projectRelNode;
        if (rel instanceof Project && (projectRelNode = (Project)rel).getChildExps().stream().filter(pRelNode -> pRelNode instanceof RexCall).anyMatch(pRelNode -> (Boolean)pRelNode.accept((RexVisitor)new CalcitePlanRouterVisitor()))) {
            return false;
        }
        if (rel instanceof KapAggregateRel) {
            KapAggregateRel aggregateRel = (KapAggregateRel)rel;
            if (aggregateRel.getAggCallList().stream().anyMatch(aggCall -> "BITMAP_BUILD".equalsIgnoreCase(aggCall.getAggregation().getName()))) {
                return false;
            }
            if (aggregateRel.getInput() instanceof Values && aggregateRel.getAggCallList().stream().anyMatch(AggregateCall::isDistinct)) {
                return false;
            }
        }
        return rel.getInputs().stream().allMatch(this::isCalciteEngineCapable);
    }

    private SQLException newSqlException(String sql, String msg, Throwable e) {
        return new SQLException("Error while executing SQL \"" + sql + "\": " + msg, e);
    }

    @Generated
    public void setSparderQueryOptimizedExceptionMsg(String sparderQueryOptimizedExceptionMsg) {
        this.sparderQueryOptimizedExceptionMsg = sparderQueryOptimizedExceptionMsg;
    }

    @Generated
    public String getSparderQueryOptimizedExceptionMsg() {
        return this.sparderQueryOptimizedExceptionMsg;
    }

    public class SimpleViewAnalyzer
    implements ViewAnalyzer {
        private final CalciteSchema rootSchema;
        private final String defaultSchemaName;

        public SimpleViewAnalyzer(CalciteSchema rootSchema, String defaultSchemaName) {
            this.rootSchema = rootSchema;
            this.defaultSchemaName = defaultSchemaName;
        }

        @Override
        public CalcitePrepare.AnalyzeViewResult analyzeView(String sql) throws SqlParseException {
            Prepare.CatalogReader viewCatalogReader = QueryExec.this.createCatalogReader((CalciteConnectionConfig)QueryExec.this.config, this.rootSchema, this.defaultSchemaName);
            VolcanoPlanner viewPlanner = new PlannerFactory(QueryExec.this.kylinConfig).createVolcanoPlanner((CalciteConnectionConfig)QueryExec.this.config);
            SQLConverter viewSqlConverter = SQLConverter.createConverter(QueryExec.this.config, (RelOptPlanner)viewPlanner, viewCatalogReader);
            SimpleDataContext viewDataContext = QueryExec.this.createDataContext(this.rootSchema);
            viewPlanner.setExecutor((RexExecutor)new RexExecutorImpl((DataContext)viewDataContext));
            return viewSqlConverter.analyzeSQl(sql);
        }
    }
}

