/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.QueryExtension;
import org.apache.kylin.query.engine.UDFRegistry;
import org.apache.kylin.query.engine.view.ViewAnalyzer;
import org.apache.kylin.query.engine.view.ViewSchema;
import org.apache.kylin.query.schema.KapOLAPSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ProjectSchemaFactory {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectSchemaFactory.class);
    private final String projectName;
    private final KylinConfig kylinConfig;
    private final Map<String, List<TableDesc>> schemasMap;
    private final Map<String, List<NDataModel>> modelsMap;
    private final String defaultSchemaName;

    ProjectSchemaFactory(String projectName, KylinConfig kylinConfig) {
        this.projectName = projectName;
        this.kylinConfig = kylinConfig;
        NProjectManager npr = NProjectManager.getInstance((KylinConfig)kylinConfig);
        QueryContext.AclInfo aclInfo = QueryContext.current().getAclInfo();
        String user = Objects.nonNull(aclInfo) ? aclInfo.getUsername() : null;
        Set groups = Objects.nonNull(aclInfo) ? aclInfo.getGroups() : null;
        this.schemasMap = QueryExtension.getFactory().getSchemaMapExtension().getAuthorizedTablesAndColumns(kylinConfig, projectName, this.aclDisabledOrIsAdmin(aclInfo), user, groups);
        this.removeStreamingTables(this.schemasMap, kylinConfig.streamingEnabled());
        this.modelsMap = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)projectName).getModelsGroupbyTable();
        String majoritySchemaName = npr.getDefaultDatabase(projectName);
        if (Objects.isNull(majoritySchemaName)) {
            majoritySchemaName = DatabaseDesc.getDefaultDatabaseByMaxTables(this.schemasMap);
        }
        this.defaultSchemaName = majoritySchemaName;
    }

    private void removeStreamingTables(Map<String, List<TableDesc>> schemasMap, boolean streamingEnabled) {
        schemasMap.values().forEach(tableDescList -> tableDescList.removeIf(table -> !table.isAccessible(streamingEnabled)));
        schemasMap.keySet().removeIf(key -> CollectionUtils.isEmpty((Collection)((Collection)schemasMap.get(key))));
    }

    private boolean aclDisabledOrIsAdmin(QueryContext.AclInfo aclInfo) {
        return !this.kylinConfig.isAclTCREnabled() || Objects.nonNull(aclInfo) && CollectionUtils.isNotEmpty((Collection)aclInfo.getGroups()) && aclInfo.getGroups().stream().anyMatch("ROLE_ADMIN"::equals) || Objects.nonNull(aclInfo) && aclInfo.isHasAdminPermission();
    }

    public CalciteSchema createProjectRootSchema() {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        this.addProjectSchemas(rootSchema);
        return rootSchema;
    }

    public String getDefaultSchema() {
        return this.defaultSchemaName;
    }

    private void addProjectSchemas(CalciteSchema parentSchema) {
        for (String schemaName : this.schemasMap.keySet()) {
            CalciteSchema added = parentSchema.add(schemaName, this.createSchema(schemaName));
            this.addUDFs(added);
        }
    }

    public void addModelViewSchemas(CalciteSchema parentSchema, ViewAnalyzer viewAnalyzer) {
        String viewSchemaName = this.projectName;
        ViewSchema viewSchema = new ViewSchema(viewSchemaName, viewAnalyzer);
        CalciteSchema schema = this.getOrCreateViewSchema(parentSchema, viewSchema);
        SchemaPlus plus = schema.plus();
        List models = NDataflowManager.getInstance((KylinConfig)this.kylinConfig, (String)this.projectName).listOnlineDataModels();
        for (NDataModel model : models) {
            if (schema.getTable(model.getAlias(), false) == null) {
                viewSchema.addModel(plus, model);
                continue;
            }
            log.warn("Auto model view creation for {}.{} failed, name collision with source tables", (Object)viewSchemaName, (Object)viewSchemaName);
        }
    }

    private CalciteSchema getOrCreateViewSchema(CalciteSchema parentSchema, ViewSchema viewSchema) {
        String schemaName = viewSchema.getSchemaName();
        CalciteSchema existingSchema = parentSchema.getSubSchema(schemaName, false);
        if (existingSchema != null) {
            return existingSchema;
        }
        CalciteSchema addedViewSchema = parentSchema.add(schemaName, (Schema)viewSchema);
        this.addUDFs(addedViewSchema);
        return addedViewSchema;
    }

    private Schema createSchema(String schemaName) {
        return new KapOLAPSchema(this.projectName, schemaName, this.schemasMap.get(schemaName), this.modelsMap);
    }

    private void addUDFs(CalciteSchema calciteSchema) {
        for (Map.Entry entry : UDFRegistry.allUdfMap.entries()) {
            calciteSchema.plus().add(((String)entry.getKey()).toUpperCase(Locale.ROOT), (Function)entry.getValue());
        }
    }
}

