/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import io.kyligence.kap.query.optrule.AggregateMultipleExpandRule;
import io.kyligence.kap.query.optrule.AggregateProjectReduceRule;
import io.kyligence.kap.query.optrule.CorrReduceFunctionRule;
import io.kyligence.kap.query.optrule.KAPValuesRule;
import io.kyligence.kap.query.optrule.KapAggregateReduceFunctionsRule;
import io.kyligence.kap.query.optrule.KapAggregateRule;
import io.kyligence.kap.query.optrule.KapFilterJoinRule;
import io.kyligence.kap.query.optrule.KapFilterRule;
import io.kyligence.kap.query.optrule.KapJoinRule;
import io.kyligence.kap.query.optrule.KapLimitRule;
import io.kyligence.kap.query.optrule.KapMinusRule;
import io.kyligence.kap.query.optrule.KapModelViewRule;
import io.kyligence.kap.query.optrule.KapOLAPToEnumerableConverterRule;
import io.kyligence.kap.query.optrule.KapProjectJoinTransposeRule;
import io.kyligence.kap.query.optrule.KapProjectMergeRule;
import io.kyligence.kap.query.optrule.KapProjectRule;
import io.kyligence.kap.query.optrule.KapSortRule;
import io.kyligence.kap.query.optrule.KapUnionRule;
import io.kyligence.kap.query.optrule.KapWindowRule;
import io.kyligence.kap.query.optrule.RightJoinToLeftJoinRule;
import io.kyligence.kap.query.optrule.SumConstantConvertRule;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.adapter.enumerable.EnumerableInterpreterRule;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.volcano.AbstractConverter;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateProjectMergeRule;
import org.apache.calcite.rel.rules.AggregateStarTableRule;
import org.apache.calcite.rel.rules.AggregateUnionTransposeRule;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterProjectTransposeRule;
import org.apache.calcite.rel.rules.FilterTableScanRule;
import org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.calcite.rel.rules.JoinPushExpressionsRule;
import org.apache.calcite.rel.rules.JoinPushThroughJoinRule;
import org.apache.calcite.rel.rules.JoinUnionTransposeRule;
import org.apache.calcite.rel.rules.ProjectFilterTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ProjectRemoveRule;
import org.apache.calcite.rel.rules.ProjectTableScanRule;
import org.apache.calcite.rel.rules.ProjectWindowTransposeRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.rules.SemiJoinRule;
import org.apache.calcite.rel.rules.SortJoinTransposeRule;
import org.apache.calcite.rel.rules.SortProjectTransposeRule;
import org.apache.calcite.rel.rules.SortUnionTransposeRule;
import org.apache.calcite.rel.rules.TableScanRule;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.stream.StreamRules;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.guava30.shaded.common.base.Function;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.query.engine.meta.PlannerContext;
import org.apache.kylin.query.relnode.OLAPContext;

public class PlannerFactory {
    public static final List<RelOptRule> ENUMERABLE_RULES = ImmutableList.of((Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_MERGE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_SEMI_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object)EnumerableRules.ENUMERABLE_AGGREGATE_RULE, (Object)EnumerableRules.ENUMERABLE_SORT_RULE, (Object)EnumerableRules.ENUMERABLE_LIMIT_RULE, (Object)EnumerableRules.ENUMERABLE_COLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNION_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_INTERSECT_RULE, EnumerableRules.ENUMERABLE_MINUS_RULE, EnumerableRules.ENUMERABLE_TABLE_MODIFICATION_RULE, EnumerableRules.ENUMERABLE_VALUES_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.ENUMERABLE_TABLE_FUNCTION_SCAN_RULE});
    private static final List<RelOptRule> DEFAULT_RULES = ImmutableList.of((Object)AggregateStarTableRule.INSTANCE, (Object)AggregateStarTableRule.INSTANCE2, (Object)TableScanRule.INSTANCE, (Object)ProjectMergeRule.INSTANCE, (Object)FilterTableScanRule.INSTANCE, (Object)ProjectFilterTransposeRule.INSTANCE, (Object)FilterProjectTransposeRule.INSTANCE, (Object)FilterJoinRule.FILTER_ON_JOIN, (Object)JoinPushExpressionsRule.INSTANCE, (Object)AggregateExpandDistinctAggregatesRule.INSTANCE, (Object)KapAggregateReduceFunctionsRule.INSTANCE, (Object)FilterAggregateTransposeRule.INSTANCE, (Object[])new RelOptRule[]{ProjectWindowTransposeRule.INSTANCE, JoinCommuteRule.INSTANCE, JoinPushThroughJoinRule.RIGHT, JoinPushThroughJoinRule.LEFT, SortProjectTransposeRule.INSTANCE, SortJoinTransposeRule.INSTANCE, SortUnionTransposeRule.INSTANCE});
    private final KylinConfig kylinConfig;

    public PlannerFactory(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
    }

    public VolcanoPlanner createVolcanoPlanner(CalciteConnectionConfig connectionConfig) {
        VolcanoPlanner planner = new VolcanoPlanner((Context)new PlannerContext(connectionConfig));
        this.registerDefaultRules(planner);
        this.registerCustomRules(planner);
        return planner;
    }

    private void registerDefaultRules(VolcanoPlanner planner) {
        planner.addRelTraitDef((RelTraitDef)ConventionTraitDef.INSTANCE);
        planner.addRelTraitDef((RelTraitDef)RelCollationTraitDef.INSTANCE);
        planner.registerAbstractRelationalRules();
        RelOptUtil.registerAbstractRels((RelOptPlanner)planner);
        for (RelOptRule rule : DEFAULT_RULES) {
            planner.addRule(rule);
        }
        planner.addRule(Bindables.BINDABLE_TABLE_SCAN_RULE);
        planner.addRule((RelOptRule)ProjectTableScanRule.INSTANCE);
        planner.addRule((RelOptRule)ProjectTableScanRule.INTERPRETER);
        for (RelOptRule rule : ENUMERABLE_RULES) {
            planner.addRule(rule);
        }
        planner.addRule((RelOptRule)EnumerableInterpreterRule.INSTANCE);
        for (RelOptRule rule : StreamRules.RULES) {
            planner.addRule(rule);
        }
    }

    private void registerCustomRules(VolcanoPlanner planner) {
        OLAPContext.clearThreadLocalContexts();
        planner.addRule((RelOptRule)KapOLAPToEnumerableConverterRule.INSTANCE);
        planner.addRule(KapFilterRule.INSTANCE);
        planner.addRule(KapProjectRule.INSTANCE);
        planner.addRule((RelOptRule)KapAggregateRule.INSTANCE);
        planner.addRule((RelOptRule)this.selectJoinRuleByConfig());
        planner.addRule(KapLimitRule.INSTANCE);
        planner.addRule((RelOptRule)KapSortRule.INSTANCE);
        planner.addRule((RelOptRule)KapUnionRule.INSTANCE);
        planner.addRule((RelOptRule)KapWindowRule.INSTANCE);
        planner.addRule((RelOptRule)KAPValuesRule.INSTANCE);
        planner.addRule((RelOptRule)KapMinusRule.INSTANCE);
        planner.addRule(KapModelViewRule.INSTANCE);
        planner.removeRule((RelOptRule)ProjectMergeRule.INSTANCE);
        planner.addRule((RelOptRule)KapProjectMergeRule.INSTANCE);
        if (KapConfig.getInstanceFromEnv().splitGroupSetsIntoUnion()) {
            planner.addRule((RelOptRule)AggregateMultipleExpandRule.INSTANCE);
        }
        planner.addRule((RelOptRule)AggregateProjectReduceRule.INSTANCE);
        if (!this.kylinConfig.isConvertSumExpressionEnabled()) {
            planner.addRule((RelOptRule)SumConstantConvertRule.INSTANCE);
        }
        if (this.kylinConfig.isReduceExpressionsRulesEnabled()) {
            planner.addRule((RelOptRule)ReduceExpressionsRule.PROJECT_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.FILTER_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.CALC_INSTANCE);
            planner.addRule((RelOptRule)ReduceExpressionsRule.JOIN_INSTANCE);
        }
        this.removeRules((RelOptPlanner)planner, this.kylinConfig.getCalciteRemoveRule());
        if (!this.kylinConfig.isEnumerableRulesEnabled().booleanValue()) {
            for (RelOptRule rule : CalcitePrepareImpl.ENUMERABLE_RULES) {
                planner.removeRule(rule);
            }
        }
        planner.removeRule((RelOptRule)FilterJoinRule.FILTER_ON_JOIN);
        planner.removeRule((RelOptRule)FilterJoinRule.JOIN);
        planner.addRule((RelOptRule)KapFilterJoinRule.KAP_FILTER_ON_JOIN_JOIN);
        planner.addRule((RelOptRule)KapFilterJoinRule.KAP_FILTER_ON_JOIN_SCAN);
        planner.removeRule((RelOptRule)JoinCommuteRule.INSTANCE);
        planner.removeRule(JoinPushThroughJoinRule.LEFT);
        planner.removeRule(JoinPushThroughJoinRule.RIGHT);
        planner.removeRule((RelOptRule)AggregateProjectMergeRule.INSTANCE);
        planner.removeRule((RelOptRule)FilterProjectTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)SortJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)JoinPushExpressionsRule.INSTANCE);
        planner.removeRule((RelOptRule)SortUnionTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)JoinUnionTransposeRule.LEFT_UNION);
        planner.removeRule((RelOptRule)JoinUnionTransposeRule.RIGHT_UNION);
        planner.removeRule((RelOptRule)AggregateUnionTransposeRule.INSTANCE);
        planner.removeRule(DateRangeRules.FILTER_INSTANCE);
        planner.removeRule((RelOptRule)SemiJoinRule.JOIN);
        planner.removeRule((RelOptRule)SemiJoinRule.PROJECT);
        planner.removeRule((RelOptRule)AggregateExpandDistinctAggregatesRule.INSTANCE);
        planner.removeRule((RelOptRule)AbstractConverter.ExpandConversionRule.INSTANCE);
        planner.addRule(RightJoinToLeftJoinRule.INSTANCE);
        planner.removeRule((RelOptRule)UnionMergeRule.INSTANCE);
        planner.addRule((RelOptRule)KapProjectJoinTransposeRule.INSTANCE);
        planner.removeRule((RelOptRule)ProjectRemoveRule.INSTANCE);
        if (!KylinConfig.getInstanceFromEnv().getSkipCorrReduceRule()) {
            planner.addRule((RelOptRule)CorrReduceFunctionRule.INSTANCE);
        }
    }

    private ConverterRule selectJoinRuleByConfig() {
        return this.kylinConfig.isQueryNonEquiJoinModelEnabled() && (!BackdoorToggles.getIsQueryFromAutoModeling() || BackdoorToggles.getIsQueryNonEquiJoinModelEnabled() || KylinConfig.getInstanceFromEnv().isUTEnv()) ? KapJoinRule.NON_EQUI_INSTANCE : KapJoinRule.INSTANCE;
    }

    protected void removeRules(final RelOptPlanner planner, List<String> rules) {
        this.modifyRules(rules, new Function<RelOptRule, Void>(){

            @Nullable
            public Void apply(@Nullable RelOptRule input) {
                planner.removeRule(input);
                return null;
            }
        });
    }

    private void modifyRules(List<String> rules, Function<RelOptRule, Void> func) {
        for (String rule : rules) {
            if (StringUtils.isEmpty((CharSequence)rule)) continue;
            String[] split = rule.split("#");
            if (split.length != 2) {
                throw new RuntimeException("Customized Rule should be in format <RuleClassName>#<FieldName>");
            }
            String clazz = split[0];
            String field = split[1];
            try {
                func.apply((Object)((RelOptRule)Class.forName(clazz).getDeclaredField(field).get(null)));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

