/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.BufferedLogger;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.DefaultSparkBuildJobHandler;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.SparkAppDescription;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.query.util.QueryParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncQueryJob
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(AsyncQueryJob.class);
    private static final String GLOBAL = "/_global";
    private static final String DATAFLOW = "/dataflow";
    private static final String DATAFLOW_DETAIL = "/dataflow_details";
    private static final String INDEX_PLAN = "/index_plan";
    private static final String MODEL = "/model_desc";
    private static final String TABLE = "/table";
    private static final String TABLE_EXD = "/table_exd";
    private static final String ACL = "/acl";
    private static final String[] META_DUMP_LIST = new String[]{"/dataflow", "/dataflow_details", "/index_plan", "/model_desc", "/table", "/table_exd", "/acl"};

    public AsyncQueryJob() {
    }

    public AsyncQueryJob(Object notSetId) {
        super(notSetId);
    }

    protected void initHandler() {
        this.sparkJobHandler = new DefaultSparkBuildJobHandler();
    }

    protected ExecuteResult runSparkSubmit(String hadoopConf, String kylinJobJar, String appArgs) {
        BufferedLogger patternedLogger = new BufferedLogger(logger);
        try {
            this.killOrphanApplicationIfExists(this.getId());
            SparkAppDescription desc = this.getSparkAppDesc();
            desc.setHadoopConfDir(hadoopConf);
            desc.setKylinJobJar(kylinJobJar);
            desc.setAppArgs(appArgs);
            String cmd = (String)this.sparkJobHandler.generateSparkCmd(KylinConfig.getInstanceFromEnv(), desc);
            CliCommandExecutor exec = this.getCliCommandExecutor();
            CliCommandExecutor.CliCmdExecResult r = exec.execute(cmd, (org.apache.kylin.common.util.Logger)patternedLogger, this.getId());
            return ExecuteResult.createSucceed((String)r.getCmd());
        }
        catch (Exception e) {
            return ExecuteResult.createError((Throwable)e);
        }
    }

    @VisibleForTesting
    public CliCommandExecutor getCliCommandExecutor() {
        return new CliCommandExecutor();
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map overrides = config.getAsyncQuerySparkConfigOverride();
        if (StringUtils.isNotEmpty((CharSequence)this.getParam("queryQueue"))) {
            overrides.put("spark.yarn.queue", this.getParam("queryQueue"));
        }
        if (!overrides.containsKey("spark.driver.memory")) {
            overrides.put("spark.driver.memory", "1024m");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            overrides.put("spark.hadoop.hive.metastore.sasl.enabled", "true");
        }
        return overrides;
    }

    protected String getJobNamePrefix() {
        return "";
    }

    protected String getExtJar() {
        return this.getConfig().getKylinExtJarsPath();
    }

    public String getId() {
        return "ASYNC-QUERY-" + super.getId();
    }

    public ExecuteResult submit(QueryParams queryParams) throws ExecuteException, JsonProcessingException {
        KylinConfigExt config;
        String kylinJobJar;
        this.setLogPath(this.getSparkDriverLogHdfsPath(this.getConfig()));
        KylinConfig originConfig = this.getConfig();
        HashMap overrideCopy = Maps.newHashMap((Map)((KylinConfigExt)originConfig).getExtendedOverrides());
        if (StringUtils.isNotEmpty((CharSequence)queryParams.getSparkQueue())) {
            overrideCopy.put("kylin.query.async-query.spark-conf.spark.yarn.queue", queryParams.getSparkQueue());
        }
        if (StringUtils.isEmpty((CharSequence)(kylinJobJar = (config = KylinConfigExt.createInstance((KylinConfig)originConfig, (Map)overrideCopy)).getKylinJobJarPath())) && !config.isUTEnv()) {
            throw new KylinRuntimeException("Missing kylin job jar");
        }
        ObjectMapper fieldOnlyMapper = new ObjectMapper();
        fieldOnlyMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        this.setParam("queryParams", fieldOnlyMapper.writeValueAsString((Object)queryParams));
        this.setParam("queryContext", JsonUtil.writeValueAsString((Object)QueryContext.current()));
        this.setParam("project", this.getProject());
        this.setParam("queryId", QueryContext.current().getQueryId());
        this.setParam("jobId", this.getId());
        this.setParam("jobType", JobTypeEnum.ASYNC_QUERY.toString());
        this.setParam("queryQueue", queryParams.getSparkQueue());
        this.setDistMetaUrl(config.getJobTmpMetaStoreUrl(this.getProject(), this.getId()));
        try {
            config.setQueryHistoryUrl(config.getQueryHistoryUrl().toString());
            this.attachMetadataAndKylinProps((KylinConfig)config, true);
            ArrayList metadataDumpSet = Lists.newArrayList();
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
            metadataDumpSet.addAll(resourceStore.listResourcesRecursively(GLOBAL));
            for (String mata : META_DUMP_LIST) {
                if (resourceStore.listResourcesRecursively("/" + this.getProject() + mata) == null) continue;
                metadataDumpSet.addAll(resourceStore.listResourcesRecursively("/" + this.getProject() + mata));
            }
            KylinConfig configCopy = KylinConfig.createKylinConfig((KylinConfig)config);
            configCopy.setMetadataUrl(config.getJobTmpMetaStoreUrl(this.getProject(), this.getId()).toString());
            MetadataStore.createMetadataStore((KylinConfig)configCopy).dump(ResourceStore.getKylinMetaStore((KylinConfig)config), (Collection)metadataDumpSet);
        }
        catch (Exception e) {
            throw new ExecuteException("kylin properties or meta dump failed", (Throwable)e);
        }
        return this.runSparkSubmit(this.getHadoopConfDir(), kylinJobJar, "-className org.apache.kylin.query.engine.AsyncQueryApplication " + this.createArgsFileOnHDFS((KylinConfig)config, this.getId()));
    }

    private String getHadoopConfDir() {
        KylinConfig kylinconfig = KylinConfig.getInstanceFromEnv();
        if (StringUtils.isNotEmpty((CharSequence)kylinconfig.getAsyncQueryHadoopConfDir())) {
            return kylinconfig.getAsyncQueryHadoopConfDir();
        }
        return HadoopUtil.getHadoopConfDir();
    }
}

