/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.exception.SumExprUnSupportException;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.util.AggExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumConstantConvertRule
extends RelOptRule {
    private static final Logger logger = LoggerFactory.getLogger(SumConstantConvertRule.class);
    public static final SumConstantConvertRule INSTANCE = new SumConstantConvertRule(SumConstantConvertRule.operand(KapAggregateRel.class, (RelOptRuleOperand)SumConstantConvertRule.operand(KapProjectRel.class, null, input -> !AggExpressionUtil.hasAggInput((RelNode)input), (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "SumConstantConvertRule");

    public SumConstantConvertRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall ruleCall) {
        Aggregate oldAgg = (Aggregate)ruleCall.rel(0);
        Project oldProject = (Project)ruleCall.rel(1);
        try {
            boolean matches = false;
            for (AggExpressionUtil.AggExpression sumExpr : AggExpressionUtil.collectSumExpressions(oldAgg, oldProject)) {
                if (!sumExpr.isSumConst()) continue;
                matches = true;
            }
            return matches;
        }
        catch (SumExprUnSupportException e) {
            logger.trace("Current rel unable to apply SumBasicOperatorRule", (Throwable)((Object)e));
            return false;
        }
    }

    public void onMatch(RelOptRuleCall ruleCall) {
        try {
            int i;
            RelBuilder relBuilder = ruleCall.builder();
            Aggregate oldAgg = (Aggregate)ruleCall.rel(0);
            Project oldProject = (Project)ruleCall.rel(1);
            ContextUtil.dumpCalcitePlan((String)"old plan", (RelNode)oldAgg, (Logger)logger);
            List<AggExpressionUtil.AggExpression> aggExpressions = AggExpressionUtil.collectSumExpressions(oldAgg, oldProject);
            Pair<List<AggExpressionUtil.GroupExpression>, ImmutableList<ImmutableBitSet>> groups = AggExpressionUtil.collectGroupExprAndGroup(oldAgg, oldProject);
            List groupExpressions = (List)groups.getFirst();
            ImmutableList newGroupSets = (ImmutableList)groups.getSecond();
            relBuilder.push(oldProject.getInput());
            List<RexNode> bottomProjectList = this.buildBottomProject(relBuilder, oldProject, groupExpressions, aggExpressions);
            relBuilder.project(bottomProjectList);
            ImmutableBitSet.Builder groupSetBuilder = ImmutableBitSet.builder();
            for (AggExpressionUtil.GroupExpression group : groupExpressions) {
                for (int i2 = 0; i2 < group.getBottomAggInput().length; ++i2) {
                    groupSetBuilder.set(group.getBottomAggInput()[i2]);
                }
            }
            ImmutableBitSet bottomAggGroupSet = groupSetBuilder.build();
            RelBuilder.GroupKey groupKey = relBuilder.groupKey(bottomAggGroupSet, null);
            List<AggregateCall> aggCalls = this.buildBottomAggCall(relBuilder, aggExpressions, bottomAggGroupSet.cardinality());
            relBuilder.aggregate(groupKey, aggCalls);
            for (AggExpressionUtil.GroupExpression groupExpression : groupExpressions) {
                for (i = 0; i < groupExpression.getTopProjInput().length; ++i) {
                    int groupIdx = groupExpression.getBottomAggInput()[i];
                    groupExpression.getTopProjInput()[i] = bottomAggGroupSet.indexOf(groupIdx);
                }
            }
            List<RexNode> topProjectList = this.buildTopProject(relBuilder, oldProject, groupExpressions, aggExpressions);
            relBuilder.project(topProjectList);
            ImmutableBitSet.Builder topGroupSetBuilder = ImmutableBitSet.builder();
            for (i = 0; i < groupExpressions.size(); ++i) {
                topGroupSetBuilder.set(i);
            }
            ImmutableBitSet topGroupSet = topGroupSetBuilder.build();
            List<AggregateCall> topAggregates = this.buildTopAggregate(oldAgg.getAggCallList(), topGroupSet.cardinality(), aggExpressions);
            RelBuilder.GroupKey topGroupKey = relBuilder.groupKey(topGroupSet, newGroupSets);
            relBuilder.aggregate(topGroupKey, topAggregates);
            RelNode relNode = relBuilder.build();
            ContextUtil.dumpCalcitePlan((String)"new plan", (RelNode)relNode, (Logger)logger);
            ruleCall.transformTo(relNode);
        }
        catch (Exception e) {
            logger.error("sql cannot apply sum constant rule ", (Throwable)e);
        }
    }

    private List<RexNode> buildBottomProject(RelBuilder relBuilder, Project oldProject, List<AggExpressionUtil.GroupExpression> groupExpressions, List<AggExpressionUtil.AggExpression> aggExpressions) {
        ArrayList bottomProjectList = Lists.newArrayList();
        for (AggExpressionUtil.GroupExpression groupExpr : groupExpressions) {
            int[] sourceInput = groupExpr.getBottomProjInput();
            for (int i = 0; i < sourceInput.length; ++i) {
                groupExpr.getBottomAggInput()[i] = bottomProjectList.size();
                RexInputRef groupInput = relBuilder.getRexBuilder().makeInputRef(oldProject.getInput(), sourceInput[i]);
                bottomProjectList.add(groupInput);
            }
        }
        for (AggExpressionUtil.AggExpression aggExpression : aggExpressions) {
            if (aggExpression.isSumConst() || aggExpression.getExpression() == null) continue;
            aggExpression.getBottomAggInput()[0] = bottomProjectList.size();
            bottomProjectList.add(aggExpression.getExpression());
        }
        return bottomProjectList;
    }

    private List<AggregateCall> buildBottomAggCall(RelBuilder relBuilder, List<AggExpressionUtil.AggExpression> aggExpressions, int bottomAggOffset) {
        ArrayList aggCalls = Lists.newArrayList();
        int sumConstIdx = 0;
        for (AggExpressionUtil.AggExpression sumExpr : aggExpressions) {
            AggregateCall aggCall;
            String aggName = "SUM_CONST$" + sumConstIdx++;
            if (sumExpr.isSumConst()) {
                aggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.COUNT, (boolean)false, (boolean)false, (List)Lists.newArrayList(), (int)-1, (int)bottomAggOffset, (RelNode)relBuilder.peek(), null, (String)aggName);
            } else {
                AggregateCall oldAggCall = sumExpr.getAggCall();
                List args = Arrays.stream(sumExpr.getBottomAggInput()).boxed().collect(Collectors.toList());
                int filterArg = oldAggCall.filterArg;
                aggCall = oldAggCall.copy(args, filterArg);
            }
            sumExpr.getTopProjInput()[0] = aggCalls.size() + bottomAggOffset;
            aggCalls.add(aggCall);
        }
        return aggCalls;
    }

    private List<RexNode> buildTopProject(RelBuilder relBuilder, Project oldProject, List<AggExpressionUtil.GroupExpression> groupExpressions, List<AggExpressionUtil.AggExpression> aggExpressions) {
        ArrayList topProjectList = Lists.newArrayList();
        for (AggExpressionUtil.GroupExpression groupExpr : groupExpressions) {
            int[] aggAdjustments = AggExpressionUtil.generateAdjustments(groupExpr.getBottomProjInput(), groupExpr.getTopProjInput());
            RexNode projectExpr = (RexNode)groupExpr.getExpression().accept((RexVisitor)new RelOptUtil.RexInputConverter(relBuilder.getRexBuilder(), oldProject.getInput().getRowType().getFieldList(), relBuilder.peek().getRowType().getFieldList(), aggAdjustments));
            projectExpr = relBuilder.getRexBuilder().ensureType(groupExpr.getExpression().getType(), projectExpr, false);
            topProjectList.add(projectExpr);
        }
        for (AggExpressionUtil.AggExpression sumExpr : aggExpressions) {
            RexInputRef rexNode = relBuilder.getRexBuilder().makeInputRef(relBuilder.peek(), sumExpr.getTopProjInput()[0]);
            if (sumExpr.isSumConst()) {
                RexNode expr = sumExpr.getExpression();
                ArrayList newArgs = Lists.newArrayList();
                newArgs.add(expr);
                newArgs.add(rexNode);
                RexNode result = relBuilder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, (Iterable)newArgs);
                rexNode = relBuilder.getRexBuilder().ensureType(sumExpr.getAggCall().getType(), result, false);
            }
            topProjectList.add(rexNode);
        }
        return topProjectList;
    }

    private List<AggregateCall> buildTopAggregate(List<AggregateCall> oldAggregates, int groupOffset, List<AggExpressionUtil.AggExpression> aggExpressions) {
        ArrayList topAggregates = Lists.newArrayList();
        for (int aggIndex = 0; aggIndex < oldAggregates.size(); ++aggIndex) {
            AggExpressionUtil.AggExpression aggExpression = aggExpressions.get(aggIndex);
            AggregateCall aggCall = aggExpression.getAggCall();
            String aggName = "TOP_AGG$" + aggIndex;
            SqlAggFunction aggFunction = SqlKind.COUNT == aggCall.getAggregation().getKind() ? SqlStdOperatorTable.SUM0 : aggCall.getAggregation();
            topAggregates.add(AggregateCall.create((SqlAggFunction)aggFunction, (boolean)false, (boolean)false, (List)Lists.newArrayList((Object[])new Integer[]{groupOffset + aggIndex}), (int)-1, (RelDataType)aggCall.getType(), (String)aggName));
        }
        return topAggregates;
    }
}

