/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import com.google.common.collect.ImmutableList;
import io.kyligence.kap.query.optrule.KapRuleUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.query.exception.SumExprUnSupportException;
import org.apache.kylin.query.relnode.ContextUtil;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.KapProjectRel;
import org.apache.kylin.query.util.AggExpressionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SumBasicOperatorRule
extends RelOptRule {
    private static final Logger logger = LoggerFactory.getLogger(SumBasicOperatorRule.class);
    public static final SumBasicOperatorRule INSTANCE = new SumBasicOperatorRule(SumBasicOperatorRule.operand(KapAggregateRel.class, (RelOptRuleOperand)SumBasicOperatorRule.operand(KapProjectRel.class, null, input -> !AggExpressionUtil.hasAggInput((RelNode)input), (RelOptRuleOperandChildren)RelOptRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), RelFactories.LOGICAL_BUILDER, "SumBasicOperatorRule");

    public SumBasicOperatorRule(RelOptRuleOperand operand, RelBuilderFactory relBuilderFactory, String description) {
        super(operand, relBuilderFactory, description);
    }

    public boolean matches(RelOptRuleCall ruleCall) {
        Aggregate oldAgg = (Aggregate)ruleCall.rel(0);
        Project oldProject = (Project)ruleCall.rel(1);
        try {
            boolean matches = false;
            for (AggExpressionUtil.AggExpression sumExpr : AggExpressionUtil.collectSumExpressions(oldAgg, oldProject)) {
                if (!this.checkExpressionSupported(sumExpr)) continue;
                matches = true;
            }
            return matches;
        }
        catch (SumExprUnSupportException e) {
            logger.trace("Current rel unable to apply SumBasicOperatorRule", (Throwable)((Object)e));
            return false;
        }
    }

    public void onMatch(RelOptRuleCall ruleCall) {
        try {
            int i;
            Aggregate oldAgg = (Aggregate)ruleCall.rel(0);
            Project oldProject = (Project)ruleCall.rel(1);
            RelBuilder relBuilder = ruleCall.builder();
            relBuilder.push(oldProject.getInput());
            ContextUtil.dumpCalcitePlan((String)"old plan", (RelNode)oldAgg, (Logger)logger);
            List<AggExpressionUtil.AggExpression> aggExpressions = AggExpressionUtil.collectSumExpressions(oldAgg, oldProject);
            Pair<List<AggExpressionUtil.GroupExpression>, ImmutableList<ImmutableBitSet>> groups = AggExpressionUtil.collectGroupExprAndGroup(oldAgg, oldProject);
            List groupExpressions = (List)groups.getFirst();
            ImmutableList newGroupSets = (ImmutableList)groups.getSecond();
            List<RexNode> bottomProjectList = this.buildBottomProject(relBuilder, oldProject, groupExpressions, aggExpressions);
            relBuilder.project(bottomProjectList);
            ImmutableBitSet.Builder groupSetBuilder = ImmutableBitSet.builder();
            for (AggExpressionUtil.GroupExpression group : groupExpressions) {
                for (int i2 = 0; i2 < group.getBottomAggInput().length; ++i2) {
                    groupSetBuilder.set(group.getBottomAggInput()[i2]);
                }
            }
            ImmutableBitSet bottomAggGroupSet = groupSetBuilder.build();
            RelBuilder.GroupKey groupKey = relBuilder.groupKey(bottomAggGroupSet, null);
            List<AggregateCall> bottomAggregates = this.buildBottomAggregate(relBuilder, aggExpressions, bottomAggGroupSet.cardinality());
            relBuilder.aggregate(groupKey, bottomAggregates);
            for (AggExpressionUtil.GroupExpression groupExpression : groupExpressions) {
                for (i = 0; i < groupExpression.getTopProjInput().length; ++i) {
                    int groupIdx = groupExpression.getBottomAggInput()[i];
                    groupExpression.getTopProjInput()[i] = bottomAggGroupSet.indexOf(groupIdx);
                }
            }
            List<RexNode> topProjectList = this.buildTopProjectList(relBuilder, oldProject, aggExpressions, groupExpressions);
            relBuilder.project(topProjectList);
            ImmutableBitSet.Builder topGroupSetBuilder = ImmutableBitSet.builder();
            for (i = 0; i < groupExpressions.size(); ++i) {
                topGroupSetBuilder.set(i);
            }
            ImmutableBitSet topGroupSet = topGroupSetBuilder.build();
            List<AggregateCall> topAggregates = this.buildTopAggregate(oldAgg.getAggCallList(), topGroupSet.cardinality(), aggExpressions);
            RelBuilder.GroupKey topGroupKey = relBuilder.groupKey(topGroupSet, newGroupSets);
            relBuilder.aggregate(topGroupKey, topAggregates);
            RelNode relNode = relBuilder.build();
            ContextUtil.dumpCalcitePlan((String)"new plan", (RelNode)relNode, (Logger)logger);
            ruleCall.transformTo(relNode);
        }
        catch (Exception e) {
            logger.error("sql cannot apply sum multiply rule ", (Throwable)e);
        }
    }

    private List<RexNode> buildBottomProject(RelBuilder relBuilder, Project oldProject, List<AggExpressionUtil.GroupExpression> groupExpressions, List<AggExpressionUtil.AggExpression> aggExpressions) {
        ArrayList bottomProjectList = Lists.newArrayList();
        for (AggExpressionUtil.GroupExpression groupExpr : groupExpressions) {
            int[] sourceInput = groupExpr.getBottomProjInput();
            for (int i = 0; i < sourceInput.length; ++i) {
                groupExpr.getBottomAggInput()[i] = bottomProjectList.size();
                RexInputRef groupInput = relBuilder.getRexBuilder().makeInputRef(oldProject.getInput(), sourceInput[i]);
                bottomProjectList.add(groupInput);
            }
        }
        for (AggExpressionUtil.AggExpression sumExpr : aggExpressions) {
            if (this.checkExpressionSupported(sumExpr)) {
                List sumColumn = Arrays.stream(sumExpr.getBottomProjInput()).mapToObj(input -> relBuilder.getRexBuilder().makeInputRef(oldProject.getInput(), input)).collect(Collectors.toList());
                if (sumExpr.getBottomAggInput().length != 0) {
                    sumExpr.getBottomAggInput()[0] = bottomProjectList.size();
                }
                bottomProjectList.addAll(sumColumn);
                continue;
            }
            if (sumExpr.getExpression() == null) continue;
            sumExpr.getBottomAggInput()[0] = bottomProjectList.size();
            bottomProjectList.add(sumExpr.getExpression());
        }
        return bottomProjectList;
    }

    private List<AggregateCall> buildBottomAggregate(RelBuilder relBuilder, List<AggExpressionUtil.AggExpression> aggExpressions, int bottomAggOffset) {
        int sumOpIndex = 0;
        ArrayList bottomAggregates = Lists.newArrayList();
        for (AggExpressionUtil.AggExpression aggExpression : aggExpressions) {
            AggregateCall aggCall;
            if (this.checkExpressionSupported(aggExpression)) {
                AggExpressionUtil.assertCondition(aggExpression.getBottomProjInput().length == 1, "SumBasicOperatorRule only handles aggregation of single source column");
                String aggName = "SUM_OP$" + sumOpIndex++;
                ArrayList aggList = Lists.newArrayList((Object[])new Integer[]{aggExpression.getBottomAggInput()[0]});
                aggCall = AggregateCall.create((SqlAggFunction)SqlStdOperatorTable.SUM, (boolean)false, (boolean)false, (List)aggList, (int)-1, (int)bottomAggOffset, (RelNode)relBuilder.peek(), null, (String)aggName);
            } else {
                AggregateCall oldAggCall = aggExpression.getAggCall();
                List args = Arrays.stream(aggExpression.getBottomAggInput()).boxed().collect(Collectors.toList());
                int filterArg = oldAggCall.filterArg;
                aggCall = oldAggCall.copy(args, filterArg);
            }
            aggExpression.getTopProjInput()[0] = bottomAggOffset + bottomAggregates.size();
            bottomAggregates.add(aggCall);
        }
        return bottomAggregates;
    }

    private List<RexNode> buildTopProjectList(RelBuilder relBuilder, Project oldProject, List<AggExpressionUtil.AggExpression> aggExpressions, List<AggExpressionUtil.GroupExpression> groupExpressions) {
        ArrayList topProjectList = Lists.newArrayList();
        for (AggExpressionUtil.GroupExpression groupExpr : groupExpressions) {
            int[] aggAdjustments = AggExpressionUtil.generateAdjustments(groupExpr.getBottomProjInput(), groupExpr.getTopProjInput());
            RexNode projectExpr = (RexNode)groupExpr.getExpression().accept((RexVisitor)new RelOptUtil.RexInputConverter(relBuilder.getRexBuilder(), oldProject.getInput().getRowType().getFieldList(), relBuilder.peek().getRowType().getFieldList(), aggAdjustments));
            projectExpr = relBuilder.getRexBuilder().ensureType(groupExpr.getExpression().getType(), projectExpr, false);
            topProjectList.add(projectExpr);
        }
        for (AggExpressionUtil.AggExpression sumExpr : aggExpressions) {
            RexInputRef rexNode = relBuilder.getRexBuilder().makeInputRef(relBuilder.peek(), sumExpr.getTopProjInput()[0]);
            if (this.checkExpressionSupported(sumExpr)) {
                RexNode expr = sumExpr.getExpression();
                int[] adjustments = AggExpressionUtil.generateAdjustments(sumExpr.getBottomProjInput(), sumExpr.getTopProjInput());
                rexNode = (RexNode)expr.accept((RexVisitor)new RelOptUtil.RexInputConverter(relBuilder.getRexBuilder(), oldProject.getInput().getRowType().getFieldList(), relBuilder.peek().getRowType().getFieldList(), adjustments));
                rexNode = relBuilder.getRexBuilder().ensureType(sumExpr.getAggCall().getType(), (RexNode)rexNode, false);
            }
            topProjectList.add(rexNode);
        }
        return topProjectList;
    }

    private List<AggregateCall> buildTopAggregate(List<AggregateCall> oldAggregates, int groupOffset, List<AggExpressionUtil.AggExpression> aggExpressions) {
        ArrayList topAggregates = Lists.newArrayList();
        for (int aggIndex = 0; aggIndex < oldAggregates.size(); ++aggIndex) {
            AggExpressionUtil.AggExpression aggExpression = aggExpressions.get(aggIndex);
            AggregateCall aggCall = aggExpression.getAggCall();
            String aggName = "AGG$" + aggIndex;
            SqlAggFunction aggFunction = SqlKind.COUNT == aggCall.getAggregation().getKind() ? SqlStdOperatorTable.SUM : aggCall.getAggregation();
            topAggregates.add(AggregateCall.create((SqlAggFunction)aggFunction, (boolean)false, (boolean)false, (List)Lists.newArrayList((Object[])new Integer[]{groupOffset + aggIndex}), (int)-1, (RelDataType)aggCall.getType(), (String)aggName));
        }
        return topAggregates;
    }

    private boolean checkExpressionSupported(AggExpressionUtil.AggExpression aggExpression) {
        if (aggExpression.isSumCase()) {
            throw new SumExprUnSupportException("SumBasicOperatorRule is unable to handle sum case expression.");
        }
        AggregateCall aggCall = aggExpression.getAggCall();
        RexNode expr = aggExpression.getExpression();
        SqlKind aggType = aggCall.getAggregation().getKind();
        if (!AggExpressionUtil.isSum(aggType)) {
            return false;
        }
        if (!(expr instanceof RexCall)) {
            return false;
        }
        if (!this.isBasicOperand(expr)) {
            return false;
        }
        this.checkUnSupportOperands(expr);
        return true;
    }

    private boolean isBasicOperand(RexNode expr) {
        if (expr instanceof RexLiteral || expr instanceof RexInputRef) {
            return true;
        }
        if (SqlKind.PLUS == expr.getKind() || SqlKind.MINUS == expr.getKind() || SqlKind.TIMES == expr.getKind() || KapRuleUtils.isDivide(expr)) {
            if (!(expr instanceof RexCall)) {
                return false;
            }
            RexCall exprCall = (RexCall)expr;
            RexNode left = (RexNode)exprCall.getOperands().get(0);
            RexNode right = (RexNode)exprCall.getOperands().get(1);
            return this.isBasicOperand(left) && this.isBasicOperand(right);
        }
        return false;
    }

    private void checkUnSupportOperands(RexNode expr) {
        if (!(expr instanceof RexCall)) {
            return;
        }
        RexCall exprCall = (RexCall)expr;
        this.verify(exprCall);
        for (RexNode exprNode : exprCall.getOperands()) {
            if (!(exprNode instanceof RexCall)) continue;
            this.checkUnSupportOperands(exprNode);
        }
    }

    private void verify(RexCall exprCall) {
        switch (exprCall.getKind()) {
            case PLUS: 
            case MINUS: {
                this.verifyPlusOrMinus(exprCall);
                break;
            }
            case TIMES: {
                this.verifyMultiply(exprCall);
                break;
            }
            case DIVIDE: {
                this.verifyDivide(exprCall);
                break;
            }
        }
        if (KapRuleUtils.isDivide((RexNode)exprCall)) {
            this.verifyDivide(exprCall);
        }
    }

    private void verifyPlusOrMinus(RexCall exprCall) {
        throw new SumExprUnSupportException("That PLUS/MINUS of the columns is not supported for sum expression");
    }

    private void verifyMultiply(RexCall exprCall) {
        RexNode left = (RexNode)exprCall.getOperands().get(0);
        RexNode right = (RexNode)exprCall.getOperands().get(1);
        if (!this.isConstant(left) && !this.isConstant(right)) {
            throw new SumExprUnSupportException("That both of the two sides of the columns is not supported for " + exprCall.getKind().toString());
        }
    }

    private void verifyDivide(RexCall exprCall) {
        RexNode right = (RexNode)exprCall.getOperands().get(1);
        if (!this.isConstant(right)) {
            throw new SumExprUnSupportException("That the right side of the columns is not supported for " + exprCall.getKind().toString());
        }
    }

    private boolean isConstant(RexNode expr) {
        return this.extractColumn(expr).isEmpty();
    }

    private List<RexNode> extractColumn(RexNode expr) {
        ArrayList values = Lists.newArrayList();
        if (expr instanceof RexInputRef) {
            values.add(expr);
        }
        if (expr instanceof RexCall) {
            RexCall exprCall = (RexCall)expr;
            for (RexNode exprNode : exprCall.getOperands()) {
                values.addAll(this.extractColumn(exprNode));
            }
        }
        return values;
    }
}

