/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

public class KapProjectMergeRule
extends RelOptRule {
    public static final KapProjectMergeRule INSTANCE = new KapProjectMergeRule(true, RelFactories.LOGICAL_BUILDER);
    private final boolean force;
    private static Set<String> NON_MERGEABLE_FUNCTION = Sets.newHashSet((Object[])new String[]{"EXPLODE"});

    public KapProjectMergeRule(boolean force, RelBuilderFactory relBuilderFactory) {
        super(KapProjectMergeRule.operand(Project.class, (RelOptRuleOperand)KapProjectMergeRule.operand(Project.class, (RelOptRuleOperandChildren)KapProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relBuilderFactory, "KapProjectMergeRule" + (force ? ":force_mode" : ""));
        this.force = force;
    }

    @Deprecated
    public KapProjectMergeRule(boolean force, RelFactories.ProjectFactory projectFactory) {
        this(force, RelBuilder.proto((Object[])new Object[]{projectFactory}));
    }

    public void onMatch(RelOptRuleCall call) {
        RelNode input;
        List<RexNode> newProjects;
        List pushedProjects;
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        RelBuilder relBuilder = call.builder();
        if (this.containsNonMergeableExprs(bottomProject) || this.containsNonMergeableExprs(topProject)) {
            return;
        }
        Permutation topPermutation = topProject.getPermutation();
        if (topPermutation != null) {
            if (topPermutation.isIdentity()) {
                return;
            }
            Permutation bottomPermutation = bottomProject.getPermutation();
            if (bottomPermutation != null) {
                if (bottomPermutation.isIdentity()) {
                    return;
                }
                Permutation product = topPermutation.product(bottomPermutation);
                relBuilder.push(bottomProject.getInput());
                relBuilder.project((Iterable)relBuilder.fields((Mappings.TargetMapping)product), (Iterable)topProject.getRowType().getFieldNames());
                call.transformTo(relBuilder.build());
                return;
            }
        }
        if (!this.force && RexUtil.isIdentity((List)topProject.getProjects(), (RelDataType)topProject.getInput().getRowType())) {
            return;
        }
        if (KylinConfig.getInstanceFromEnv().isProjectMergeWithBloatEnabled()) {
            pushedProjects = RelOptUtil.pushPastProjectUnlessBloat((List)topProject.getProjects(), (Project)bottomProject, (int)KylinConfig.getInstanceFromEnv().getProjectMergeRuleBloatThreshold());
            if (pushedProjects == null) {
                return;
            }
        } else {
            pushedProjects = RelOptUtil.pushPastProject((List)topProject.getProjects(), (Project)bottomProject);
        }
        if (RexUtil.isIdentity(newProjects = KapProjectMergeRule.simplify(pushedProjects), (RelDataType)(input = bottomProject.getInput()).getRowType()) && (this.force || input.getRowType().getFieldNames().equals(topProject.getRowType().getFieldNames()))) {
            call.transformTo(input);
            return;
        }
        relBuilder.push(bottomProject.getInput());
        relBuilder.project(newProjects, (Iterable)topProject.getRowType().getFieldNames());
        call.transformTo(relBuilder.build());
    }

    private static List<RexNode> simplify(List<RexNode> projectExprs) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        KapProjectMergeRule.simplifyRecursiveCase().visitList(projectExprs, list);
        return list;
    }

    private static RexShuttle simplifyRecursiveCase() {
        return new RexShuttle(){

            public RexNode visitCall(RexCall call) {
                if (call.getKind() == SqlKind.CASE && call.getOperands().size() == 3) {
                    RexNode op0 = (RexNode)call.getOperands().get(0);
                    RexNode op1 = (RexNode)call.getOperands().get(1);
                    RexNode op2 = (RexNode)call.getOperands().get(2);
                    if (op1 instanceof RexCall && ((RexCall)op1).getKind() == SqlKind.CASE && ((RexCall)op1).getOperands().size() == 3 && RexUtil.eq((RexNode)op0, (RexNode)((RexNode)((RexCall)op1).getOperands().get(0))) && RexUtil.eq((RexNode)op2, (RexNode)((RexNode)((RexCall)op1).getOperands().get(2)))) {
                        return this.visitCall((RexCall)op1);
                    }
                    if (op2 instanceof RexCall && ((RexCall)op2).getKind() == SqlKind.CASE && ((RexCall)op2).getOperands().size() == 3 && RexUtil.eq((RexNode)op0, (RexNode)((RexNode)((RexCall)op2).getOperands().get(0))) && RexUtil.eq((RexNode)op1, (RexNode)((RexNode)((RexCall)op2).getOperands().get(1)))) {
                        return this.visitCall((RexCall)op2);
                    }
                }
                return super.visitCall(call);
            }
        };
    }

    private boolean containsNonMergeableExprs(Project project) {
        for (RexNode expr : project.getProjects()) {
            if (!this.containsNonMergeableExprs(expr)) continue;
            return true;
        }
        return false;
    }

    private boolean containsNonMergeableExprs(RexNode rexNode) {
        if (rexNode instanceof RexCall) {
            if (NON_MERGEABLE_FUNCTION.contains(((RexCall)rexNode).getOperator().getName())) {
                return true;
            }
            for (RexNode operand : ((RexCall)rexNode).getOperands()) {
                if (!this.containsNonMergeableExprs(operand)) continue;
                return true;
            }
        }
        return false;
    }
}

