/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.rules.PushProjector;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.tools.RelBuilderFactory;

public class KapProjectJoinTransposeRule
extends RelOptRule {
    public static final KapProjectJoinTransposeRule INSTANCE = new KapProjectJoinTransposeRule(new SkipOverConidtion(), RelFactories.LOGICAL_BUILDER);
    public static final String KY = "_KY_";
    private final PushProjector.ExprCondition preserveExprCondition;

    public KapProjectJoinTransposeRule(PushProjector.ExprCondition preserveExprCondition, RelBuilderFactory relFactory) {
        super(KapProjectJoinTransposeRule.operand(Project.class, (RelOptRuleOperand)KapProjectJoinTransposeRule.operand(Join.class, (RelOptRuleOperandChildren)KapProjectJoinTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), relFactory, null);
        this.preserveExprCondition = preserveExprCondition;
    }

    private boolean projectSameInputFields(Project originProject, Join originJoin) {
        List inputFields = originJoin.getRowType().getFieldList();
        Iterator inputIterator = inputFields.iterator();
        Iterator projectsIterator = originProject.getProjects().iterator();
        while (inputIterator.hasNext()) {
            RelDataTypeField inputField = (RelDataTypeField)inputIterator.next();
            if (inputField.getName().contains(KY)) continue;
            if (!projectsIterator.hasNext()) {
                return false;
            }
            RexNode project = (RexNode)projectsIterator.next();
            if (!(project instanceof RexInputRef)) {
                return false;
            }
            RelDataTypeField projectField = (RelDataTypeField)inputFields.get(((RexInputRef)project).getIndex());
            if (projectField.equals(inputField)) continue;
            return false;
        }
        return !projectsIterator.hasNext();
    }

    public void onMatch(RelOptRuleCall call) {
        Project origProj = (Project)call.rel(0);
        Join join = (Join)call.rel(1);
        if (join instanceof SemiJoin) {
            return;
        }
        if (this.projectSameInputFields(origProj, join)) {
            return;
        }
        PushProjector pushProject = new PushProjector(origProj, join.getCondition(), (RelNode)join, this.preserveExprCondition, call.builder());
        if (pushProject.locateAllRefs()) {
            return;
        }
        Project leftProjRel = pushProject.createProjectRefsAndExprs(join.getLeft(), true, false);
        Project rightProjRel = pushProject.createProjectRefsAndExprs(join.getRight(), true, true);
        RexNode newJoinFilter = null;
        int[] adjustments = pushProject.getAdjustments();
        if (join.getCondition() != null) {
            ArrayList projJoinFieldList = new ArrayList();
            projJoinFieldList.addAll(join.getSystemFieldList());
            projJoinFieldList.addAll(leftProjRel.getRowType().getFieldList());
            projJoinFieldList.addAll(rightProjRel.getRowType().getFieldList());
            newJoinFilter = pushProject.convertRefsAndExprs(join.getCondition(), projJoinFieldList, adjustments);
        }
        Join newJoinRel = join.copy(join.getTraitSet(), newJoinFilter, (RelNode)leftProjRel, (RelNode)rightProjRel, join.getJoinType(), join.isSemiJoinDone());
        RelNode topProject = pushProject.createNewProject((RelNode)newJoinRel, adjustments);
        call.transformTo(topProject);
    }

    private static class SkipOverConidtion
    extends PredicateImpl<RexNode>
    implements PushProjector.ExprCondition {
        private SkipOverConidtion() {
        }

        public boolean test(RexNode expr) {
            return !(expr instanceof RexOver);
        }
    }
}

