/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.kylin.query.relnode.KapJoinRel;
import org.apache.kylin.query.util.RexUtils;

public class KapEquiJoinConditionFixRule
extends RelOptRule {
    public static final KapEquiJoinConditionFixRule INSTANCE = new KapEquiJoinConditionFixRule();

    private KapEquiJoinConditionFixRule() {
        super(KapEquiJoinConditionFixRule.operand(KapJoinRel.class, (RelOptRuleOperandChildren)KapEquiJoinConditionFixRule.any()), RelFactories.LOGICAL_BUILDER, "KapEquiJoinConditionFixRule:join");
    }

    public void onMatch(RelOptRuleCall call) {
        KapJoinRel join = (KapJoinRel)call.rel(0);
        List conditions = RelOptUtil.conjunctions((RexNode)join.getCondition());
        if (conditions.isEmpty()) {
            return;
        }
        boolean conditionModified = false;
        for (int i = 0; i < conditions.size(); ++i) {
            RexNode stripped = RexUtils.stripOffCastInColumnEqualPredicate((RexNode)((RexNode)conditions.get(i)));
            if (stripped == conditions.get(i)) continue;
            conditionModified = true;
            conditions.set(i, stripped);
        }
        if (conditionModified) {
            RexBuilder rexBuilder = join.getCluster().getRexBuilder();
            RexNode composed = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)conditions, (boolean)false);
            call.transformTo((RelNode)join.copy(join.getTraitSet(), composed, join.getLeft(), join.getRight(), join.getJoinType(), join.isSemiJoinDone()));
        }
    }
}

