/*
 * Decompiled with CFR 0.152.
 */
package io.kyligence.kap.query.optrule;

import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlAvgAggFunction;
import org.apache.kylin.query.relnode.KapAggregateRel;
import org.apache.kylin.query.relnode.OLAPRel;

public class KapAggregateRule
extends ConverterRule {
    public static final ConverterRule INSTANCE = new KapAggregateRule();

    public KapAggregateRule() {
        super(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)OLAPRel.CONVENTION, "KapAggregateRule");
    }

    public RelNode convert(RelNode rel) {
        LogicalAggregate agg = (LogicalAggregate)rel;
        if (this.containsAvg(agg)) {
            return null;
        }
        RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)OLAPRel.CONVENTION).simplify();
        RelNode convertedInput = agg.getInput() instanceof HepRelVertex ? agg.getInput() : KapAggregateRule.convert((RelNode)agg.getInput(), (RelTrait)OLAPRel.CONVENTION);
        try {
            return new KapAggregateRel(agg.getCluster(), traitSet, convertedInput, agg.indicator, agg.getGroupSet(), (List)agg.getGroupSets(), agg.getAggCallList());
        }
        catch (InvalidRelException e) {
            throw new IllegalStateException("Can't create OLAPAggregateRel!", e);
        }
    }

    private boolean containsAvg(LogicalAggregate agg) {
        for (AggregateCall call : agg.getAggCallList()) {
            SqlAggFunction func = call.getAggregation();
            if (!(func instanceof SqlAvgAggFunction)) continue;
            return true;
        }
        return false;
    }
}

